/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class SmallToolTipInfoButton {
    private final SmallTabButton _btnShowToolTip;
    private String _infoText;
    private Popup _popup;
    private Timer _timer;

    public SmallToolTipInfoButton(String infoText) {
        this._infoText = infoText;
        this._btnShowToolTip = new SmallTabButton(null, this.getSmallInfoIcon());
        Dimension size = new Dimension(16, 16);
        this._btnShowToolTip.setPreferredSize(size);
        this._btnShowToolTip.setMinimumSize(size);
        this._btnShowToolTip.setMaximumSize(size);
        this._btnShowToolTip.addActionListener(e -> this.showTooltipLikePopup());
    }

    public SmallTabButton getButton() {
        return this._btnShowToolTip;
    }

    private void showTooltipLikePopup() {
        if (null != this._popup) {
            this._popup.hide();
            this._popup = null;
            this._timer.stop();
            return;
        }
        Point parentScreenLocation = GUIUtils.getScreenLocationFor(this._btnShowToolTip);
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText(this._infoText);
        toolTip.setComponent(this._btnShowToolTip);
        this._popup = PopupFactory.getSharedInstance().getPopup(this._btnShowToolTip, toolTip, parentScreenLocation.x + this._btnShowToolTip.getWidth(), parentScreenLocation.y + this._btnShowToolTip.getHeight());
        this._popup.show();
        this._timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmallToolTipInfoButton.this.onTimer();
            }
        });
        this._timer.setRepeats(false);
        this._timer.start();
    }

    private void onTimer() {
        if (null != this._popup) {
            this._popup.hide();
            this._popup = null;
        }
    }

    private ImageIcon getSmallInfoIcon() {
        return Main.getApplication().getResources().getIcon("small_info");
    }
}

