/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolderState;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class AliasSortState {
    private final TreeModelListener _treeModelListener;
    private AliasFolderState _stateBeforeSort;
    private Direction _currentDirection;
    private JTree _tree;

    public AliasSortState(JTree tree) {
        this._tree = tree;
        this._treeModelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                AliasSortState.this._stateBeforeSort = null;
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AliasSortState.this._stateBeforeSort = null;
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AliasSortState.this._stateBeforeSort = null;
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AliasSortState.this._stateBeforeSort = null;
            }
        };
        this._tree.getModel().addTreeModelListener(this._treeModelListener);
    }

    public void disableListener() {
        this._tree.getModel().removeTreeModelListener(this._treeModelListener);
    }

    public void enableListener() {
        this._tree.getModel().addTreeModelListener(this._treeModelListener);
    }

    public AliasFolderState sort(AliasFolderState state) {
        if (null == this._stateBeforeSort) {
            this._stateBeforeSort = Utilities.cloneObject(state);
            this._currentDirection = Direction.ASC;
        } else {
            this._currentDirection = this._currentDirection.next();
        }
        if (this._currentDirection == Direction.ASC) {
            state.sort(true);
        } else if (this._currentDirection == Direction.DESC) {
            state.sort(false);
        } else {
            state = Utilities.cloneObject(this._stateBeforeSort);
        }
        return state;
    }

    private static enum Direction {
        ASC,
        DESC,
        ORIG;


        Direction next() {
            for (int i = 0; i < Direction.values().length; ++i) {
                if (this != Direction.values()[i]) continue;
                if (i < Direction.values().length - 1) {
                    return Direction.values()[++i];
                }
                return Direction.values()[0];
            }
            throw new IllegalStateException("Can never happen");
        }
    }
}

