/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.fife.ui.dockablewindows.DockableWindowConstants;
import org.fife.ui.dockablewindows.DockableWindowEvent;
import org.fife.ui.dockablewindows.DockableWindowListener;

public class DockableWindow
extends JPanel
implements DockableWindowConstants {
    public static final String ACTIVE_PROPERTY = "DockableWindowActive";
    public static final String NAME_PROPERTY = "DockableWindowName";
    public static final String TITLE_PROPERTY = "DockableWindowTitle";
    private int position = 1;
    private boolean active;
    private Component primaryComponent;
    private String dockableWindowName;
    private String dockableWindowTitle;
    private Icon icon;
    private static final String MSG = "org.fife.ui.dockablewindows.DockableWindows";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.dockablewindows.DockableWindows");

    public DockableWindow() {
    }

    public DockableWindow(LayoutManager layout) {
        super(layout);
    }

    public DockableWindow(String name) {
        this.setDockableWindowName(name);
    }

    public DockableWindow(String name, LayoutManager layout) {
        super(layout);
        this.setDockableWindowName(name);
    }

    public void addDockableWindowListener(DockableWindowListener l) {
        this.listenerList.add(DockableWindowListener.class, l);
    }

    protected void firePositionChanged(DockableWindowEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableWindowListener.class) continue;
            ((DockableWindowListener)listeners[i + 1]).dockableWindowPositionChanged(e);
        }
    }

    protected void firePositionWillChange(DockableWindowEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableWindowListener.class) continue;
            ((DockableWindowListener)listeners[i + 1]).dockableWindowPositionWillChange(e);
        }
    }

    public boolean focused() {
        if (this.primaryComponent != null) {
            return this.primaryComponent.requestFocusInWindow();
        }
        return false;
    }

    public String getDockableWindowName() {
        return this.dockableWindowName;
    }

    public String getDockableWindowTitle() {
        return this.dockableWindowTitle != null ? this.dockableWindowTitle : this.getDockableWindowName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getPosition() {
        return this.position;
    }

    static String getString(String key) {
        return msg.getString(key);
    }

    public boolean isActive() {
        return this.active;
    }

    public static final boolean isValidPosition(int pos) {
        return pos == 0 || pos == 1 || pos == 2 || pos == 3 || pos == 4;
    }

    public void removeDockableWindowListener(DockableWindowListener l) {
        this.listenerList.remove(DockableWindowListener.class, l);
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.firePropertyChange(ACTIVE_PROPERTY, !active, active);
        }
    }

    public void setDockableWindowName(String name) {
        if (name == null && this.dockableWindowName != null || name != null && !name.equals(this.dockableWindowName)) {
            String old = this.dockableWindowName;
            this.dockableWindowName = name;
            this.firePropertyChange(NAME_PROPERTY, old, this.dockableWindowName);
        }
    }

    public void setDockableWindowTitle(String title) {
        if (title == null && this.dockableWindowTitle != null || title != null && !title.equals(this.dockableWindowTitle)) {
            String old = this.dockableWindowTitle;
            this.dockableWindowTitle = title;
            this.firePropertyChange(TITLE_PROPERTY, old, this.dockableWindowTitle);
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setPosition(int newPos) {
        if (newPos != this.position && DockableWindow.isValidPosition(newPos)) {
            DockableWindowEvent e = new DockableWindowEvent(this, this.position, newPos);
            this.firePositionWillChange(e);
            this.position = newPos;
            this.firePositionChanged(e);
        }
    }

    public void setPrimaryComponent(Component primary) {
        this.primaryComponent = primary;
    }

    public String toString() {
        return "[DockableWindow: name=" + this.getDockableWindowName() + ", active=" + this.isActive() + ", pos=" + this.getPosition() + "]";
    }
}

