/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.operators.ProjectionList;
import unity.query.LQNode;

public class Projection
extends Operator {
    private static final long serialVersionUID = 1L;
    protected Expression[] expressionList;
    private Operator input;

    public Projection(Operator operator, Expression[] expressionArray, Relation relation, LQNode lQNode) {
        super(new Operator[]{operator}, 0L);
        this.input = operator;
        this.expressionList = expressionArray;
        this.queryNode = lQNode;
        this.setOutputRelation(relation);
    }

    public Projection(Operator operator, ProjectionList projectionList) {
        super(new Operator[]{operator}, 0L);
        this.input = operator;
        this.outputRelation = new Relation(new Attribute[projectionList.getNumAttributes()]);
        this.expressionList = projectionList.buildExpressionList(this.outputRelation);
    }

    @Override
    public void init() throws SQLException {
        this.input.init();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (!this.input.next(tuple)) {
            return false;
        }
        Object[] objectArray = new Object[this.expressionList.length];
        for (int i = 0; i < this.expressionList.length; ++i) {
            if (this.expressionList[i] == null) continue;
            objectArray[i] = this.expressionList[i].evaluate(tuple);
        }
        this.incrementRowsOut();
        tuple.setValues(objectArray);
        tuple.setRelation(this.outputRelation);
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("PROJECT: ");
        if (this.expressionList != null && this.input != null) {
            stringBuilder.append(this.expressionList[0].toString(this.input.getOutputRelation()));
            for (int i = 1; i < this.expressionList.length; ++i) {
                stringBuilder.append(", " + this.expressionList[i].toString(this.input.getOutputRelation()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "PROJECTION";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input.getRows();
        return (double)l * 1.0;
    }
}

