/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class AutoResizingTextArea
extends JTextArea {
    public static final int DEFAULT_MAX_ROWS = 20;
    public static final int DEFAULT_MIN_ROWS = 1;
    private int _maxRows;
    private int _minRows;

    public AutoResizingTextArea() {
        this(1, 20);
    }

    public AutoResizingTextArea(int minRows) {
        this(minRows, 20);
    }

    public AutoResizingTextArea(int minRows, int maxRows) {
        this.setMinRows(minRows);
        this.setMaxRows(maxRows);
        this.setRows(minRows);
        this.setupDocument();
    }

    public AutoResizingTextArea(String text) {
        this();
        this.setText(text);
    }

    public AutoResizingTextArea(int minRows, int maxRows, int columns) {
        this(minRows, maxRows);
        this.setMinRows(minRows);
        this.setMaxRows(maxRows);
        this.setColumns(columns);
    }

    public AutoResizingTextArea(String text, int minRows, int maxRows, int columns) {
        this(minRows, maxRows, columns);
        this.setText(text);
    }

    public AutoResizingTextArea(Document doc) {
        this();
        this.setDocument(doc);
    }

    public AutoResizingTextArea(Document doc, String text, int minRows, int maxRows, int columns) {
        super(doc, text, minRows, columns);
        this.setMaxRows(maxRows);
        this.setMinRows(minRows);
        this.setupDocument();
    }

    @Override
    public void setRows(int rows) {
        int oldRow = super.getRows();
        int newRow = this.clipRowCount(rows);
        super.setRows(newRow);
        this.numberOfRowsUpdated(oldRow, newRow);
    }

    protected void numberOfRowsUpdated(int oldRow, int newRow) {
        Container parent;
        JScrollPane scroll = this.getParentScrollPane();
        if (scroll != null && (parent = scroll.getParent()) != null && parent instanceof JComponent) {
            JComponent component = (JComponent)parent;
            component.revalidate();
        }
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int minRows) {
        this._minRows = minRows;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    private void setupDocument() {
        this.getDocument().addDocumentListener(new ResizingDocumentListener());
    }

    private int clipRowCount(int rows) {
        int r = Math.min(this._maxRows, rows);
        r = Math.max(this._minRows, r);
        return r;
    }

    private void updateSize(DocumentEvent e) {
        Element[] roots = e.getDocument().getRootElements();
        Element root = roots[0];
        int rowCount = root.getElementCount();
        this.setRows(this.clipRowCount(rowCount));
    }

    private JScrollPane getParentScrollPane() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            return (JScrollPane)parent.getParent();
        }
        return null;
    }

    private class ResizingDocumentListener
    implements DocumentListener {
        private ResizingDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize(e);
        }
    }
}

