/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsfDirectoryStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class MsfDirectoryStream700
extends AbstractMsfDirectoryStream {
    MsfDirectoryStream700(AbstractMsf msf) {
        super(msf);
    }

    @Override
    void deserializeStreamInfo(PdbByteReader reader, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        this.deserializeStreamLengthAndMapTableAddress(reader);
        int subStreamLength = AbstractMsf.floorDivisionWithLog2Divisor(this.streamLength, this.msf.getLog2PageSize()) * this.msf.getPageNumberSize();
        MsfStream subStream = new MsfStream(this.msf, subStreamLength);
        subStream.deserializePageNumbers(reader, monitor);
        byte[] bytes = subStream.read(0, subStreamLength, monitor);
        PdbByteReader pageNumberReader = new PdbByteReader(bytes);
        this.deserializePageNumbers(pageNumberReader, monitor);
    }
}

