/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.actions.PopupActionProvider;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerPlaceBreakpointDialog;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.LogicalBreakpointsChangeListener;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.TraceRecorder;
import ghidra.app.util.viewer.listingpanel.MarkerClickedListener;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.util.Msg;
import java.awt.Color;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

@PluginInfo(shortDescription="Debugger breakpoint marker service plugin", description="Marks logical breakpoints and provides actions in the listings", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerLogicalBreakpointService.class, MarkerService.class})
public class DebuggerBreakpointMarkerPlugin
extends Plugin
implements PopupActionProvider {
    private MarkerService markerService;
    private DebuggerLogicalBreakpointService breakpointService;
    @AutoServiceConsumed
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Enabled Breakpoint Markers"}, description="Background color for memory at an enabled breakpoint", help=@HelpInfo(anchor="colors"))
    private Color breakpointEnabledMarkerColor = DebuggerResources.DEFAULT_COLOR_ENABLED_BREAKPOINT_MARKERS;
    @AutoOptionDefined(name={"Colors.Enabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an enabled breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointEnabledColoringBackground = true;
    @AutoOptionDefined(name={"Colors.Disabled Breakpoint Markers"}, description="Background color for memory at a disabled breakpoint", help=@HelpInfo(anchor="colors"))
    private Color breakpointDisabledMarkerColor = DebuggerResources.DEFAULT_COLOR_DISABLED_BREAKPOINT_MARKERS;
    @AutoOptionDefined(name={"Colors.Disabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at a disabled breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointDisabledColoringBackground = false;
    @AutoOptionDefined(name={"Colors.Ineffective Enabled Breakpoint Markers"}, description="Background color for memory at an enabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private Color breakpointIneffectiveEMarkerColor = DebuggerResources.DEFAULT_COLOR_INEFFECTIVE_E_BREAKPOINT_MARKERS;
    @AutoOptionDefined(name={"Colors.Ineffective Enabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an enabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointIneffectiveEColoringBackground = true;
    @AutoOptionDefined(name={"Colors.Ineffective Disabled Breakpoint Markers"}, description="Background color for memory at an disabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private Color breakpointIneffectiveDMarkerColor = DebuggerResources.DEFAULT_COLOR_INEFFECTIVE_D_BREAKPOINT_MARKERS;
    @AutoOptionDefined(name={"Colors.Ineffective Disabled Breakpoint Markers Have Background"}, description="Whether or not to color background for memory at an disabled, but ineffective, breakpoint", help=@HelpInfo(anchor="colors"))
    private boolean breakpointIneffectiveDColoringBackground = false;
    private final AutoOptions.Wiring autoOptionsWiring;
    private final Map<Program, BreakpointMarkerSets> markersByProgram = new HashMap<Program, BreakpointMarkerSets>();
    private final LogicalBreakpointsChangeListener updateMarksListener = new UpdateMarksBreakpointRecordChangeListener();
    private final MarkerClickedListener markerClickedListener = new ToggleBreakpointsMarkerClickedListener();
    private final AsyncDebouncer<Void> updateDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    SetBreakpointAction actionSetSoftwareBreakpoint;
    SetBreakpointAction actionSetExecuteBreakpoint;
    SetBreakpointAction actionSetReadWriteBreakpoint;
    SetBreakpointAction actionSetReadBreakpoint;
    SetBreakpointAction actionSetWriteBreakpoint;
    ToggleBreakpointAction actionToggleBreakpoint;
    EnableBreakpointAction actionEnableBreakpoint;
    DisableBreakpointAction actionDisableBreakpoint;
    ClearBreakpointAction actionClearBreakpoint;
    DebuggerPlaceBreakpointDialog placeBreakpointDialog = new DebuggerPlaceBreakpointDialog();

    protected static Address computeAddressFromContext(ActionContext context) {
        if (context == null) {
            return null;
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramSelection sel;
            AddressRange range;
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            if (ctx.hasSelection() && (range = (sel = ctx.getSelection()).getRangeContaining(ctx.getAddress())) != null) {
                return range.getMinAddress();
            }
            return ctx.getAddress();
        }
        Object obj = context.getContextObject();
        if (obj instanceof MarkerLocation) {
            MarkerLocation ml = (MarkerLocation)obj;
            return ml.getAddr();
        }
        return null;
    }

    protected static ProgramLocation getLocationFromContext(ActionContext context) {
        if (context == null) {
            return null;
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramSelection sel;
            AddressRange range;
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            if (ctx.hasSelection() && (range = (sel = ctx.getSelection()).getRangeContaining(ctx.getAddress())) != null) {
                return new ProgramLocation(ctx.getProgram(), range.getMinAddress());
            }
            return ctx.getLocation();
        }
        Object obj = context.getContextObject();
        if (obj instanceof MarkerLocation) {
            MarkerLocation ml = (MarkerLocation)obj;
            return new ProgramLocation(ml.getProgram(), ml.getAddr());
        }
        return null;
    }

    protected static long computeLengthFromContext(ActionContext context) {
        if (context == null) {
            return 1L;
        }
        if (context instanceof ProgramLocationActionContext) {
            ProgramSelection sel;
            AddressRange range;
            ProgramLocationActionContext ctx = (ProgramLocationActionContext)context;
            if (ctx.hasSelection() && (range = (sel = ctx.getSelection()).getRangeContaining(ctx.getAddress())) != null) {
                return range.getLength();
            }
            CodeUnit cu = ctx.getCodeUnit();
            if (cu instanceof Data) {
                return cu.getLength();
            }
        }
        return 1L;
    }

    protected static boolean contextHasLocation(ActionContext context) {
        return DebuggerBreakpointMarkerPlugin.getLocationFromContext(context) != null;
    }

    protected static Trace getTraceFromContext(ActionContext context) {
        ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
        if (loc == null) {
            return null;
        }
        Program progOrView = loc.getProgram();
        if (progOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)progOrView;
            return view.getTrace();
        }
        return null;
    }

    protected static boolean contextHasTrace(ActionContext context) {
        return DebuggerBreakpointMarkerPlugin.getTraceFromContext(context) != null;
    }

    protected static long computeDefaultLength(ActionContext context, Collection<TraceBreakpointKind> selected) {
        if (selected.isEmpty() || selected.contains(TraceBreakpointKind.HW_EXECUTE) || selected.contains(TraceBreakpointKind.SW_EXECUTE)) {
            return 1L;
        }
        return DebuggerBreakpointMarkerPlugin.computeLengthFromContext(context);
    }

    protected static Set<TraceBreakpointKind> computeDefaultKinds(ActionContext ctx, Collection<TraceBreakpointKind> supported) {
        if (supported.isEmpty()) {
            return Set.of();
        }
        long length = DebuggerBreakpointMarkerPlugin.computeLengthFromContext(ctx);
        if (length == 1L) {
            ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getLocationFromContext(ctx);
            Listing listing = loc.getProgram().getListing();
            CodeUnit cu = listing.getCodeUnitContaining(loc.getAddress());
            if (cu instanceof Instruction) {
                if (supported.contains(TraceBreakpointKind.SW_EXECUTE)) {
                    return Set.of(TraceBreakpointKind.SW_EXECUTE);
                }
                if (supported.contains(TraceBreakpointKind.HW_EXECUTE)) {
                    return Set.of(TraceBreakpointKind.HW_EXECUTE);
                }
                return Set.of();
            }
            Data data = (Data)cu;
            if (!data.isDefined()) {
                if (supported.size() == 1) {
                    return Set.copyOf(supported);
                }
                return Set.of();
            }
        }
        HashSet<TraceBreakpointKind> result = new HashSet<TraceBreakpointKind>(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE));
        result.retainAll(supported);
        return result;
    }

    protected static LogicalBreakpoint.Enablement computeEnablement(LogicalBreakpoint breakpoint, Program programOrView) {
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            return breakpoint.computeEnablementForTrace(view.getTrace());
        }
        return breakpoint.computeEnablement();
    }

    protected LogicalBreakpoint.Enablement computeEnablement(ProgramLocation loc) {
        Program programOrView = loc.getProgram();
        if (programOrView instanceof TraceProgramView) {
            return this.breakpointService.computeEnablement(loc).getPrimary();
        }
        Set<LogicalBreakpoint> bs = this.breakpointService.getBreakpointsAt(loc);
        return this.breakpointService.computeEnablement(bs);
    }

    public DebuggerBreakpointMarkerPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)this);
        this.updateDebouncer.addListener(__ -> SwingUtilities.invokeLater(() -> this.updateAllMarks()));
        tool.addPopupActionProvider((PopupActionProvider)this);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    @AutoOptionConsumed(name={"Colors.Enabled Breakpoint Markers"})
    private void setEnabledBreakpointMarkerColor(Color breakpointMarkerColor) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setEnabledMarkerColor(breakpointMarkerColor);
        }
    }

    @AutoOptionConsumed(name={"Colors.Enabled Breakpoint Markers Have Background"})
    private void setEnabledBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setEnabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Disabled Breakpoint Markers"})
    private void setDisabledBreakpointMarkerColor(Color breakpointMarkerColor) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setDisabledMarkerColor(breakpointMarkerColor);
        }
    }

    @AutoOptionConsumed(name={"Colors.Disabled Breakpoint Markers Have Background"})
    private void setDisabledBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setDisabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Enabled Breakpoint Markers"})
    private void setIneffectiveEBreakpointMarkerColor(Color breakpointMarkerColor) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveEnabledMarkerColor(breakpointMarkerColor);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Enabled Breakpoint Markers Have Background"})
    private void setIneffectiveEBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveEnabledColoringBackground(breakpointColoringBackground);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Disabled Breakpoint Markers"})
    private void setIneffectiveDBreakpointMarkerColor(Color breakpointMarkerColor) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveDisabledMarkerColor(breakpointMarkerColor);
        }
    }

    @AutoOptionConsumed(name={"Colors.Ineffective Disabled Breakpoint Markers Have Background"})
    private void setIneffectiveDBreakpointMarkerBackground(boolean breakpointColoringBackground) {
        for (BreakpointMarkerSets markers : this.markersByProgram.values()) {
            markers.setIneffectiveDisabledColoringBackground(breakpointColoringBackground);
        }
    }

    protected TraceRecorder getRecorderFromContext(ActionContext context) {
        if (this.modelService == null) {
            return null;
        }
        Trace trace = DebuggerBreakpointMarkerPlugin.getTraceFromContext(context);
        return this.modelService.getRecorder(trace);
    }

    protected Set<TraceRecorder> getRecordersFromContext(ActionContext context) {
        TraceRecorder single = this.getRecorderFromContext(context);
        if (single != null) {
            return Set.of(single);
        }
        if (this.mappingService == null || this.modelService == null) {
            return Set.of();
        }
        ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
        if (loc == null) {
            return Set.of();
        }
        HashSet<TraceRecorder> result = new HashSet<TraceRecorder>();
        for (TraceLocation tloc : this.mappingService.getOpenMappedLocations(loc)) {
            TraceRecorder rec = this.modelService.getRecorder(tloc.getTrace());
            if (rec == null) continue;
            result.add(rec);
        }
        return result;
    }

    protected boolean contextHasRecorder(ActionContext ctx) {
        return this.getRecorderFromContext(ctx) != null;
    }

    protected boolean contextCanManipulateBreakpoints(ActionContext ctx) {
        if (this.breakpointService == null) {
            return false;
        }
        if (!DebuggerBreakpointMarkerPlugin.contextHasLocation(ctx)) {
            return false;
        }
        return !DebuggerBreakpointMarkerPlugin.contextHasTrace(ctx) || this.contextHasRecorder(ctx);
    }

    protected Set<TraceBreakpointKind> getSupportedKindsFromContext(ActionContext context) {
        Set<TraceRecorder> recorders = this.getRecordersFromContext(context);
        if (recorders.isEmpty()) {
            return EnumSet.allOf(TraceBreakpointKind.class);
        }
        return recorders.stream().flatMap(rec -> rec.getSupportedBreakpointKinds().stream()).collect(Collectors.toSet());
    }

    protected void doToggleBreakpointsAt(String title, ActionContext context) {
        if (this.breakpointService == null) {
            return;
        }
        ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
        if (loc == null) {
            return;
        }
        Set<LogicalBreakpoint> bs = this.breakpointService.getBreakpointsAt(loc);
        if (bs == null || bs.isEmpty()) {
            Set<TraceBreakpointKind> supported = this.getSupportedKindsFromContext(context);
            if (supported.isEmpty()) {
                this.breakpointError(title, "It seems this target does not support breakpoints.");
                return;
            }
            Set<TraceBreakpointKind> kinds = DebuggerBreakpointMarkerPlugin.computeDefaultKinds(context, supported);
            long length = DebuggerBreakpointMarkerPlugin.computeDefaultLength(context, kinds);
            this.placeBreakpointDialog.prompt(this.tool, this.breakpointService, title, loc, length, kinds);
            return;
        }
        LogicalBreakpoint.Enablement en = this.breakpointService.computeEnablement(bs, loc);
        Trace trace = DebuggerBreakpointMarkerPlugin.getTraceFromContext(context);
        boolean mapped = this.breakpointService.anyMapped(bs, trace);
        LogicalBreakpoint.Enablement toggled = en.getToggled(mapped && trace == null);
        if (toggled.enabled) {
            this.breakpointService.enableAll(bs, trace).exceptionally(ex -> {
                this.breakpointError(title, "Could not enable breakpoints", (Throwable)ex);
                return null;
            });
        } else {
            this.breakpointService.disableAll(bs, trace).exceptionally(ex -> {
                this.breakpointError(title, "Could not disable breakpoints", (Throwable)ex);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BreakpointMarkerSets createMarkers(Program program) {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            BreakpointMarkerSets newSets = new BreakpointMarkerSets(program);
            BreakpointMarkerSets oldSets = this.markersByProgram.put(program, newSets);
            assert (oldSets == null);
            return newSets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMarkers(Program program) {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            BreakpointMarkerSets oldSets = this.markersByProgram.remove(program);
            oldSets.dispose();
        }
    }

    protected void doMarks(BreakpointMarkerSets marks, Map<Address, Set<LogicalBreakpoint>> byAddress, Function<LogicalBreakpoint, LogicalBreakpoint.Enablement> enFunc) {
        for (Map.Entry<Address, Set<LogicalBreakpoint>> bEnt : byAddress.entrySet()) {
            HashMap<Long, LogicalBreakpoint.Enablement> en = new HashMap<Long, LogicalBreakpoint.Enablement>();
            for (LogicalBreakpoint lb : bEnt.getValue()) {
                en.compute(lb.getLength(), (l, e) -> (e == null ? LogicalBreakpoint.Enablement.NONE : e).sameAdddress((LogicalBreakpoint.Enablement)((Object)((Object)enFunc.apply(lb)))));
            }
            Address start = bEnt.getKey();
            for (Map.Entry eEnt : en.entrySet()) {
                Address end = start.add((Long)eEnt.getKey() - 1L);
                MarkerSet set = marks.get((LogicalBreakpoint.Enablement)((Object)eEnt.getValue()));
                if (set == null) continue;
                set.add(start, end);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllMarks() {
        Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
        synchronized (map) {
            for (BreakpointMarkerSets breakpointMarkerSets : this.markersByProgram.values()) {
                breakpointMarkerSets.clear();
            }
            if (this.breakpointService == null) {
                return;
            }
            for (Map.Entry entry : this.markersByProgram.entrySet()) {
                Program program = (Program)entry.getKey();
                BreakpointMarkerSets marks = (BreakpointMarkerSets)entry.getValue();
                if (program instanceof TraceProgramView) {
                    TraceProgramView view = (TraceProgramView)program;
                    Trace trace = view.getTrace();
                    this.doMarks(marks, this.breakpointService.getBreakpoints(trace), lb -> lb.computeEnablementForTrace(trace));
                    continue;
                }
                this.doMarks(marks, this.breakpointService.getBreakpoints(program), lb -> lb.computeEnablementForProgram(program));
            }
        }
    }

    @AutoServiceConsumed
    private void setMarkerService(MarkerService markerService) {
        if (this.markerService != null) {
            this.markerService.setMarkerClickedListener(null);
        }
        this.markerService = markerService;
        if (this.markerService != null) {
            this.markerService.setMarkerClickedListener(this.markerClickedListener);
        }
    }

    @AutoServiceConsumed
    private void setLogicalBreakpointService(DebuggerLogicalBreakpointService breakpointService) {
        if (this.breakpointService != null) {
            this.breakpointService.removeChangeListener(this.updateMarksListener);
        }
        this.breakpointService = breakpointService;
        if (this.breakpointService != null) {
            breakpointService.addChangeListener(this.updateMarksListener);
            this.updateAllMarks();
        }
    }

    protected void createActions() {
        this.actionSetSoftwareBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.SW_EXECUTE));
        this.actionSetExecuteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.HW_EXECUTE));
        this.actionSetReadWriteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE));
        this.actionSetReadBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.READ));
        this.actionSetWriteBreakpoint = new SetBreakpointAction(Set.of(TraceBreakpointKind.WRITE));
        this.actionToggleBreakpoint = new ToggleBreakpointAction();
        this.actionEnableBreakpoint = new EnableBreakpointAction();
        this.actionDisableBreakpoint = new DisableBreakpointAction();
        this.actionClearBreakpoint = new ClearBreakpointAction();
        this.tool.setMenuGroup(new String[]{"Set Breakpoint"}, "Dbg6. Breakpoints");
    }

    public List<DockingActionIf> getPopupActions(Tool __, ActionContext context) {
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent evt = (ProgramOpenedPluginEvent)event;
            this.createMarkers(evt.getProgram());
            this.updateAllMarks();
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent evt = (ProgramClosedPluginEvent)event;
            this.removeMarkers(evt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent evt = (TraceOpenedPluginEvent)event;
            TraceVariableSnapProgramView view = evt.getTrace().getProgramView();
            this.createMarkers((Program)view);
            this.updateAllMarks();
        } else if (event instanceof TraceClosedPluginEvent) {
            Map<Program, BreakpointMarkerSets> copyOfMarkers;
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            Trace trace = evt.getTrace();
            Map<Program, BreakpointMarkerSets> map = this.markersByProgram;
            synchronized (map) {
                copyOfMarkers = Map.copyOf(this.markersByProgram);
            }
            for (Map.Entry entry : copyOfMarkers.entrySet()) {
                TraceProgramView view;
                Program program = (Program)entry.getKey();
                if (!(program instanceof TraceProgramView) || (view = (TraceProgramView)program).getTrace() != trace) continue;
                this.removeMarkers((Program)view);
            }
        }
    }

    protected void breakpointError(String title, String message) {
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message);
            return;
        }
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message);
    }

    protected void breakpointError(String title, String message, Throwable ex) {
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), null, (String)title, (Object)message, (Throwable)ex);
            return;
        }
        Msg.error((Object)((Object)this), (Object)message, (Throwable)ex);
        this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message + " (" + ex + ")");
    }

    protected class ClearBreakpointAction
    extends DebuggerResources.AbstractClearBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public ClearBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Clear Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.breakpointService.getBreakpointsAt(location);
            DebuggerBreakpointMarkerPlugin.this.breakpointService.deleteAll(col, DebuggerBreakpointMarkerPlugin.getTraceFromContext(context)).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Clear Breakpoint", "Could not delete breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            LogicalBreakpoint.Enablement en = DebuggerBreakpointMarkerPlugin.this.computeEnablement(location);
            return en != LogicalBreakpoint.Enablement.NONE;
        }
    }

    protected class DisableBreakpointAction
    extends DebuggerResources.AbstractDisableBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public DisableBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Disable Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.breakpointService.getBreakpointsAt(location);
            DebuggerBreakpointMarkerPlugin.this.breakpointService.disableAll(col, DebuggerBreakpointMarkerPlugin.getTraceFromContext(context)).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Disable Breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            LogicalBreakpoint.Enablement en = DebuggerBreakpointMarkerPlugin.this.computeEnablement(location);
            return en != LogicalBreakpoint.Enablement.DISABLED && en != LogicalBreakpoint.Enablement.NONE;
        }
    }

    protected class EnableBreakpointAction
    extends DebuggerResources.AbstractEnableBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public EnableBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setPopupMenuData(new MenuData(new String[]{"Enable Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            Set<LogicalBreakpoint> col = DebuggerBreakpointMarkerPlugin.this.breakpointService.getBreakpointsAt(location);
            DebuggerBreakpointMarkerPlugin.this.breakpointService.enableAll(col, DebuggerBreakpointMarkerPlugin.getTraceFromContext(context)).exceptionally(ex -> {
                DebuggerBreakpointMarkerPlugin.this.breakpointError("Enable Breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            LogicalBreakpoint.Enablement en = DebuggerBreakpointMarkerPlugin.this.computeEnablement(location);
            return en != LogicalBreakpoint.Enablement.ENABLED && en != LogicalBreakpoint.Enablement.NONE;
        }
    }

    protected class SetBreakpointAction
    extends DebuggerResources.AbstractSetBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";
        private final Set<TraceBreakpointKind> kinds;

        public SetBreakpointAction(Set<TraceBreakpointKind> kinds) {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.kinds = kinds;
            this.setPopupMenuData(new MenuData(new String[]{"Set Breakpoint", TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds)}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return;
            }
            ProgramLocation location = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            long length = DebuggerBreakpointMarkerPlugin.computeDefaultLength(context, this.kinds);
            DebuggerBreakpointMarkerPlugin.this.placeBreakpointDialog.prompt(DebuggerBreakpointMarkerPlugin.this.tool, DebuggerBreakpointMarkerPlugin.this.breakpointService, "Set Breakpoint", location, length, this.kinds);
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context)) {
                return false;
            }
            ProgramLocation loc = DebuggerBreakpointMarkerPlugin.getLocationFromContext(context);
            if (!(loc.getProgram() instanceof TraceProgramView)) {
                return true;
            }
            TraceRecorder recorder = DebuggerBreakpointMarkerPlugin.this.getRecorderFromContext(context);
            if (recorder == null) {
                return false;
            }
            return recorder.getSupportedBreakpointKinds().containsAll(this.kinds);
        }
    }

    protected class ToggleBreakpointAction
    extends DebuggerResources.AbstractToggleBreakpointAction {
        public static final String GROUP = "Dbg6. Breakpoints";

        public ToggleBreakpointAction() {
            super(DebuggerBreakpointMarkerPlugin.this);
            this.setKeyBindingData(new KeyBindingData(75, 0));
            this.setPopupMenuData(new MenuData(new String[]{"Toggle Breakpoint"}, ICON, GROUP));
            DebuggerBreakpointMarkerPlugin.this.tool.addAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            DebuggerBreakpointMarkerPlugin.this.doToggleBreakpointsAt("Toggle Breakpoint", context);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerBreakpointMarkerPlugin.this.contextCanManipulateBreakpoints(context);
        }
    }

    private class ToggleBreakpointsMarkerClickedListener
    implements MarkerClickedListener {
        private ToggleBreakpointsMarkerClickedListener() {
        }

        public void markerDoubleClicked(MarkerLocation location) {
            DebuggerBreakpointMarkerPlugin.this.doToggleBreakpointsAt("Toggle Breakpoint", (ActionContext)new ProgramLocationActionContext(null, location.getProgram(), new ProgramLocation(location.getProgram(), location.getAddr()), null, null));
        }
    }

    private class UpdateMarksBreakpointRecordChangeListener
    implements LogicalBreakpointsChangeListener {
        private UpdateMarksBreakpointRecordChangeListener() {
        }

        @Override
        public void breakpointAdded(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }

        @Override
        public void breakpointUpdated(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }

        @Override
        public void breakpointRemoved(LogicalBreakpoint breakpoint) {
            DebuggerBreakpointMarkerPlugin.this.updateDebouncer.contact(null);
        }
    }

    protected class BreakpointMarkerSets {
        final Program program;
        final MarkerSet enabled;
        final MarkerSet disabled;
        final MarkerSet ineffectiveE;
        final MarkerSet ineffectiveD;
        final MarkerSet mixedED;
        final MarkerSet mixedDE;

        protected BreakpointMarkerSets(Program program) {
            this.program = program;
            if (!(program instanceof TraceProgramView)) {
                BookmarkManager manager = program.getBookmarkManager();
                manager.defineType("BreakpointEnabled", DebuggerResources.ICON_BLANK, DebuggerResources.DEFAULT_COLOR_ENABLED_BREAKPOINT_MARKERS, 49);
                manager.defineType("BreakpointDisabled", DebuggerResources.ICON_BLANK, DebuggerResources.DEFAULT_COLOR_ENABLED_BREAKPOINT_MARKERS, 49);
            }
            this.enabled = this.getEnabledMarkerSet();
            this.disabled = this.getDisabledMarkerSet();
            this.ineffectiveE = this.getIneffectiveEMarkerSet();
            this.ineffectiveD = this.getIneffectiveDMarkerSet();
            this.mixedED = this.getMixedEDMarkerSet();
            this.mixedDE = this.getMixedDEMarkerSet();
        }

        private MarkerSet getEnabledMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Enabled Breakpoint", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Enabled Breakpoint", "Enabled Breakpoint", this.program, 50, true, true, true, DebuggerBreakpointMarkerPlugin.this.breakpointEnabledMarkerColor, DebuggerResources.ICON_BREAKPOINT_ENABLED_MARKER, true);
        }

        private MarkerSet getDisabledMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Disabled Breakpoint", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Disabled Breakpoint", "Disabled Breakpoint", this.program, 50, true, false, false, DebuggerBreakpointMarkerPlugin.this.breakpointEnabledMarkerColor, DebuggerResources.ICON_BREAKPOINT_DISABLED_MARKER, false);
        }

        private MarkerSet getIneffectiveEMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Ineffective Enabled Breakpoint", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Ineffective Enabled Breakpoint", "Ineffective Enabled Breakpoint", this.program, 50, true, false, true, DebuggerBreakpointMarkerPlugin.this.breakpointIneffectiveEMarkerColor, DebuggerResources.ICON_BREAKPOINT_INEFFECTIVE_E_MARKER, false);
        }

        private MarkerSet getIneffectiveDMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Ineffective Disabled Breakpoint", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Ineffective Disabled Breakpoint", "Ineffective Disabled Breakpoint", this.program, 50, true, false, false, DebuggerBreakpointMarkerPlugin.this.breakpointIneffectiveDMarkerColor, DebuggerResources.ICON_BREAKPOINT_INEFFECTIVE_D_MARKER, false);
        }

        private MarkerSet getMixedEDMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Mixed Enabled-Disabled Breakpont", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Mixed Enabled-Disabled Breakpont", "Mixed Enabled-Disabled Breakpont", this.program, 50, true, true, true, DebuggerBreakpointMarkerPlugin.this.breakpointEnabledMarkerColor, DebuggerResources.ICON_BREAKPOINT_MIXED_ED_MARKER, false);
        }

        private MarkerSet getMixedDEMarkerSet() {
            MarkerSet set = DebuggerBreakpointMarkerPlugin.this.markerService.getMarkerSet("Mixed Disabled-Enabled Breakpont", this.program);
            if (set != null) {
                return set;
            }
            return DebuggerBreakpointMarkerPlugin.this.markerService.createPointMarker("Mixed Disabled-Enabled Breakpont", "Mixed Disabled-Enabled Breakpont", this.program, 50, true, false, false, DebuggerBreakpointMarkerPlugin.this.breakpointEnabledMarkerColor, DebuggerResources.ICON_BREAKPOINT_MIXED_DE_MARKER, false);
        }

        MarkerSet get(LogicalBreakpoint.Enablement en) {
            switch (en) {
                case ENABLED: {
                    return this.enabled;
                }
                case DISABLED: {
                    return this.disabled;
                }
                case INEFFECTIVE_ENABLED: {
                    return this.ineffectiveE;
                }
                case INEFFECTIVE_DISABLED: {
                    return this.ineffectiveD;
                }
                case ENABLED_DISABLED: {
                    return this.mixedED;
                }
                case DISABLED_ENABLED: {
                    return this.mixedDE;
                }
                case NONE: {
                    return null;
                }
            }
            throw new AssertionError();
        }

        public void setEnabledMarkerColor(Color color) {
            if (this.enabled != null) {
                this.enabled.setMarkerColor(color);
            }
            if (this.mixedED != null) {
                this.mixedED.setMarkerColor(color);
            }
        }

        public void setDisabledMarkerColor(Color color) {
            if (this.disabled != null) {
                this.disabled.setMarkerColor(color);
            }
            if (this.mixedDE != null) {
                this.mixedDE.setMarkerColor(color);
            }
        }

        public void setIneffectiveEnabledMarkerColor(Color color) {
            if (this.ineffectiveE != null) {
                this.ineffectiveE.setMarkerColor(color);
            }
        }

        public void setIneffectiveDisabledMarkerColor(Color color) {
            if (this.ineffectiveD != null) {
                this.ineffectiveD.setMarkerColor(color);
            }
        }

        public void setEnabledColoringBackground(boolean coloringBackground) {
            if (this.enabled != null) {
                this.enabled.setColoringBackground(coloringBackground);
            }
            if (this.mixedED != null) {
                this.mixedED.setColoringBackground(coloringBackground);
            }
        }

        public void setDisabledColoringBackground(boolean coloringBackground) {
            if (this.disabled != null) {
                this.disabled.setColoringBackground(coloringBackground);
            }
            if (this.mixedDE != null) {
                this.mixedDE.setColoringBackground(coloringBackground);
            }
        }

        public void setIneffectiveEnabledColoringBackground(boolean coloringBackground) {
            if (this.ineffectiveE != null) {
                this.ineffectiveE.setColoringBackground(coloringBackground);
            }
        }

        public void setIneffectiveDisabledColoringBackground(boolean coloringBackground) {
            if (this.ineffectiveD != null) {
                this.ineffectiveD.setColoringBackground(coloringBackground);
            }
        }

        public void dispose() {
            if (this.enabled != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.enabled, this.program);
            }
            if (this.disabled != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.disabled, this.program);
            }
            if (this.ineffectiveE != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.ineffectiveE, this.program);
            }
            if (this.ineffectiveD != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.ineffectiveD, this.program);
            }
            if (this.mixedED != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.mixedED, this.program);
            }
            if (this.mixedDE != null) {
                DebuggerBreakpointMarkerPlugin.this.markerService.removeMarker(this.mixedDE, this.program);
            }
        }

        public void clear() {
            if (this.enabled != null) {
                this.enabled.clearAll();
            }
            if (this.disabled != null) {
                this.disabled.clearAll();
            }
            if (this.ineffectiveE != null) {
                this.ineffectiveE.clearAll();
            }
            if (this.ineffectiveD != null) {
                this.ineffectiveD.clearAll();
            }
            if (this.mixedED != null) {
                this.mixedED.clearAll();
            }
            if (this.mixedDE != null) {
                this.mixedDE.clearAll();
            }
        }
    }
}

