/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.RegisterLocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import javax.swing.Icon;

public class PCLocationTrackingSpec
implements RegisterLocationTrackingSpec {
    public static final String CONFIG_NAME = "TRACK_PC";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Track Program Counter";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_PC;
    }

    @Override
    public Register computeRegister(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            return null;
        }
        return trace.getBaseLanguage().getProgramCounter();
    }

    @Override
    public AddressSpace computeDefaultAddressSpace(DebuggerCoordinates coordinates) {
        return coordinates.getTrace().getBaseLanguage().getDefaultSpace();
    }

    public Address computePCViaStack(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        TraceThread thread = coordinates.getThread();
        long snap = coordinates.getSnap();
        TraceStack stack = trace.getStackManager().getLatestStack(thread, snap);
        if (stack == null) {
            return null;
        }
        int level = coordinates.getFrame();
        TraceStackFrame frame = stack.getFrame(level, false);
        if (frame == null) {
            return null;
        }
        return frame.getProgramCounter();
    }

    @Override
    public Address computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates, long emuSnap) {
        Address pc;
        if (coordinates.getTime().isSnapOnly() && (pc = this.computePCViaStack(coordinates)) != null) {
            return pc;
        }
        return RegisterLocationTrackingSpec.super.computeTraceAddress(tool, coordinates, emuSnap);
    }

    @Override
    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        if (stack.getThread() != coordinates.getThread()) {
            return false;
        }
        if (!coordinates.getTime().isSnapOnly()) {
            return false;
        }
        TraceStack curStack = coordinates.getTrace().getStackManager().getLatestStack(stack.getThread(), coordinates.getSnap().longValue());
        return stack == curStack;
    }
}

