/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.util.CollectionUtils;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DebuggerTargetObjectIface(value="Method")
public interface TargetMethod
extends TargetObject {
    public static final String PARAMETERS_ATTRIBUTE_NAME = "_parameters";
    public static final String RETURN_TYPE_ATTRIBUTE_NAME = "_return_type";

    public static TargetParameterMap makeParameters(Stream<ParameterDescription<?>> params) {
        return TargetParameterMap.copyOf(params.collect(Collectors.toMap(p -> p.name, p -> p, (a, b) -> {
            throw new IllegalArgumentException("duplicate parameters: " + a + " and " + b);
        }, LinkedHashMap::new)));
    }

    public static TargetParameterMap makeParameters(Collection<ParameterDescription<?>> params) {
        return TargetMethod.makeParameters(params.stream());
    }

    public static TargetParameterMap makeParameters(ParameterDescription<?> ... params) {
        return TargetMethod.makeParameters(Stream.of(params));
    }

    public static Map<String, ?> validateArguments(Map<String, ParameterDescription<?>> parameters, Map<String, ?> arguments, boolean permitExtras) {
        if (!permitExtras && !parameters.keySet().containsAll(arguments.keySet())) {
            TreeSet<String> extraneous = new TreeSet<String>(arguments.keySet());
            extraneous.removeAll(parameters.keySet());
            throw new DebuggerIllegalArgumentException("Extraneous parameters: " + extraneous);
        }
        LinkedHashMap valid = new LinkedHashMap();
        TreeMap<String, CallSite> typeErrors = null;
        TreeSet<String> extraneous = null;
        for (Map.Entry<String, ?> ent : arguments.entrySet()) {
            String name = ent.getKey();
            Object val = ent.getValue();
            ParameterDescription<?> d = parameters.get(name);
            if (d == null && !permitExtras) {
                if (extraneous == null) {
                    extraneous = new TreeSet<String>();
                }
                extraneous.add(name);
                continue;
            }
            if (val != null && !d.type.isAssignableFrom(val.getClass())) {
                if (typeErrors == null) {
                    typeErrors = new TreeMap<String, CallSite>();
                }
                typeErrors.put(name, (CallSite)((Object)("val '" + val + "' is not a " + d.type)));
                continue;
            }
            valid.put(name, val);
        }
        if (typeErrors != null || extraneous != null) {
            StringBuilder sb = new StringBuilder();
            if (typeErrors != null) {
                sb.append("Type mismatches: ");
                sb.append(typeErrors);
            }
            if (extraneous != null) {
                sb.append("Extraneous parameters: ");
                sb.append(extraneous);
            }
            throw new DebuggerIllegalArgumentException(sb.toString());
        }
        return valid;
    }

    public static TargetParameterMap getParameters(TargetObject obj) {
        return obj.getTypedAttributeNowByName(PARAMETERS_ATTRIBUTE_NAME, TargetParameterMap.class, TargetParameterMap.of());
    }

    @TargetAttributeType(name="_parameters", required=true, fixed=true, hidden=true)
    default public TargetParameterMap getParameters() {
        return TargetMethod.getParameters(this);
    }

    @TargetAttributeType(name="_return_type", required=true, fixed=true, hidden=true)
    default public Class<?> getReturnType() {
        return this.getTypedAttributeNowByName(RETURN_TYPE_ATTRIBUTE_NAME, Class.class, Object.class);
    }

    public CompletableFuture<Object> invoke(Map<String, ?> var1);

    public static interface TargetParameterMap
    extends Map<String, ParameterDescription<?>> {
        public static final TargetParameterMap EMPTY = new EmptyTargetParameterMap();

        public static TargetParameterMap of() {
            return EMPTY;
        }

        public static TargetParameterMap copyOf(Map<String, ParameterDescription<?>> map) {
            return new ImmutableTargetParameterMap(map);
        }

        public static class ImmutableTargetParameterMap
        extends CollectionUtils.AbstractNMap<String, ParameterDescription<?>>
        implements TargetParameterMap {
            public ImmutableTargetParameterMap(Map<String, ParameterDescription<?>> map) {
                super(map);
            }
        }

        public static class EmptyTargetParameterMap
        extends CollectionUtils.AbstractEmptyMap<String, ParameterDescription<?>>
        implements TargetParameterMap {
        }
    }

    public static class ParameterDescription<T> {
        public final Class<T> type;
        public final String name;
        public final T defaultValue;
        public final boolean required;
        public final String display;
        public final String description;
        public final Set<T> choices;

        public static <T> ParameterDescription<T> create(Class<T> type, String name, boolean required, T defaultValue, String display, String description) {
            return new ParameterDescription<T>(type, name, required, defaultValue, display, description, List.of());
        }

        public static <T> ParameterDescription<T> choices(Class<T> type, String name, Collection<T> choices, String display, String description) {
            T defaultValue = choices.iterator().next();
            return new ParameterDescription<T>(type, name, false, defaultValue, display, description, choices);
        }

        private ParameterDescription(Class<T> type, String name, boolean required, T defaultValue, String display, String description, Collection<T> choices) {
            this.type = type;
            this.name = name;
            this.defaultValue = defaultValue;
            this.required = required;
            this.display = display;
            this.description = description;
            this.choices = Set.copyOf(choices);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name, this.defaultValue, this.required, this.display, this.description, this.choices);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription that = (ParameterDescription)obj;
            if (this.type != that.type) {
                return false;
            }
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.defaultValue, that.defaultValue)) {
                return false;
            }
            if (this.required != that.required) {
                return false;
            }
            if (!Objects.equals(this.display, that.display)) {
                return false;
            }
            if (!Objects.equals(this.description, that.description)) {
                return false;
            }
            return Objects.equals(this.choices, that.choices);
        }

        public T get(Map<String, ?> arguments) {
            if (arguments.containsKey(this.name)) {
                return (T)arguments.get(this.name);
            }
            if (this.required) {
                throw new DebuggerIllegalArgumentException("Missing required parameter '" + this.name + "'");
            }
            return this.defaultValue;
        }

        public String toString() {
            return String.format("<ParameterDescription name=%s type=%s default=%s required=%s display='%s' description='%s' choices=%s", this.name, this.type, this.defaultValue, this.required, this.display, this.description, this.choices);
        }
    }
}

