/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import db.BinaryField;
import db.DBRecord;
import ghidra.trace.database.stack.DBTraceStackFrame;
import ghidra.trace.database.stack.DBTraceStackManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceStack
extends DBAnnotatedObject
implements TraceStack {
    public static final String TABLE_NAME = "Stacks";
    static final String THREAD_SNAP_COLUMN_NAME = "ThreadSnap";
    static final String FRAMES_COLUMN_NAME = "Frames";
    @DBAnnotatedColumn(value="ThreadSnap")
    static DBObjectColumn THREAD_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Frames")
    static DBObjectColumn FRAMES_COLUMN;
    @DBAnnotatedField(column="ThreadSnap", indexed=true, codec=ThreadSnapDBFieldCodec.class)
    private ThreadSnap threadSnap;
    @DBAnnotatedField(column="Frames")
    private long[] frameKeys;
    private final DBTraceStackManager manager;
    private DBTraceThread thread;
    private final List<DBTraceStackFrame> frames = new ArrayList<DBTraceStackFrame>();

    public DBTraceStack(DBTraceStackManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            this.threadSnap = new ThreadSnap();
        } else {
            this.thread = this.manager.threadManager.getThread(this.threadSnap.threadKey);
            this.frames.clear();
            if (this.frameKeys == null) {
                return;
            }
            for (long k : this.frameKeys) {
                this.frames.add(this.manager.getFrameByKey(k));
            }
        }
    }

    void set(DBTraceThread thread, long snap) {
        this.thread = thread;
        this.threadSnap.threadKey = thread.getKey();
        this.threadSnap.snap = snap;
        this.update(THREAD_SNAP_COLUMN);
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public long getSnap() {
        return this.threadSnap.snap;
    }

    @Override
    public int getDepth() {
        if (this.frameKeys == null) {
            return 0;
        }
        return this.frameKeys.length;
    }

    protected void doUpdateFrameKeys() {
        int depth = this.frames.size();
        this.frameKeys = new long[depth];
        for (int i = 0; i < depth; ++i) {
            this.frameKeys[i] = this.frames.get(i).getKey();
        }
        this.update(FRAMES_COLUMN);
    }

    protected void doUpdateFrameDepths(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.frames.get(i).setLevel(i);
        }
    }

    @Override
    public void setDepth(int depth, boolean atInner) {
        int curDepth;
        int n = curDepth = this.frameKeys == null ? 0 : this.frameKeys.length;
        if (depth == curDepth) {
            return;
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (depth < curDepth) {
                List<DBTraceStackFrame> toRemove = atInner ? this.frames.subList(0, curDepth - depth) : this.frames.subList(depth, curDepth);
                for (DBTraceStackFrame frame : toRemove) {
                    this.manager.deleteFrame(frame);
                }
                toRemove.clear();
                if (atInner) {
                    this.doUpdateFrameDepths(0, this.frames.size());
                }
            } else {
                List<DBTraceStackFrame> toAdd = Arrays.asList(new DBTraceStackFrame[depth - curDepth]);
                for (int i = 0; i < toAdd.size(); ++i) {
                    toAdd.set(i, this.manager.createFrame(this));
                }
                if (atInner) {
                    this.frames.addAll(0, toAdd);
                    this.doUpdateFrameDepths(0, this.frames.size());
                } else {
                    this.frames.addAll(toAdd);
                    this.doUpdateFrameDepths(this.frames.size() - toAdd.size(), this.frames.size());
                }
            }
            this.doUpdateFrameKeys();
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceStackChangeType.CHANGED, null, this));
    }

    @Override
    public DBTraceStackFrame getFrame(int level, boolean ensureDepth) {
        if (ensureDepth) {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
                if (level >= this.frames.size()) {
                    this.setDepth(level + 1, false);
                }
                DBTraceStackFrame dBTraceStackFrame = this.frames.get(level);
                return dBTraceStackFrame;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (level >= this.frames.size()) {
                DBTraceStackFrame dBTraceStackFrame = null;
                return dBTraceStackFrame;
            }
            DBTraceStackFrame dBTraceStackFrame = this.frames.get(level);
            return dBTraceStackFrame;
        }
    }

    @Override
    public List<TraceStackFrame> getFrames() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            List<TraceStackFrame> list = List.copyOf(this.frames);
            return list;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            for (DBTraceStackFrame frame : this.frames) {
                this.manager.deleteFrame(frame);
            }
            this.manager.deleteStack(this);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceStackChangeType.DELETED, null, this));
    }

    public static class ThreadSnapDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<ThreadSnap, DBAnnotatedObject, BinaryField> {
        public ThreadSnapDBFieldCodec(Class<DBAnnotatedObject> objectType, Field field, int column) {
            super(ThreadSnap.class, objectType, BinaryField.class, field, column);
        }

        protected byte[] encode(ThreadSnap value) {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putLong(value.threadKey);
            buf.putLong(value.snap);
            return buf.array();
        }

        protected ThreadSnap decode(byte[] data) {
            ByteBuffer buf = ByteBuffer.wrap(data);
            ThreadSnap value = new ThreadSnap();
            value.threadKey = buf.getLong();
            value.snap = buf.getLong();
            return value;
        }

        public void store(ThreadSnap value, BinaryField f) {
            f.setBinaryData(this.encode(value));
        }

        protected void doStore(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, this.encode((ThreadSnap)this.getValue(obj)));
        }

        protected void doLoad(DBAnnotatedObject obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, this.decode(record.getBinaryData(this.column)));
        }
    }

    public static class ThreadSnap {
        long threadKey;
        long snap;

        public ThreadSnap() {
        }

        public ThreadSnap(long threadKey, long snap) {
            this.threadKey = threadKey;
            this.snap = snap;
        }
    }
}

