/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.ErrorLogger;
import java.io.PrintStream;

public class DefaultErrorLogger
implements ErrorLogger {
    private void output(PrintStream stream, Object message) {
        stream.println(message);
    }

    private void out(Object message) {
        this.output(System.out, message);
    }

    private void err(Object message) {
        this.output(System.err, message);
    }

    @Override
    public void debug(Object originator, Object message) {
        this.out(message);
    }

    @Override
    public void debug(Object originator, Object message, Throwable throwable) {
        if (throwable != null) {
            this.err(message);
            String throwableMessage = throwable.getMessage();
            if (throwableMessage != null) {
                this.err(throwableMessage);
            }
            throwable.printStackTrace(System.err);
        } else {
            this.out(message);
        }
    }

    @Override
    public void error(Object originator, Object message) {
        this.err(message);
    }

    @Override
    public void error(Object originator, Object message, Throwable throwable) {
        this.err(message);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    @Override
    public void info(Object originator, Object message) {
        this.out(message);
    }

    @Override
    public void info(Object originator, Object message, Throwable throwable) {
        if (throwable != null) {
            this.err(message);
            String throwableMessage = throwable.getMessage();
            if (throwableMessage != null) {
                this.err(throwableMessage);
            }
            throwable.printStackTrace(System.err);
        } else {
            this.out(message);
        }
    }

    @Override
    public void trace(Object originator, Object message) {
    }

    @Override
    public void trace(Object originator, Object message, Throwable throwable) {
    }

    @Override
    public void warn(Object originator, Object message) {
        this.err(message);
    }

    @Override
    public void warn(Object originator, Object message, Throwable throwable) {
        this.err(message);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }
}

