/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.AssociationHook;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTTaskMonitor;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.feature.vt.gui.util.ImpliedMatchUtils;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Set;

public class ImpliedMatchAssociationHook
implements AssociationHook,
VTControllerListener {
    private VTSession session;
    private final VTController controller;
    private boolean autoCreateImpliedMatches = true;

    public ImpliedMatchAssociationHook(VTController controller) {
        this.controller = controller;
        ToolOptions options = controller.getOptions();
        this.autoCreateImpliedMatches = options.getBoolean("Accept Match Options.Auto Create Implied Matches", false);
        this.setSession(controller.getSession());
        controller.addListener(this);
    }

    @Override
    public void sessionChanged(VTSession newSession) {
        this.setSession(newSession);
    }

    private void setSession(VTSession session) {
        if (this.session != null) {
            this.session.removeAssociationHook(this);
        }
        this.session = session;
        if (this.session != null) {
            this.session.addAssociationHook(this);
        }
    }

    @Override
    public void associationAccepted(VTAssociation association) {
        Function source = ImpliedMatchUtils.getSourceFunction(this.session, association);
        Function destination = ImpliedMatchUtils.getDestinationFunction(this.session, association);
        if (source == null || destination == null) {
            return;
        }
        AddressCorrelatorManager correlator = this.controller.getCorrelator();
        if (!this.autoCreateImpliedMatches) {
            return;
        }
        try {
            TaskMonitor monitor = VTTaskMonitor.getTaskMonitor();
            Set<VTImpliedMatchInfo> impliedMatches = ImpliedMatchUtils.findImpliedMatches(this.controller, source, destination, this.session, correlator, monitor);
            this.processAssociationAccepted(impliedMatches);
        }
        catch (CancelledException e) {
            Msg.info((Object)this, (Object)"User cancelled finding implied matches when accepting an assocation");
        }
    }

    private void processAssociationAccepted(Set<VTImpliedMatchInfo> impliedMatches) {
        for (VTImpliedMatchInfo impliedMatch : impliedMatches) {
            Address sourceAddress = impliedMatch.getSourceAddress();
            Address destinationAddress = impliedMatch.getDestinationAddress();
            VTAssociation existingAssociation = this.session.getAssociationManager().getAssociation(sourceAddress, destinationAddress);
            if (existingAssociation == null) {
                VTMatchSet impliedMatchSet = this.session.getImpliedMatchSet();
                VTMatch match = impliedMatchSet.addMatch(impliedMatch);
                existingAssociation = match.getAssociation();
            }
            if (existingAssociation == null) continue;
            existingAssociation.setVoteCount(existingAssociation.getVoteCount() + 1);
        }
    }

    @Override
    public void associationCleared(VTAssociation association) {
        Function source = ImpliedMatchUtils.getSourceFunction(this.session, association);
        Function destination = ImpliedMatchUtils.getDestinationFunction(this.session, association);
        if (source == null || destination == null) {
            return;
        }
        if (!this.autoCreateImpliedMatches) {
            return;
        }
        AddressCorrelatorManager correlator = this.controller.getCorrelator();
        try {
            TaskMonitor monitor = VTTaskMonitor.getTaskMonitor();
            Set<VTImpliedMatchInfo> impliedMatches = ImpliedMatchUtils.findImpliedMatches(this.controller, source, destination, this.session, correlator, monitor);
            this.processAssociationCleared(impliedMatches);
        }
        catch (CancelledException e) {
            Msg.info((Object)this, (Object)"User cancelled finding implied matches when clearing an assocation");
        }
    }

    private void processAssociationCleared(Set<VTImpliedMatchInfo> impliedMatches) {
        for (VTImpliedMatchInfo impliedMatch : impliedMatches) {
            Address sourceAddress = impliedMatch.getSourceAddress();
            Address destinationAddress = impliedMatch.getDestinationAddress();
            VTAssociation existingAssociation = this.session.getAssociationManager().getAssociation(sourceAddress, destinationAddress);
            if (existingAssociation == null) continue;
            int newVoteCount = Math.max(0, existingAssociation.getVoteCount() - 1);
            existingAssociation.setVoteCount(newVoteCount);
            if (!this.autoCreateImpliedMatches || newVoteCount != 0) continue;
            this.removeImpliedMatch(existingAssociation);
        }
    }

    private void removeImpliedMatch(VTAssociation existingAssociation) {
        List<VTMatch> matches = this.session.getMatches(existingAssociation);
        VTMatchSet impliedMatchSet = this.session.getImpliedMatchSet();
        for (VTMatch vtMatch : matches) {
            if (vtMatch.getMatchSet() != impliedMatchSet) continue;
            impliedMatchSet.removeMatch(vtMatch);
        }
    }

    @Override
    public void optionsChanged(Options options) {
        this.autoCreateImpliedMatches = options.getBoolean("Accept Match Options.Auto Create Implied Matches", false);
    }

    @Override
    public void markupItemStatusChanged(VTMarkupItem markupItem) {
    }

    @Override
    public void disposed() {
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
    }
}

