/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.task.ApplyMatchTask;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ApplyMatchAction
extends DockingAction {
    public static final String NAME = "Apply Markup";
    private static final String MENU_GROUP = "A_VT_Edit_1";
    private final VTController controller;

    public ApplyMatchAction(VTController controller) {
        super(NAME, VTPlugin.OWNER);
        this.controller = controller;
        ImageIcon icon = ResourceManager.loadImage((String)"images/checkmark_green.gif");
        this.setToolBarData(new ToolBarData((Icon)icon, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{NAME}, (Icon)icon, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Apply_Markup"));
    }

    public void actionPerformed(ActionContext context) {
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        ApplyMatchTask task = new ApplyMatchTask(this.controller, matches);
        this.controller.runVTTask(task);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        List<VTMatch> matches = matchContext.getSelectedMatches();
        return matches.size() != 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

