/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class DynamicEntry
extends SymbolEntry {
    private long hash;

    public DynamicEntry(HighSymbol sym) {
        super(sym);
    }

    public DynamicEntry(HighSymbol sym, Address addr, long h) {
        super(sym);
        this.pcaddr = addr;
        this.hash = h;
    }

    public long getHash() {
        return this.hash;
    }

    @Override
    public void restoreXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement addrel = parser.start(new String[]{"hash"});
        this.hash = SpecXmlUtils.decodeLong((String)addrel.getAttribute("val"));
        parser.end(addrel);
        this.parseRangeList(parser);
    }

    @Override
    public void saveXml(StringBuilder buf) {
        buf.append("<hash val=\"0x").append(Long.toHexString(this.hash)).append("\"/>");
        this.buildRangelistXML(buf);
    }

    @Override
    public VariableStorage getStorage() {
        Program program = this.symbol.getProgram();
        try {
            return new VariableStorage(program, AddressSpace.HASH_SPACE.getAddress(this.getHash()), this.getSize());
        }
        catch (InvalidInputException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    public static DynamicEntry build(Varnode vn) {
        HighVariable highVariable = vn.getHigh();
        HighSymbol highSymbol = highVariable.getSymbol();
        HighFunction highFunction = highSymbol.getHighFunction();
        DynamicHash dynamicHash = new DynamicHash(vn, highFunction);
        DynamicEntry entry = new DynamicEntry(highSymbol, dynamicHash.getAddress(), dynamicHash.getHash());
        return entry;
    }

    @Override
    public int getSize() {
        return this.symbol.type.getLength();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }
}

