/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.CodeUnitDB;
import ghidra.program.database.code.InstDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.util.Msg;
import ghidra.util.exception.NoValueException;
import java.util.ArrayList;
import java.util.List;

public class InstructionDB
extends CodeUnitDB
implements Instruction,
InstructionContext {
    private static byte FALLTHROUGH_SET_MASK = 1;
    private static byte FALLTHROUGH_CLEAR_MASK = (byte)-2;
    private static byte FLOWOVERRIDE_MASK = (byte)14;
    private static byte FLOWOVERRIDE_CLEAR_MASK = (byte)-15;
    private static int FLOWOVERRIDE_SHIFT = 1;
    private InstructionPrototype proto;
    private byte flags;
    private FlowOverride flowOverride;
    private static final Address[] EMPTY_ADDR_ARRAY = new Address[0];
    private volatile boolean clearingFallThroughs = false;
    private ParserContext parserContext;

    public InstructionDB(CodeManager codeMgr, DBObjectCache<? extends CodeUnitDB> cache, Address address, long addr, InstructionPrototype proto, byte flags) {
        super(codeMgr, cache, addr, address, addr, proto.getLength());
        this.proto = proto;
        this.flags = flags;
        this.flowOverride = FlowOverride.getFlowOverride((flags & FLOWOVERRIDE_MASK) >> FLOWOVERRIDE_SHIFT);
    }

    @Override
    protected boolean refresh(DBRecord record) {
        this.parserContext = null;
        return super.refresh(record);
    }

    @Override
    protected int getPreferredCacheLength() {
        return this.proto.hasDelaySlots() ? this.length * 2 : this.length;
    }

    @Override
    protected boolean hasBeenDeleted(DBRecord rec) {
        if (rec == null ? (rec = this.codeMgr.getInstructionRecord(this.addr)) == null : !rec.hasSameSchema(InstDBAdapter.INSTRUCTION_SCHEMA)) {
            return true;
        }
        int newProtoID = rec.getIntValue(0);
        InstructionPrototype newProto = this.codeMgr.getInstructionPrototype(newProtoID);
        if (newProto == null) {
            Msg.error((Object)this, (Object)("Instruction found but prototype missing at " + this.address));
            return true;
        }
        if (!newProto.equals(this.proto)) {
            return true;
        }
        this.length = this.proto.getLength();
        this.flags = rec.getByteValue(1);
        this.flowOverride = FlowOverride.getFlowOverride((this.flags & FLOWOVERRIDE_MASK) >> FLOWOVERRIDE_SHIFT);
        return false;
    }

    @Override
    public int getDelaySlotDepth() {
        if (!this.proto.hasDelaySlots()) {
            return 0;
        }
        this.lock.acquire();
        try {
            int n = this.proto.getDelaySlotDepth(this);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    public RegisterValue getOriginalPrototypeContext(Register baseContextReg) {
        try {
            return this.codeMgr.getOriginalPrototypeContext(this.proto, baseContextReg);
        }
        catch (NoValueException e) {
            Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getFallFrom() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Instruction instr = this;
            int alignment = this.program.getLanguage().getInstructionAlignment();
            if (alignment < 1) {
                alignment = 1;
            }
            do {
                try {
                    instr = this.program.getListing().getInstructionContaining(instr.getMinAddress().subtractNoWrap(alignment));
                }
                catch (AddressOverflowException e) {
                    Address address = null;
                    this.lock.release();
                    return address;
                }
            } while (instr != null && instr.isInDelaySlot());
            if (instr == null) {
                Address e = null;
                return e;
            }
            if (this.isInDelaySlot()) {
                Address e = instr.getMinAddress();
                return e;
            }
            Address fallAddr = instr.getFallThrough();
            if (fallAddr != null && fallAddr.equals(this.address)) {
                Address address = instr.getMinAddress();
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getFallThrough() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                for (Reference ref : this.refMgr.getReferencesFrom(this.address)) {
                    if (!ref.getReferenceType().isFallthrough() || !ref.getToAddress().isMemoryAddress()) continue;
                    Address address = ref.getToAddress();
                    return address;
                }
                Reference[] referenceArray = null;
                return referenceArray;
            }
            Address address = this.getDefaultFallThrough();
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address[] getFlows() {
        this.refreshIfNeeded();
        Reference[] refs = this.refMgr.getFlowReferencesFrom(this.address);
        if (refs.length == 0) {
            return EMPTY_ADDR_ARRAY;
        }
        ArrayList<Address> list = new ArrayList<Address>();
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i].getReferenceType().isIndirect()) continue;
            list.add(refs[i].getToAddress());
        }
        if (this.flowOverride == FlowOverride.RETURN && list.size() == 1) {
            return EMPTY_ADDR_ARRAY;
        }
        Address[] addrs = new Address[list.size()];
        return list.toArray(addrs);
    }

    @Override
    public Address[] getDefaultFlows() {
        Address[] flows = this.proto.getFlows(this);
        if (this.flowOverride == FlowOverride.RETURN && flows.length == 1) {
            return EMPTY_ADDR_ARRAY;
        }
        return flows;
    }

    @Override
    public FlowType getFlowType() {
        return FlowOverride.getModifiedFlowType(this.proto.getFlowType(this), this.flowOverride);
    }

    @Override
    public Instruction getNext() {
        this.refreshIfNeeded();
        return this.codeMgr.getInstructionAfter(this.address);
    }

    @Override
    public RefType getOperandRefType(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            RefType refType = this.proto.getOperandRefType(opIndex, this, new InstructionPcodeOverride(this), new UniqueAddressFactory(this.program.getAddressFactory(), this.program.getLanguage()));
            return refType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getSeparator(int opIndex) {
        this.lock.acquire();
        try {
            String string = this.proto.getSeparator(opIndex, this);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultOperandRepresentation(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            List<Object> opList = this.getDefaultOperandRepresentationList(opIndex);
            if (opList == null) {
                String string = "<UNSUPPORTED>";
                return string;
            }
            StringBuffer strBuf = new StringBuffer();
            for (Object opElem : opList) {
                if (opElem instanceof Address) {
                    Address opAddr = (Address)opElem;
                    strBuf.append("0x");
                    strBuf.append(opAddr.toString(false));
                    continue;
                }
                strBuf.append(opElem.toString());
            }
            String string = strBuf.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public List<Object> getDefaultOperandRepresentationList(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ArrayList<Object> arrayList = this.proto.getOpRepresentationList(opIndex, this);
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOperandType(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int optype = this.proto.getOpType(opIndex, this);
            Reference ref = this.getPrimaryReference(opIndex);
            if (ref instanceof StackReference) {
                int n = optype |= 0x2000;
                return n;
            }
            if (ref instanceof ExternalReference) {
                optype |= 0x2000;
            } else if (ref != null && ref.getToAddress().isMemoryAddress()) {
                optype |= 0x2000;
            }
            int n = optype;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getOpObjects(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0 || opIndex >= this.getNumOperands()) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            Object[] objectArray = this.proto.getOpObjects(opIndex, this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Instruction getPrevious() {
        this.refreshIfNeeded();
        return this.codeMgr.getInstructionBefore(this.address);
    }

    @Override
    public InstructionPrototype getPrototype() {
        return this.proto;
    }

    @Override
    public Register getRegister(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0) {
                Register register = null;
                return register;
            }
            Register register = this.proto.getRegister(opIndex, this);
            return register;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getInputObjects() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object[] objectArray = this.proto.getInputObjects(this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Object[] getResultObjects() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object[] objectArray = this.proto.getResultObjects(this);
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isInDelaySlot() {
        return this.proto.isInDelaySlot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getAddress(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Reference ref = this.refMgr.getPrimaryReferenceFrom(this.address, opIndex);
            if (ref != null) {
                Address address = ref.getToAddress();
                return address;
            }
            if (opIndex < 0) {
                Address address = null;
                return address;
            }
            int opType = this.proto.getOpType(opIndex, this);
            if (OperandType.isAddress(opType)) {
                Address address = this.proto.getAddress(opIndex, this);
                return address;
            }
            Address address = null;
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMnemonicString());
            int n = this.getNumOperands();
            String sep = this.getSeparator(0);
            if (sep != null || n != 0) {
                stringBuffer.append(' ');
            }
            if (sep != null) {
                stringBuffer.append(sep);
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.getDefaultOperandRepresentation(i));
                sep = this.getSeparator(i + 1);
                if (sep == null) continue;
                stringBuffer.append(sep);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getMnemonicString() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.proto.getMnemonic(this);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumOperands() {
        return this.proto.getNumOperands();
    }

    @Override
    public Scalar getScalar(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (opIndex < 0) {
                Scalar scalar = null;
                return scalar;
            }
            Scalar scalar = this.proto.getScalar(opIndex, this);
            return scalar;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        InstructionDB inst = (InstructionDB)obj;
        return this.proto.equals(inst.proto);
    }

    @Override
    public FlowOverride getFlowOverride() {
        return this.flowOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlowOverride(FlowOverride flow) {
        if (flow == null) {
            flow = FlowOverride.NONE;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (flow == this.flowOverride) {
                return;
            }
            FlowType origFlowType = this.getFlowType();
            this.flags = (byte)(this.flags & FLOWOVERRIDE_CLEAR_MASK);
            this.flags = (byte)(this.flags | flow.ordinal() << FLOWOVERRIDE_SHIFT);
            this.codeMgr.setFlags(this.addr, this.flags);
            this.flowOverride = flow;
            for (Reference ref : this.refMgr.getFlowReferencesFrom(this.getAddress())) {
                RefType refType;
                if (!ref.getReferenceType().isFlow() || !this.isSameFlowType(origFlowType, ref.getReferenceType()) || !(refType = RefTypeFactory.getDefaultMemoryRefType(this, ref.getOperandIndex(), ref.getToAddress(), true)).isFlow() || ref.getReferenceType() == refType) continue;
                this.refMgr.delete(ref);
                Reference newRef = this.refMgr.addMemoryReference(ref.getFromAddress(), ref.getToAddress(), refType, ref.getSource(), ref.getOperandIndex());
                if (!ref.isPrimary()) continue;
                this.refMgr.setPrimary(newRef, true);
            }
        }
        finally {
            this.lock.release();
        }
        this.program.setChanged(163, this.address, this.address, null, null);
    }

    private boolean isSameFlowType(FlowType origFlowType, RefType referenceType) {
        if (origFlowType.isCall() && referenceType.isCall()) {
            return true;
        }
        if (origFlowType.isJump() && referenceType.isJump()) {
            return true;
        }
        return origFlowType.isTerminal() && referenceType.isTerminal();
    }

    @Override
    public PcodeOp[] getPcode() {
        return this.getPcode(false);
    }

    @Override
    public PcodeOp[] getPcode(boolean includeOverrides) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (!includeOverrides) {
                PcodeOp[] pcodeOpArray = this.proto.getPcode(this, null, null);
                return pcodeOpArray;
            }
            PcodeOp[] pcodeOpArray = this.proto.getPcode(this, new InstructionPcodeOverride(this), new UniqueAddressFactory(this.program.getAddressFactory(), this.program.getLanguage()));
            return pcodeOpArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public PcodeOp[] getPcode(int opIndex) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            PcodeOp[] pcodeOpArray = this.proto.getPcode(this, opIndex);
            return pcodeOpArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFallThroughOverridden() {
        return (this.flags & FALLTHROUGH_SET_MASK) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFallThroughRefs(Reference keepFallThroughRef) {
        if (this.clearingFallThroughs) {
            return;
        }
        this.refreshIfNeeded();
        this.clearingFallThroughs = true;
        try {
            for (Reference ref : this.refMgr.getReferencesFrom(this.address)) {
                if (ref.getReferenceType() != RefType.FALL_THROUGH || ref.equals(keepFallThroughRef)) continue;
                this.refMgr.delete(ref);
            }
        }
        finally {
            this.clearingFallThroughs = false;
        }
    }

    void fallThroughChanged(Reference fallThroughRef) {
        if (!this.clearingFallThroughs) {
            this.clearFallThroughRefs(fallThroughRef);
            this.setFallthroughOverride(fallThroughRef != null && fallThroughRef.getReferenceType() == RefType.FALL_THROUGH);
        }
    }

    private void setFallthroughOverride(boolean state) {
        if (state != this.isFallThroughOverridden()) {
            this.flags = state ? (byte)(this.flags | FALLTHROUGH_SET_MASK) : (byte)(this.flags & FALLTHROUGH_CLEAR_MASK);
            this.codeMgr.setFlags(this.addr, this.flags);
        }
        this.program.setChanged(162, this.address, this.address, null, null);
    }

    @Override
    public void clearFallThroughOverride() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (!this.isFallThroughOverridden()) {
                return;
            }
            this.clearFallThroughRefs(null);
            this.setFallthroughOverride(false);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setFallThrough(Address fallThroughAddr) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Address defaultFallThrough = this.proto.getFallThrough(this);
            if (this.addrsEqual(fallThroughAddr, defaultFallThrough)) {
                this.clearFallThroughOverride();
                return;
            }
            if (fallThroughAddr == null) {
                this.clearFallThroughRefs(null);
                this.setFallthroughOverride(true);
            } else {
                this.refMgr.addMemoryReference(this.address, fallThroughAddr, RefType.FALL_THROUGH, SourceType.USER_DEFINED, -1);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private boolean addrsEqual(Address addr1, Address addr2) {
        if (addr1 == null) {
            return addr2 == null;
        }
        return addr1.equals(addr2);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Address getDefaultFallThrough() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getDefaultFallThroughOffset() {
        this.lock.acquire();
        try {
            int n = this.proto.getFallThroughOffset(this);
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasFallthrough() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.isFallThroughOverridden()) {
                boolean bl = this.getFallThrough() != null;
                return bl;
            }
            boolean bl = this.getFlowType().hasFallthrough();
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isFallthrough() {
        if (!this.getFlowType().isFallthrough()) {
            return false;
        }
        return this.hasFallthrough();
    }

    @Override
    public ProcessorContextView getProcessorContext() {
        return this;
    }

    @Override
    public MemBuffer getMemBuffer() {
        return this;
    }

    @Override
    public ParserContext getParserContext() throws MemoryAccessException {
        if (this.parserContext == null) {
            this.parserContext = this.proto.getParserContext(this, this);
        }
        return this.parserContext;
    }

    @Override
    public InstructionContext getInstructionContext() {
        return this;
    }

    @Override
    public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
        if (this.address.equals(instructionAddress)) {
            return this.getParserContext();
        }
        InstructionDB instr = (InstructionDB)this.codeMgr.getInstructionAt(instructionAddress);
        if (instr == null) {
            throw new UnknownContextException("Program does not contain referenced instruction: " + instructionAddress);
        }
        InstructionPrototype otherProto = instr.getPrototype();
        if (!otherProto.getClass().equals(this.proto.getClass())) {
            throw new UnknownContextException("Instruction has incompatible prototype at: " + instructionAddress);
        }
        return instr.getParserContext();
    }
}

