/*
 * Decompiled with CFR 0.152.
 */
package ghidra.comm.service;

import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.comm.service.AbstractAsyncClientHandler;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.Function;

public abstract class AbstractAsyncServer<S extends AbstractAsyncServer<S, H>, H extends AbstractAsyncClientHandler<S, H>> {
    private final AsynchronousChannelGroup group = AsynchronousChannelGroup.withThreadPool(Executors.newSingleThreadExecutor());
    private final AsynchronousServerSocketChannel ssock;
    protected final Set<H> handlers = Collections.newSetFromMap(new ConcurrentHashMap());

    public AbstractAsyncServer(SocketAddress addr) throws IOException {
        this.ssock = AsynchronousServerSocketChannel.open(this.group);
        this.ssock.bind(addr);
    }

    private CompletableFuture<AsynchronousSocketChannel> accept() {
        return AsyncUtils.completable(TypeSpec.cls(AsynchronousSocketChannel.class), this.ssock::accept);
    }

    protected abstract boolean checkAcceptable(AsynchronousSocketChannel var1);

    protected abstract H newHandler(AsynchronousSocketChannel var1);

    protected void removeHandler(H handler) {
        this.handlers.remove(handler);
    }

    public CompletableFuture<Void> launchAsyncService() {
        return AsyncUtils.loop(TypeSpec.VOID, loop -> {
            if (this.ssock.isOpen()) {
                this.accept().handle(loop::consume);
            } else {
                loop.exit();
            }
        }, TypeSpec.cls(AsynchronousSocketChannel.class), (sock, loop) -> {
            loop.repeat();
            if (!this.checkAcceptable((AsynchronousSocketChannel)sock)) {
                try {
                    sock.close();
                }
                catch (IOException e2) {
                    Msg.error((Object)this, (Object)"Failed to close rejected connection", (Throwable)e2);
                }
            } else {
                H handler = this.newHandler((AsynchronousSocketChannel)sock);
                this.handlers.add(handler);
                ((CompletableFuture)((AbstractAsyncClientHandler)handler).launchAsync().thenAccept(v -> this.removeHandler(handler))).exceptionally(e -> {
                    Msg.error((Object)"Client handler terminated unexpectedly", (Object)e);
                    this.removeHandler(handler);
                    return null;
                });
            }
        });
    }

    public SocketAddress getLocalAddress() {
        try {
            return this.ssock.getLocalAddress();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void terminate() throws IOException {
        IOException err = null;
        try {
            this.ssock.close();
        }
        catch (IOException e) {
            err = e;
        }
        for (AbstractAsyncClientHandler h : this.handlers) {
            try {
                h.close();
            }
            catch (IOException e) {
                if (err != null) continue;
                err = e;
            }
        }
        this.group.shutdown();
        if (err != null) {
            throw err;
        }
    }

    protected CompletableFuture<Void> allHandlers(Function<H, CompletableFuture<?>> action) {
        AsyncFence fence = new AsyncFence();
        for (AbstractAsyncClientHandler h : this.handlers) {
            CompletableFuture<?> future = action.apply(h);
            if (future == null) continue;
            fence.include(future);
        }
        return fence.ready();
    }
}

