/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Version
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private int version;
    private long createTime;
    private String user;
    private String comment;

    public Version(int version, long createTime, String user, String comment) {
        this.version = version;
        this.createTime = createTime;
        this.user = user;
        this.comment = comment;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.version);
        out.writeLong(this.createTime);
        out.writeUTF(this.user);
        out.writeUTF(this.comment != null ? this.comment : "");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long ver = in.readInt();
        if (ver > 1L) {
            throw new ClassNotFoundException("Unsupported version of Version");
        }
        this.version = in.readInt();
        this.createTime = in.readLong();
        this.user = in.readUTF();
        this.comment = in.readUTF();
    }

    public int getVersion() {
        return this.version;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUser() {
        return this.user;
    }
}

