/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.jar.ResourceFile;
import generic.stl.Pair;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderService;
import ghidra.framework.client.HeadlessClientAuthenticator;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HeadlessOptions {
    String domainFileNameToProcess;
    boolean runScriptsNoImport;
    List<Pair<String, String[]>> preScripts;
    Map<String, ResourceFile> preScriptFileMap;
    List<Pair<String, String[]>> postScripts;
    Map<String, ResourceFile> postScriptFileMap;
    List<String> scriptPaths;
    List<String> propertiesFileStrPaths;
    List<ResourceFile> propertiesFilePaths;
    boolean overwrite;
    boolean recursive;
    boolean readOnly;
    boolean deleteProject;
    boolean analyze;
    Language language;
    CompilerSpec compilerSpec;
    int perFileTimeout;
    String keystore;
    String connectUserID;
    boolean allowPasswordPrompt;
    boolean commit;
    String commitComment;
    boolean okToDelete;
    int maxcpu;
    Class<? extends Loader> loaderClass;
    List<Pair<String, String>> loaderArgs;

    HeadlessOptions() {
        this.reset();
    }

    public void reset() {
        this.domainFileNameToProcess = null;
        this.runScriptsNoImport = false;
        this.preScripts = new LinkedList<Pair<String, String[]>>();
        this.preScriptFileMap = null;
        this.postScripts = new LinkedList<Pair<String, String[]>>();
        this.postScriptFileMap = null;
        this.scriptPaths = null;
        this.propertiesFileStrPaths = new ArrayList<String>();
        this.propertiesFilePaths = new ArrayList<ResourceFile>();
        this.overwrite = false;
        this.recursive = false;
        this.readOnly = false;
        this.deleteProject = false;
        this.analyze = true;
        this.language = null;
        this.compilerSpec = null;
        this.perFileTimeout = -1;
        this.keystore = null;
        this.connectUserID = null;
        this.allowPasswordPrompt = false;
        this.commit = false;
        this.commitComment = null;
        this.okToDelete = false;
        this.maxcpu = 0;
        this.loaderClass = null;
        this.loaderArgs = null;
    }

    public void setRunScriptsNoImport(boolean runScriptsOnly, String filename) {
        if (filename != null && (filename = filename.trim()).indexOf("/") >= 0) {
            throw new IllegalArgumentException("invalid filename specified");
        }
        this.runScriptsNoImport = runScriptsOnly;
        this.domainFileNameToProcess = filename;
    }

    public void setPreScripts(List<String> preScripts) {
        LinkedList<Pair<String, String[]>> preScriptsEmptyArgs = new LinkedList<Pair<String, String[]>>();
        for (String preScript : preScripts) {
            preScriptsEmptyArgs.add((Pair<String, String[]>)new Pair((Object)preScript, (Object)new String[0]));
        }
        this.setPreScriptsWithArgs(preScriptsEmptyArgs);
    }

    public void setPreScriptsWithArgs(List<Pair<String, String[]>> preScripts) {
        this.preScripts = preScripts;
        this.preScriptFileMap = null;
    }

    public void setPostScripts(List<String> postScripts) {
        LinkedList<Pair<String, String[]>> postScriptsEmptyArgs = new LinkedList<Pair<String, String[]>>();
        for (String postScript : postScripts) {
            postScriptsEmptyArgs.add((Pair<String, String[]>)new Pair((Object)postScript, (Object)new String[0]));
        }
        this.setPostScriptsWithArgs(postScriptsEmptyArgs);
    }

    public void setPostScriptsWithArgs(List<Pair<String, String[]>> postScripts) {
        this.postScripts = postScripts;
        this.postScriptFileMap = null;
    }

    public void setScriptDirectories(List<String> newPaths) {
        this.scriptPaths = newPaths;
    }

    public void setScriptDirectories(String paths) {
        String[] pathArray = paths.split(";");
        this.setScriptDirectories(Arrays.asList(pathArray));
    }

    public void setPropertiesFileDirectory(String path) {
        this.propertiesFileStrPaths = new ArrayList<String>();
        this.propertiesFileStrPaths.add(path);
    }

    public void setPropertiesFileDirectories(List<String> newPaths) {
        this.propertiesFileStrPaths = newPaths;
    }

    public void setPropertiesFileDirectories(String paths) {
        String[] pathArray = paths.split(";");
        this.setPropertiesFileDirectories(Arrays.asList(pathArray));
    }

    public void enableOverwriteOnConflict(boolean enabled) {
        this.overwrite = enabled;
    }

    public void enableRecursiveProcessing(boolean enabled) {
        this.recursive = enabled;
    }

    public void enableReadOnlyProcessing(boolean enabled) {
        this.readOnly = enabled;
    }

    public void setDeleteCreatedProjectOnClose(boolean enabled) {
        this.deleteProject = enabled;
    }

    public void enableAnalysis(boolean enabled) {
        this.analyze = enabled;
    }

    public void setLanguageAndCompiler(String languageId, String compilerSpecId) throws InvalidInputException {
        if (languageId == null && compilerSpecId == null) {
            return;
        }
        if (languageId == null) {
            throw new InvalidInputException("Compiler spec specified without specifying language.");
        }
        try {
            this.language = DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(languageId));
            this.compilerSpec = compilerSpecId == null ? this.language.getDefaultCompilerSpec() : this.language.getCompilerSpecByID(new CompilerSpecID(compilerSpecId));
        }
        catch (LanguageNotFoundException e) {
            this.language = null;
            this.compilerSpec = null;
            throw new InvalidInputException("Unsupported language: " + languageId);
        }
        catch (CompilerSpecNotFoundException e) {
            this.language = null;
            this.compilerSpec = null;
            throw new InvalidInputException("Compiler spec \"" + compilerSpecId + "\" is not supported for language \"" + languageId + "\"");
        }
    }

    public void setPerFileAnalysisTimeout(String stringInSecs) throws InvalidInputException {
        try {
            this.perFileTimeout = Integer.parseInt(stringInSecs);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidInputException("'" + stringInSecs + "' is not a valid integer representation.");
        }
    }

    public void setPerFileAnalysisTimeout(int secs) {
        this.perFileTimeout = secs;
    }

    public void setClientCredentials(String userID, String keystorePath, boolean allowPasswordPrompt) throws IOException {
        this.connectUserID = userID;
        this.keystore = keystorePath;
        this.allowPasswordPrompt = allowPasswordPrompt;
        HeadlessClientAuthenticator.installHeadlessClientAuthenticator((String)userID, (String)keystorePath, (boolean)allowPasswordPrompt);
    }

    public void setCommitFiles(boolean commit, String comment) {
        this.commit = commit;
        this.commitComment = comment;
    }

    public void setOkToDelete(boolean deleteOk) {
        this.okToDelete = deleteOk;
    }

    public void setMaxCpu(int cpu) {
        this.maxcpu = cpu;
        System.setProperty("cpu.core.limit", Integer.toString(cpu));
    }

    public void setLoader(String loaderName, List<Pair<String, String>> loaderArgs) throws InvalidInputException {
        if (loaderName != null) {
            this.loaderClass = LoaderService.getLoaderClassByName(loaderName);
            if (this.loaderClass == null) {
                throw new InvalidInputException("Invalid loader name specified: " + loaderName);
            }
            this.loaderArgs = loaderArgs;
        } else {
            if (loaderArgs != null && loaderArgs.size() > 0) {
                throw new InvalidInputException("Loader arguments defined without a loader being specified.");
            }
            this.loaderClass = null;
            this.loaderArgs = null;
        }
    }
}

