/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.ThunkData;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImportAddressTableDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_IAT";
    private List<ThunkData[]> thunkDataSetList;

    static ImportAddressTableDataDirectory createImportAddressTableDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        ImportAddressTableDataDirectory importAddressTableDataDirectory = (ImportAddressTableDataDirectory)reader.getFactory().create(ImportAddressTableDataDirectory.class, new Object[0]);
        importAddressTableDataDirectory.initImportAddressTableDataDirectory(ntHeader, reader);
        return importAddressTableDataDirectory;
    }

    private void initImportAddressTableDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    public ThunkData[] getThunkDataSet(int index) {
        return this.thunkDataSetList.get(index);
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws CodeUnitInsertionException, MemoryAccessException {
        monitor.setMessage(program.getName() + ": IAT...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
    }

    @Override
    public boolean parse() throws IOException {
        ThunkData thunk;
        this.thunkDataSetList = new ArrayList<ThunkData[]>();
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        ArrayList<ThunkData> thunkList = new ArrayList<ThunkData>();
        if (this.size > 524288) {
            Msg.error((Object)this, (Object)("Large ImportAddressTable not parsed, size = " + this.size));
            return false;
        }
        for (int tmp = this.size; tmp > 0; tmp -= thunk.getStructSize()) {
            thunk = ThunkData.createThunkData(this.reader, ptr, this.ntHeader.getOptionalHeader().is64bit());
            if (thunk.getAddressOfData() == 0L) {
                ThunkData[] set = new ThunkData[thunkList.size()];
                thunkList.toArray(set);
                thunkList.clear();
                this.thunkDataSetList.add(set);
            } else {
                thunkList.add(thunk);
            }
            ptr += thunk.getStructSize();
        }
        return true;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new ArrayDataType(BYTE, this.size, 1), "IAT", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

