/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.ReferenceEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XReferenceUtils {
    private static final int ALL_REFS = -1;

    public static final List<Reference> getXReferences(CodeUnit cu, int max) {
        Address[] thunkAddrs;
        Program program = cu.getProgram();
        if (program == null) {
            Collections.emptyList();
        }
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        Address minAddress = cu.getMinAddress();
        ReferenceIterator it = program.getReferenceManager().getReferencesTo(minAddress);
        while (it.hasNext() && xrefs.size() - max != 0) {
            Reference ref = it.next();
            xrefs.add(ref);
        }
        Function func = program.getFunctionManager().getFunctionAt(minAddress);
        if (func != null && (thunkAddrs = func.getFunctionThunkAddresses()) != null) {
            for (Address thunkAddr : thunkAddrs) {
                xrefs.add((Reference)new ThunkReference(thunkAddr, func.getEntryPoint()));
            }
        }
        return xrefs;
    }

    public static List<Reference> getOffcutXReferences(CodeUnit cu, int max) {
        Program program = cu.getProgram();
        if (program == null) {
            return Collections.emptyList();
        }
        if (cu.getLength() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        ReferenceManager refMgr = program.getReferenceManager();
        AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
        AddressIterator it = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
        while (it.hasNext()) {
            Address addr = it.next();
            ReferenceIterator refIter = refMgr.getReferencesTo(addr);
            while (refIter.hasNext() && offcuts.size() - max != 0) {
                Reference ref = refIter.next();
                offcuts.add(ref);
            }
        }
        return offcuts;
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts) {
        XReferenceUtils.getVariableRefs(var, xrefs, offcuts, -1);
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts, int max) {
        Address addr = var.getMinAddress();
        if (addr == null) {
            return;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference[] refs = refMgr.getReferencesTo(var);
        int total = 0;
        for (Reference vref : refs) {
            if (total++ - max == 0) break;
            if (addr.equals((Object)vref.getToAddress())) {
                xrefs.add(vref);
                continue;
            }
            offcuts.add(vref);
        }
    }

    public static Set<Reference> getAllXrefs(ProgramLocation location) {
        Data cu = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (cu == null) {
            Address toAddress = location.getAddress();
            Listing listing = location.getProgram().getListing();
            cu = listing.getCodeUnitContaining(toAddress);
        }
        if (cu == null) {
            return Collections.emptySet();
        }
        List<Reference> xrefs = XReferenceUtils.getXReferences((CodeUnit)cu, -1);
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences((CodeUnit)cu, -1);
        HashSet<Reference> set = new HashSet<Reference>();
        set.addAll(xrefs);
        set.addAll(offcuts);
        return set;
    }

    public static void showXrefs(Navigatable navigatable, ServiceProvider serviceProvider, TableService service, ProgramLocation location, Collection<Reference> xrefs) {
        ReferencesFromTableModel model = new ReferencesFromTableModel(new ArrayList<Reference>(xrefs), serviceProvider, location.getProgram());
        TableComponentProvider<ReferenceEndpoint> provider = service.showTable("XRefs to " + location.getAddress().toString(), "XRefs", model, "XRefs", navigatable);
        provider.installRemoveItemsAction();
    }
}

