/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.analysis;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.bookmark.BookmarkEditCmd;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoDisassemblerContext;
import ghidra.app.util.PseudoFlowProcessor;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class AggressiveInstructionFinderAnalyzer
extends AbstractAnalyzer {
    private static final int MINIMUM_FUNCTION_COUNT = 20;
    private static final String NAME = "Aggressive Instruction Finder";
    private static final String DESCRIPTION = "Finds valid code in undefined bytes that have not been disassembled.\nWARNING: This should not be run unless good code has already been found.\nYOU MUST CHECK THE RESULTS, IT MAY CREATE A LOT OF BAD CODE!";
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an alaysis bookmark will be created at the start of each disassembly location where a run of instructions are identified by this analyzer.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;
    private Program curProgram;
    private Listing listing;
    private int numInstr = 0;
    private boolean addsInfo = false;
    private HashMap<BigInteger, Integer> funcStartMap;
    private HashMap<BigInteger, RegisterValue> funcStartContext;
    private long lastProgramHash;
    private long lastFuncCount = 0L;

    public AggressiveInstructionFinderAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPrototype();
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after());
        this.setDefaultEnablement(false);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.curProgram = program;
        this.listing = program.getListing();
        set = this.checkExecBlocks(program, set);
        PseudoDisassembler pseudo = new PseudoDisassembler(program);
        long alignment = program.getLanguage().getInstructionAlignment();
        long funcCount = program.getFunctionManager().getFunctionCount();
        if (funcCount < 20L || program.getListing().getNumInstructions() <= 0L) {
            log.appendMsg("AggressiveInstructionFinder", "Aggressive Instruction Finder Not Run.  Too few functions defined for proper analysis!");
            return true;
        }
        if (this.funcStartMap == null || this.lastProgramHash != (long)program.hashCode() || this.funcStartMap.isEmpty() || (double)funcCount > (double)this.lastFuncCount * 1.1) {
            this.lastProgramHash = program.hashCode();
            this.lastFuncCount = funcCount;
            monitor.setMessage("AIF - hashing functions");
            this.funcStartMap = new HashMap();
            this.funcStartContext = new HashMap();
            FunctionManager functionManager = program.getFunctionManager();
            FunctionIterator funcs = functionManager.getFunctions(true);
            int functionCount = functionManager.getFunctionCount();
            monitor.initialize((long)functionCount);
            while (funcs.hasNext()) {
                monitor.incrementProgress(1L);
                Function function = (Function)funcs.next();
                Address entry = function.getEntryPoint();
                Instruction instr = program.getListing().getInstructionAt(entry);
                RegisterValue disContext = program.getProgramContext().getDisassemblyContext(entry);
                if (instr == null) continue;
                try {
                    BigInteger bi;
                    Integer count;
                    Object ibytes1;
                    SleighDebugLogger ilog = new SleighDebugLogger(program, entry, SleighDebugLogger.SleighDebugMode.MASKS_ONLY);
                    if (ilog.parseFailed()) continue;
                    byte[] imask = ilog.getInstructionMask();
                    if (imask.length == 1) {
                        imask[0] = -1;
                    }
                    byte[] ibytes = ilog.getMaskedBytes(imask);
                    instr = program.getListing().getInstructionAt(instr.getMaxAddress().add(1L));
                    if (instr != null) {
                        ilog = new SleighDebugLogger(program, entry.add((long)ibytes.length), SleighDebugLogger.SleighDebugMode.MASKS_ONLY);
                        byte[] imask2 = ilog.getInstructionMask();
                        if (imask2.length == 1) {
                            imask2[0] = -1;
                        }
                        byte[] ibytes2 = ilog.getMaskedBytes(imask2);
                        ibytes1 = ibytes;
                        ibytes = new byte[((Object)ibytes1).length + ibytes2.length];
                        System.arraycopy(ibytes1, 0, ibytes, 0, ((Object)ibytes1).length);
                        System.arraycopy(ibytes2, 0, ibytes, ((Object)ibytes1).length, ibytes2.length);
                    }
                    if ((count = this.funcStartMap.get(bi = new BigInteger(ibytes))) != null) {
                        ibytes1 = count;
                        Integer n = count = Integer.valueOf(count + 1);
                        this.funcStartMap.put(bi, count);
                        continue;
                    }
                    this.funcStartMap.put(bi, 1);
                    this.funcStartContext.put(bi, disContext);
                }
                catch (IllegalStateException exc) {
                }
                catch (IllegalArgumentException exc) {}
            }
        }
        monitor.setMessage(NAME);
        long startAddressCount = set.getNumAddresses();
        monitor.initialize(startAddressCount);
        Collection<RegisterValue> contextStarts = this.funcStartContext.values();
        HashSet<RegisterValue> contextSet = new HashSet<RegisterValue>();
        contextSet.addAll(contextStarts);
        long count = 0L;
        while (!set.isEmpty()) {
            long currentAddressCount = set.getNumAddresses();
            monitor.setProgress(startAddressCount - currentAddressCount);
            Address minAddr = set.getMinAddress();
            Data data = this.listing.getUndefinedDataAt(minAddr);
            if (data == null) {
                set = set.subtract((AddressSetView)new AddressSet(minAddr, minAddr));
                data = this.listing.getFirstUndefinedData(set, monitor);
            }
            if (data == null) {
                return true;
            }
            if (++count % 4000L == 0L) {
                monitor.setMessage("AIF - " + minAddr);
            }
            Address entry = data.getMinAddress();
            if (monitor.isCancelled()) break;
            Address maxAddr = data.getMaxAddress();
            if (alignment > 1L) {
                maxAddr = maxAddr.add(alignment - 1L - maxAddr.getOffset() % alignment);
            }
            AddressSet subSet = new AddressSet(set.getMinAddress(), maxAddr);
            boolean contains = set.contains(entry);
            set = set.subtract((AddressSetView)subSet);
            try {
                PseudoDisassemblerContext pseudoContext;
                RegisterValue disContext2 = null;
                if (!contains) continue;
                Integer startCount = 0;
                boolean isvalid = false;
                for (RegisterValue disContext2 : contextSet) {
                    try {
                        SleighDebugLogger ilog;
                        pseudoContext = new PseudoDisassemblerContext(program.getProgramContext());
                        if (disContext2 != null) {
                            pseudoContext.flowStart(entry);
                            pseudoContext.setRegisterValue(disContext2);
                        }
                        if ((ilog = new SleighDebugLogger((MemBuffer)new MemoryBufferImpl(program.getMemory(), entry), (ProcessorContextView)pseudoContext, program.getLanguage(), SleighDebugLogger.SleighDebugMode.MASKS_ONLY)).parseFailed()) continue;
                        byte[] imask = ilog.getInstructionMask();
                        if (imask.length == 1) {
                            imask[0] = -1;
                        }
                        byte[] ibytes = ilog.getMaskedBytes(imask);
                        Address nextEntryAddr = entry.add((long)ibytes.length);
                        ilog = new SleighDebugLogger((MemBuffer)new MemoryBufferImpl(program.getMemory(), nextEntryAddr), (ProcessorContextView)pseudoContext, program.getLanguage(), SleighDebugLogger.SleighDebugMode.MASKS_ONLY);
                        byte[] imask2 = ilog.getInstructionMask();
                        if (imask2.length == 1) {
                            imask2[0] = -1;
                        }
                        byte[] ibytes2 = ilog.getMaskedBytes(imask2);
                        byte[] ibytes1 = ibytes;
                        ibytes = new byte[ibytes1.length + ibytes2.length];
                        System.arraycopy(ibytes1, 0, ibytes, 0, ibytes1.length);
                        System.arraycopy(ibytes2, 0, ibytes, ibytes1.length, ibytes2.length);
                        BigInteger bi = new BigInteger(ibytes);
                        startCount = this.funcStartMap.get(bi);
                        if (startCount == null || startCount < 4) continue;
                        RegisterValue possibleDisContext = this.funcStartContext.get(bi);
                        if (!possibleDisContext.equals((Object)disContext2)) {
                        }
                    }
                    catch (IllegalStateException exc) {}
                    continue;
                    pseudoContext = new PseudoDisassemblerContext(program.getProgramContext());
                    if (disContext2 != null) {
                        pseudoContext.setValue(disContext2.getRegister(), entry, disContext2.getUnsignedValueIgnoreMask());
                    }
                    if (!(isvalid = pseudo.checkValidSubroutine(entry, pseudoContext, true, false))) continue;
                    break;
                }
                if (!isvalid) continue;
                this.numInstr = 0;
                this.addsInfo = false;
                pseudoContext = new PseudoDisassemblerContext(program.getProgramContext());
                if (disContext2 != null) {
                    pseudoContext.setValue(disContext2.getRegister(), entry, disContext2.getUnsignedValueIgnoreMask());
                }
                AddressSet body = pseudo.followSubFlows(entry, pseudoContext, 4000, new PseudoFlowProcessor(){

                    public boolean followFlows(PseudoInstruction instr) {
                        return true;
                    }

                    public boolean process(PseudoInstruction instr) {
                        if (instr == null) {
                            AggressiveInstructionFinderAnalyzer.this.addsInfo = false;
                            return false;
                        }
                        ++AggressiveInstructionFinderAnalyzer.this.numInstr;
                        FlowType ftype = instr.getFlowType();
                        if (ftype.isTerminal()) {
                            return true;
                        }
                        Address[] flows = instr.getFlows();
                        if (flows != null && flows.length > 0) {
                            if (!AggressiveInstructionFinderAnalyzer.this.curProgram.getMemory().contains(flows[0])) {
                                AggressiveInstructionFinderAnalyzer.this.addsInfo = false;
                                return false;
                            }
                            if (ftype.isCall()) {
                                AggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                            }
                            if (ftype.isJump() && AggressiveInstructionFinderAnalyzer.this.listing.getInstructionAt(flows[0]) != null) {
                                AggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                            }
                        }
                        return true;
                    }
                });
                if (this.numInstr <= 2 || !this.addsInfo && startCount < 50 || this.listing.getDefinedData((AddressSetView)body, true).hasNext()) continue;
                monitor.setMessage("Aggressive Instruction Finder : " + entry);
                if (!isvalid) continue;
                program.getProgramContext().setRegisterValue(entry, entry, disContext2);
                DisassembleCommand cmd = new DisassembleCommand(entry, null, true);
                cmd.applyTo((DomainObject)program);
                set = set.subtract((AddressSetView)cmd.getDisassembledAddressSet());
                if (!this.createBookmarksEnabled) break;
                BookmarkEditCmd bcmd = new BookmarkEditCmd(entry, "Analysis", "Aggressive Intruction Finder", "Found code");
                bcmd.applyTo((DomainObject)program);
                break;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        if (!set.isEmpty()) {
            AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
            mgr.scheduleOneTimeAnalysis(this, set);
        }
        return true;
    }

    private AddressSetView checkExecBlocks(Program program, AddressSetView set) {
        MemoryBlock[] blocks;
        AddressSet execSet = new AddressSet();
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (!block.isExecute()) continue;
            execSet.addRange(block.getStart(), block.getEnd());
        }
        if (execSet.isEmpty()) {
            return set;
        }
        return set.intersect((AddressSetView)execSet);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

