/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InfiniteProgressPanel
extends JComponent
implements MouseListener {
    private static final String DEFAULT_MESSAGE_TEXT = "";
    private static final int DEFAULT_NUMBER_OF_BARS = 14;
    private static final float DEFAULT_SHIELD = 0.6f;
    private static final int DEFAULT_FRAMES_PER_SECOND = 7;
    private static final int DEFAULT_FADEIN_DELAY = 300;
    protected String text = "";
    protected int fadeDelay = 300;
    protected float shield = 0.6f;
    protected int barsCount = 14;
    protected int fps = 7;
    protected RenderingHints hints;
    protected Area[] ticker;
    protected Thread animation;
    protected boolean paintAnimation = false;
    protected int alphaLevel = 0;

    public InfiniteProgressPanel() {
        this(DEFAULT_MESSAGE_TEXT);
    }

    public InfiniteProgressPanel(String text) {
        this(text, 14);
    }

    public InfiniteProgressPanel(String text, int barsCount) {
        this(text, barsCount, 0.6f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield) {
        this(text, barsCount, shield, 7);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, int fps) {
        this(text, barsCount, shield, fps, 300);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, int fps, int rampDelay) {
        this.setText(text);
        this.fadeDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.fps = fps > 0 ? fps : 15;
        this.barsCount = barsCount > 0 ? barsCount : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void setText(String newText) {
        this.text = newText;
        if (this.text == null) {
            this.text = DEFAULT_MESSAGE_TEXT;
        }
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void start() {
        if (this.animation != null) {
            this.animation.interrupt();
        }
        this.removeMouseListener(this);
        this.addMouseListener(this);
        this.setVisible(true);
        this.ticker = this.buildTicker(this.barsCount);
        double fixIncrement = Math.PI * 2 / (double)this.barsCount;
        this.animation = new Thread(new Animator(fixIncrement, this.fadeDelay));
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            double fixIncrement = Math.PI * 2 / (double)this.barsCount;
            this.animation = new Thread(new FadeOutAnimator(fixIncrement, this.fadeDelay));
            this.animation.start();
        }
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    private Area[] buildTicker(int barCount) {
        Area[] newTicker = new Area[barCount];
        Point2D.Double center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double fixedAngle = Math.PI * 2 / (double)barCount;
        for (double i = 0.0; i < (double)barCount; i += 1.0) {
            Area primitive = this.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            newTicker[(int)i] = primitive;
        }
        return newTicker;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.paintAnimation) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        double maxY = 0.0;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.hints);
        g2.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
        g2.fillRect(0, 0, width, height);
        double textPosition = 0.0;
        for (Area element : this.ticker) {
            Rectangle2D bounds = element.getBounds2D();
            if (!(bounds.getMaxY() > textPosition)) continue;
            textPosition = bounds.getMaxY();
        }
        int channel = 0;
        int blue = 255;
        Color textColor = Color.BLACK;
        for (int i = 0; i < this.ticker.length; ++i) {
            channel = 264 - 128 / (i + 1);
            blue = channel + 126 > 255 ? 255 : channel + 126;
            Color color = new Color(channel, channel, blue, (int)((float)this.alphaLevel * this.shield));
            if (i == 0) {
                textColor = color;
            }
            g2.setColor(color);
            g2.fill(this.ticker[i]);
            Rectangle2D bounds = this.ticker[i].getBounds2D();
            if (!(bounds.getMaxY() > maxY)) continue;
            maxY = bounds.getMaxY();
        }
        this.paintText(g2, textColor, textPosition);
    }

    private void paintText(Graphics2D graphics, Color color, double textPosition) {
        if (this.text == null || this.text.trim().length() == 0) {
            return;
        }
        FontRenderContext context = graphics.getFontRenderContext();
        TextLayout layout = new TextLayout(this.text, this.getFont(), context);
        Rectangle2D bounds = layout.getBounds();
        graphics.setColor(Color.BLACK);
        layout.draw(graphics, (float)((double)this.getWidth() - bounds.getWidth()) / 2.0f, (float)(textPosition + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Ticker Test");
        frame.setSize(400, 600);
        final Component originalGlassPane = frame.getGlassPane();
        final InfiniteProgressPanel progressPanel = new InfiniteProgressPanel("Processing request...");
        progressPanel.fps = 7;
        progressPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                progressPanel.stop();
                frame.setGlassPane(originalGlassPane);
            }
        });
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        JTextArea textArea = new JTextArea(50, 40);
        textArea.setText("some text here...");
        scrollPane.getViewport().add(textArea);
        mainPanel.add((Component)scrollPane, "Center");
        JButton button = new JButton("Start");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setGlassPane(progressPanel);
                progressPanel.start();
            }
        });
        mainPanel.add((Component)button, "South");
        frame.setSize(400, 400);
        frame.setLocation(GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(mainPanel);
        frame.setVisible(true);
    }

    private class Animator
    implements Runnable {
        private boolean inRampUpPeriod = false;
        private final int rampDelayTime;
        private AffineTransform transformToCircle;
        private long startRampupTime;

        protected Animator(double transformTheta, int rampDelayTime) {
            this.rampDelayTime = rampDelayTime;
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressPanel.this.getWidth() / 2.0, (double)InfiniteProgressPanel.this.getHeight() / 2.0);
            this.transformToCircle = AffineTransform.getRotateInstance(transformTheta, center.getX(), center.getY());
        }

        @Override
        public void run() {
            this.startRampupTime = System.currentTimeMillis();
            if (this.rampDelayTime == 0) {
                InfiniteProgressPanel.this.alphaLevel = 255;
            }
            InfiniteProgressPanel.this.paintAnimation = true;
            this.inRampUpPeriod = true;
            while (!Thread.interrupted()) {
                this.transformTicker();
                InfiniteProgressPanel.this.repaint();
                this.updateBackgroundAlpha();
                if (this.pauseForEffect()) continue;
                break;
            }
        }

        protected boolean pauseForEffect() {
            try {
                Thread.sleep(1000 / InfiniteProgressPanel.this.fps);
            }
            catch (InterruptedException ie) {
                return false;
            }
            Thread.yield();
            return true;
        }

        protected void transformTicker() {
            if (this.inRampUpPeriod) {
                return;
            }
            for (Area element : InfiniteProgressPanel.this.ticker) {
                element.transform(this.transformToCircle);
            }
        }

        protected void updateBackgroundAlpha() {
            int increment;
            if (InfiniteProgressPanel.this.alphaLevel >= 255) {
                this.inRampUpPeriod = false;
                return;
            }
            int elapsedTime = (int)(System.currentTimeMillis() - this.startRampupTime);
            InfiniteProgressPanel.this.alphaLevel = increment = 255 * elapsedTime / this.rampDelayTime;
            if (InfiniteProgressPanel.this.alphaLevel >= 255) {
                InfiniteProgressPanel.this.alphaLevel = 255;
                this.inRampUpPeriod = false;
            }
        }
    }

    private class FadeOutAnimator
    implements Runnable {
        private final int fadeDelayTime;
        private AffineTransform transformToCircle;
        private long startRampupTime;

        private FadeOutAnimator(double transformTheta, int fadeDelayTime) {
            this.fadeDelayTime = fadeDelayTime;
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressPanel.this.getWidth() / 2.0, (double)InfiniteProgressPanel.this.getHeight() / 2.0);
            this.transformToCircle = AffineTransform.getRotateInstance(transformTheta, center.getX(), center.getY());
        }

        @Override
        public void run() {
            this.startRampupTime = System.currentTimeMillis();
            if (this.fadeDelayTime == 0) {
                InfiniteProgressPanel.this.alphaLevel = 0;
            }
            while (!Thread.interrupted() && InfiniteProgressPanel.this.alphaLevel > 0) {
                this.transformTicker();
                InfiniteProgressPanel.this.repaint();
                this.updateBackgroundAlpha();
                if (this.pauseForEffect()) continue;
            }
            InfiniteProgressPanel.this.paintAnimation = false;
            InfiniteProgressPanel.this.repaint();
            InfiniteProgressPanel.this.setVisible(false);
            InfiniteProgressPanel.this.removeMouseListener(InfiniteProgressPanel.this);
        }

        protected boolean pauseForEffect() {
            try {
                Thread.sleep(1000 / InfiniteProgressPanel.this.fps);
            }
            catch (InterruptedException ie) {
                return false;
            }
            Thread.yield();
            return true;
        }

        protected void transformTicker() {
            for (Area element : InfiniteProgressPanel.this.ticker) {
                element.transform(this.transformToCircle);
            }
        }

        protected void updateBackgroundAlpha() {
            if (InfiniteProgressPanel.this.alphaLevel <= 0) {
                return;
            }
            int elapsedTime = (int)(System.currentTimeMillis() - this.startRampupTime);
            int increment = 255 * elapsedTime / this.fadeDelayTime;
            InfiniteProgressPanel.this.alphaLevel = 255 - increment;
            if (InfiniteProgressPanel.this.alphaLevel <= 0) {
                InfiniteProgressPanel.this.alphaLevel = 0;
            }
        }
    }
}

