/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

public class SearchData {
    private String inputString;
    protected String errorMessage;
    private byte[] bytes;
    private byte[] mask;
    private boolean isValidInputData;
    private boolean isValidSearchData;

    protected SearchData(String inputString, byte[] searchBytes, byte[] mask) {
        this.isValidInputData = true;
        this.isValidSearchData = true;
        this.inputString = inputString;
        this.bytes = searchBytes == null ? new byte[]{} : searchBytes;
        this.mask = mask;
    }

    private SearchData(String errorMessage, boolean isValidInputData) {
        this.isValidInputData = isValidInputData;
        this.isValidSearchData = false;
        this.bytes = new byte[0];
        this.errorMessage = errorMessage;
    }

    public static SearchData createSearchData(String inputString, byte[] searchBytes, byte[] mask) {
        return new SearchData(inputString, searchBytes, mask);
    }

    public static SearchData createIncompleteSearchData(String errorMessage) {
        return new SearchData(errorMessage, true);
    }

    public static SearchData createInvalidInputSearchData(String errorMessage) {
        return new SearchData(errorMessage, false);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public boolean isValidInputData() {
        return this.isValidInputData;
    }

    public boolean isValidSearchData() {
        return this.isValidSearchData;
    }

    public String getInputString() {
        return this.inputString;
    }

    public String getStatusMessage() {
        return this.errorMessage;
    }

    public String getHexString() {
        StringBuilder buf = new StringBuilder();
        for (byte element : this.bytes) {
            String hexString = Integer.toHexString(element & 0xFF);
            if (hexString.length() == 1) {
                buf.append("0");
            }
            buf.append(hexString);
            buf.append(" ");
        }
        return buf.toString();
    }
}

