/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.plugin.core.function.AbstractEditFunctionSignatureDialog;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;

public class EditFunctionSignatureDialog
extends AbstractEditFunctionSignatureDialog {
    protected final Function function;
    protected final String oldFunctionSignature;

    public EditFunctionSignatureDialog(PluginTool tool, String title, Function function) {
        super(tool, title, EditFunctionSignatureDialog.allowInLine(function), true, EditFunctionSignatureDialog.allowCallFixup(function));
        this.function = function;
        this.oldFunctionSignature = function.getSignature().getPrototypeString();
    }

    protected EditFunctionSignatureDialog(PluginTool tool, String title, Function function, boolean allowInLine, boolean allowNoReturn, boolean allowCallFixup) {
        super(tool, title, allowInLine, allowNoReturn, allowCallFixup);
        this.function = function;
        this.oldFunctionSignature = function.getSignature().getPrototypeString();
    }

    @Override
    protected FunctionSignature getFunctionSignature() {
        return this.function.getSignature();
    }

    @Override
    protected String getPrototypeString() {
        return this.oldFunctionSignature;
    }

    @Override
    protected String getCallingConventionName() {
        return this.function.getCallingConventionName();
    }

    @Override
    protected List<String> getCallingConventionNames() {
        return this.function.getProgram().getFunctionManager().getCallingConventionNames();
    }

    @Override
    protected boolean isInline() {
        return this.function.isInline();
    }

    @Override
    protected boolean hasNoReturn() {
        return this.function.hasNoReturn();
    }

    @Override
    protected String getCallFixupName() {
        return this.function.getCallFixup();
    }

    private static String[] getCallFixupNames(Function function) {
        String[] callFixupNames = function.getProgram().getCompilerSpec().getPcodeInjectLibrary().getCallFixupNames();
        if (callFixupNames.length == 0) {
            return null;
        }
        return callFixupNames;
    }

    @Override
    protected String[] getSupportedCallFixupNames() {
        return EditFunctionSignatureDialog.getCallFixupNames(this.function);
    }

    @Override
    protected DataTypeManager getDataTypeManager() {
        return this.function.getProgram().getDataTypeManager();
    }

    private static Function getEffectiveFunction(Function f) {
        return f.isThunk() ? f.getThunkedFunction(true) : f;
    }

    private static boolean allowInLine(Function function) {
        return !EditFunctionSignatureDialog.getEffectiveFunction(function).isExternal();
    }

    private static boolean allowCallFixup(Function function) {
        return EditFunctionSignatureDialog.getCallFixupNames(function) != null;
    }

    @Override
    protected boolean applyChanges() throws CancelledException {
        Command command = this.createCommand();
        if (command == null) {
            return false;
        }
        if (!this.getTool().execute(command, (DomainObject)this.function.getProgram())) {
            this.setStatusText(command.getStatusMsg());
            return false;
        }
        this.setStatusText("");
        return true;
    }

    private Command createCommand() throws CancelledException {
        ApplyFunctionSignatureCmd cmd = null;
        if (this.isSignatureChanged() || this.isCallingConventionChanged() || this.function.getSignatureSource() == SourceType.DEFAULT) {
            FunctionDefinitionDataType definition = this.parseSignature();
            if (definition == null) {
                return null;
            }
            cmd = new ApplyFunctionSignatureCmd(this.function.getEntryPoint(), (FunctionSignature)definition, SourceType.USER_DEFINED, true, true);
        }
        CompoundCmd compoundCommand = new CompoundCmd("Update Function Signature");
        compoundCommand.add(new Command(){
            String errMsg = null;

            public boolean applyTo(DomainObject obj) {
                try {
                    String conventionName = EditFunctionSignatureDialog.this.getCallingConvention();
                    if ("unknown".equals(conventionName)) {
                        conventionName = null;
                    } else if ("default".equals(conventionName)) {
                        conventionName = EditFunctionSignatureDialog.this.function.getDefaultCallingConventionName();
                    }
                    EditFunctionSignatureDialog.this.function.setCallingConvention(conventionName);
                    return true;
                }
                catch (InvalidInputException e) {
                    this.errMsg = "Invalid calling convention. " + e.getMessage();
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    return false;
                }
            }

            public String getName() {
                return "Update Function Calling Convention";
            }

            public String getStatusMsg() {
                return this.errMsg;
            }
        });
        if (this.allowInLine) {
            compoundCommand.add(new Command(){

                public boolean applyTo(DomainObject obj) {
                    EditFunctionSignatureDialog.this.function.setInline(EditFunctionSignatureDialog.this.isInlineSelected());
                    return true;
                }

                public String getName() {
                    return "Update Function Inline Flag";
                }

                public String getStatusMsg() {
                    return null;
                }
            });
        }
        if (this.allowNoReturn) {
            compoundCommand.add(new Command(){

                public boolean applyTo(DomainObject obj) {
                    EditFunctionSignatureDialog.this.function.setNoReturn(EditFunctionSignatureDialog.this.hasNoReturnSelected());
                    return true;
                }

                public String getName() {
                    return "Update Function No Return Flag";
                }

                public String getStatusMsg() {
                    return null;
                }
            });
        }
        if (this.allowCallFixup) {
            compoundCommand.add(new Command(){

                public boolean applyTo(DomainObject obj) {
                    EditFunctionSignatureDialog.this.function.setCallFixup(EditFunctionSignatureDialog.this.getCallFixupSelection());
                    return true;
                }

                public String getName() {
                    return "Update Function Call-Fixup";
                }

                public String getStatusMsg() {
                    return null;
                }
            });
        }
        if (cmd != null) {
            compoundCommand.add((Command)cmd);
        }
        return compoundCommand;
    }
}

