/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.BigIntegerPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import java.math.BigInteger;

public interface PcodeArithmetic<T> {
    public static final PcodeArithmetic<byte[]> BYTES_BE = BytesPcodeArithmetic.BIG_ENDIAN;
    public static final PcodeArithmetic<byte[]> BYTES_LE = BytesPcodeArithmetic.LITTLE_ENDIAN;
    @Deprecated(forRemoval=true)
    public static final PcodeArithmetic<BigInteger> BIGINT = BigIntegerPcodeArithmetic.INSTANCE;

    public T unaryOp(UnaryOpBehavior var1, int var2, int var3, T var4);

    public T binaryOp(BinaryOpBehavior var1, int var2, int var3, T var4, int var5, T var6);

    public T fromConst(long var1, int var3);

    public T fromConst(BigInteger var1, int var2, boolean var3);

    default public T fromConst(BigInteger value, int size) {
        return this.fromConst(value, size, false);
    }

    public boolean isTrue(T var1);

    public BigInteger toConcrete(T var1, boolean var2);

    default public BigInteger toConcrete(T value) {
        return this.toConcrete(value, false);
    }
}

