/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.lang.Language;
import java.math.BigInteger;

public enum BytesPcodeArithmetic implements PcodeArithmetic<byte[]>
{
    BIG_ENDIAN(true),
    LITTLE_ENDIAN(false);

    private final boolean isBigEndian;

    public static BytesPcodeArithmetic forEndian(boolean bigEndian) {
        return bigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    public static BytesPcodeArithmetic forLanguage(Language language) {
        return BytesPcodeArithmetic.forEndian(language.isBigEndian());
    }

    private BytesPcodeArithmetic(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
    }

    @Override
    public byte[] unaryOp(UnaryOpBehavior op, int sizeout, int sizein1, byte[] in1) {
        if (sizein1 > 8 || sizeout > 8) {
            BigInteger in1Val = Utils.bytesToBigInteger((byte[])in1, (int)in1.length, (boolean)this.isBigEndian, (boolean)false);
            BigInteger outVal = op.evaluateUnary(sizeout, sizein1, in1Val);
            return Utils.bigIntegerToBytes((BigInteger)outVal, (int)sizeout, (boolean)this.isBigEndian);
        }
        long in1Val = Utils.bytesToLong((byte[])in1, (int)sizein1, (boolean)this.isBigEndian);
        long outVal = op.evaluateUnary(sizeout, sizein1, in1Val);
        return Utils.longToBytes((long)outVal, (int)sizeout, (boolean)this.isBigEndian);
    }

    @Override
    public byte[] binaryOp(BinaryOpBehavior op, int sizeout, int sizein1, byte[] in1, int sizein2, byte[] in2) {
        if (sizein1 > 8 || sizein2 > 8 || sizeout > 8) {
            BigInteger in1Val = Utils.bytesToBigInteger((byte[])in1, (int)sizein1, (boolean)this.isBigEndian, (boolean)false);
            BigInteger in2Val = Utils.bytesToBigInteger((byte[])in2, (int)sizein2, (boolean)this.isBigEndian, (boolean)false);
            BigInteger outVal = op.evaluateBinary(sizeout, sizein1, in1Val, in2Val);
            return Utils.bigIntegerToBytes((BigInteger)outVal, (int)sizeout, (boolean)this.isBigEndian);
        }
        long in1Val = Utils.bytesToLong((byte[])in1, (int)sizein1, (boolean)this.isBigEndian);
        long in2Val = Utils.bytesToLong((byte[])in2, (int)sizein2, (boolean)this.isBigEndian);
        long outVal = op.evaluateBinary(sizeout, sizein1, in1Val, in2Val);
        return Utils.longToBytes((long)outVal, (int)sizeout, (boolean)this.isBigEndian);
    }

    @Override
    public byte[] fromConst(long value, int size) {
        return Utils.longToBytes((long)value, (int)size, (boolean)this.isBigEndian);
    }

    @Override
    public byte[] fromConst(BigInteger value, int size, boolean isContextreg) {
        return Utils.bigIntegerToBytes((BigInteger)value, (int)size, (this.isBigEndian || isContextreg ? 1 : 0) != 0);
    }

    @Override
    public boolean isTrue(byte[] cond) {
        for (byte b : cond) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public BigInteger toConcrete(byte[] value, boolean isContextreg) {
        return Utils.bytesToBigInteger((byte[])value, (int)value.length, (this.isBigEndian || isContextreg ? 1 : 0) != 0, (boolean)false);
    }
}

