/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.EnumeratedColumnTableModel;
import docking.widgets.table.TableSortStateEditor;
import docking.widgets.table.TableSortingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public class DefaultEnumeratedColumnTableModel<C extends Enum<C>, R>
extends AbstractSortedTableModel<R>
implements EnumeratedColumnTableModel<R> {
    private final List<R> modelData = new ArrayList<R>();
    private final String name;
    private final C[] cols;

    public DefaultEnumeratedColumnTableModel(String name, Class<C> colType) {
        this.name = name;
        this.cols = (Enum[])colType.getEnumConstants();
        this.setupDefaultSortOrder();
    }

    public String getName() {
        return this.name;
    }

    public List<R> getModelData() {
        return this.modelData;
    }

    protected void setupDefaultSortOrder() {
        List<C> defaultOrder = this.defaultSortOrder();
        if (defaultOrder.isEmpty()) {
            return;
        }
        TableSortStateEditor editor = new TableSortStateEditor();
        for (Enum col : defaultOrder) {
            editor.addSortedColumn(col.ordinal(), ((EnumeratedTableColumn)((Object)col)).defaultSortDirection());
        }
        this.setDefaultTableSortState(editor.createTableSortState());
    }

    public List<C> defaultSortOrder() {
        return Collections.emptyList();
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        List<R> list = this.modelData;
        synchronized (list) {
            R row = this.modelData.get(rowIndex);
            C col = this.cols[columnIndex];
            Class<?> cls = ((EnumeratedTableColumn)col).getValueClass();
            ((EnumeratedTableColumn)col).setValueOf(row, cls.cast(aValue));
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        List<R> list = this.modelData;
        synchronized (list) {
            R row = this.modelData.get(rowIndex);
            C col = this.cols[columnIndex];
            return ((EnumeratedTableColumn)col).isEditable(row);
        }
    }

    public boolean isSortable(int columnIndex) {
        C col = this.cols[columnIndex];
        return ((EnumeratedTableColumn)col).isSortable();
    }

    public Class<?> getColumnClass(int columnIndex) {
        return ((EnumeratedTableColumn)this.cols[columnIndex]).getValueClass();
    }

    public String getColumnName(int column) {
        return ((EnumeratedTableColumn)this.cols[column]).getHeader();
    }

    public Object getColumnValueForRow(R t, int columnIndex) {
        return ((EnumeratedTableColumn)this.cols[columnIndex]).getValueOf(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.size();
            this.modelData.add(row);
        }
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(Collection<R> c) {
        int endIndex;
        int startIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            startIndex = this.modelData.size();
            this.modelData.addAll(c);
            endIndex = this.modelData.size() - 1;
        }
        this.fireTableRowsInserted(startIndex, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUpdated(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.indexOf(row);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> notifyUpdatedWith(Predicate<R> predicate) {
        int lastIndexUpdated = 0;
        ArrayList<R> updated = new ArrayList<R>();
        ListIterator<R> rit = this.modelData.listIterator();
        List<R> list = this.modelData;
        synchronized (list) {
            while (rit.hasNext()) {
                R row = rit.next();
                if (!predicate.test(row)) continue;
                lastIndexUpdated = rit.previousIndex();
                updated.add(row);
            }
        }
        int size = updated.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsUpdated(lastIndexUpdated, lastIndexUpdated);
            } else {
                this.fireTableDataChanged();
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(R row) {
        int rowIndex;
        List<R> list = this.modelData;
        synchronized (list) {
            rowIndex = this.modelData.indexOf(row);
            if (rowIndex == -1) {
                return;
            }
            this.modelData.remove(rowIndex);
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> deleteWith(Predicate<R> predicate) {
        int lastIndexRemoved = 0;
        ArrayList<R> removed = new ArrayList<R>();
        List<R> list = this.modelData;
        synchronized (list) {
            ListIterator<R> rit = this.modelData.listIterator();
            while (rit.hasNext()) {
                R row = rit.next();
                if (!predicate.test(row)) continue;
                lastIndexRemoved = rit.previousIndex();
                rit.remove();
                removed.add(row);
            }
        }
        int size = removed.size();
        if (size != 0) {
            if (size == 1) {
                this.fireTableRowsDeleted(lastIndexRemoved, lastIndexRemoved);
            } else {
                this.fireTableDataChanged();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R findFirst(Predicate<R> predicate) {
        List<R> list = this.modelData;
        synchronized (list) {
            for (R row : this.modelData) {
                if (!predicate.test(row)) continue;
                return row;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<R> list = this.modelData;
        synchronized (list) {
            this.modelData.clear();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sort(List<R> data, TableSortingContext<R> sortingContext) {
        List<R> list = data;
        synchronized (list) {
            super.sort(data, sortingContext);
        }
    }

    public class TableRowIterator
    implements EnumeratedColumnTableModel.RowIterator<R> {
        protected final ListIterator<R> it;
        protected int index;

        public TableRowIterator() {
            this.it = DefaultEnumeratedColumnTableModel.this.modelData.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public R next() {
            this.index = this.it.nextIndex();
            return this.it.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public R previous() {
            this.index = this.it.previousIndex();
            return this.it.previous();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
            DefaultEnumeratedColumnTableModel.this.fireTableRowsDeleted(this.index, this.index);
        }

        @Override
        public void set(R e) {
            this.it.set(e);
            DefaultEnumeratedColumnTableModel.this.fireTableRowsUpdated(this.index, this.index);
        }

        @Override
        public void notifyUpdated() {
            DefaultEnumeratedColumnTableModel.this.fireTableRowsUpdated(this.index, this.index);
        }

        @Override
        public void add(R e) {
            this.it.add(e);
            int nextIndex = this.it.nextIndex();
            DefaultEnumeratedColumnTableModel.this.fireTableRowsInserted(nextIndex, nextIndex);
        }
    }

    public static interface EnumeratedTableColumn<C extends Enum<C>, R> {
        public Class<?> getValueClass();

        public Object getValueOf(R var1);

        public String getHeader();

        default public void setValueOf(R row, Object value) {
            throw new UnsupportedOperationException("Cell is not editable");
        }

        default public boolean isEditable(R row) {
            return false;
        }

        default public boolean isSortable() {
            return true;
        }

        default public ColumnSortState.SortDirection defaultSortDirection() {
            return ColumnSortState.SortDirection.ASCENDING;
        }
    }
}

