/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.client;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugRunningProcess;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.impl.dbgeng.client.DebugClientImpl2;
import agent.dbgeng.jna.dbgeng.client.IDebugClient3;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.comm.util.BitmaskSet;

public class DebugClientImpl3
extends DebugClientImpl2 {
    private final IDebugClient3 jnaClient;

    public DebugClientImpl3(IDebugClient3 jnaClient) {
        super(jnaClient);
        this.jnaClient = jnaClient;
    }

    @Override
    public void createProcess(DebugServerId si, String commandLine, BitmaskSet<DebugClient.DebugCreateFlags> createFlags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG ulFlags = new WinDef.ULONG(createFlags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.CreateProcessWide(ullServer, new WString(commandLine), ulFlags));
    }

    @Override
    public DebugRunningProcess.Description getProcessDescription(DebugServerId si, int systemId, BitmaskSet<DebugRunningProcess.Description.ProcessDescriptionFlags> flags) {
        WinDef.ULONGLONG server = new WinDef.ULONGLONG(si.id);
        WinDef.ULONG id = new WinDef.ULONG((long)systemId);
        WinDef.ULONG f = new WinDef.ULONG(flags.getBitmask());
        WinDef.ULONGByReference actualExeNameSize = new WinDef.ULONGByReference();
        WinDef.ULONGByReference actualDescriptionSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessDescriptionWide(server, id, f, null, new WinDef.ULONG(0L), actualExeNameSize, null, new WinDef.ULONG(0L), actualDescriptionSize));
        char[] exeName = new char[actualExeNameSize.getValue().intValue()];
        char[] description = new char[actualDescriptionSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.GetRunningProcessDescriptionWide(server, id, f, exeName, actualExeNameSize.getValue(), null, description, actualDescriptionSize.getValue(), null));
        return new DebugRunningProcess.Description(systemId, Native.toString((char[])exeName), Native.toString((char[])description));
    }
}

