/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class ShortArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MIN_SIZE = 4;
    short[] shorts = new short[4];
    int lastNonZeroIndex = -1;

    public void put(int index, short value) {
        if (value == 0) {
            this.remove(index);
            return;
        }
        if (index >= this.shorts.length) {
            this.adjustArray(Math.max(index + 1, this.shorts.length * 2));
        }
        this.shorts[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.shorts.length) {
            return;
        }
        this.shorts[index] = 0;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.shorts.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.shorts[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public short get(int index) {
        if (index < this.shorts.length) {
            return this.shorts[index];
        }
        return 0;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        short[] newshorts = new short[size];
        int len = Math.min(size, this.shorts.length);
        System.arraycopy(this.shorts, 0, newshorts, 0, len);
        this.shorts = newshorts;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putShort(toIndex, toCol, this.get(index));
    }
}

