/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class FilterPanelLayout
implements LayoutManager {
    private int componentWidth;
    private int hgap;

    public FilterPanelLayout(int componentWidth, int hgap) {
        this.componentWidth = componentWidth;
        this.hgap = hgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.getPreferredWidth(parent), this.getPreferredHeight(parent));
    }

    private int getPreferredHeight(Container parent) {
        int n = parent.getComponentCount();
        int preferredHeight = 0;
        Insets insets = parent.getInsets();
        for (int i = 0; i < n; ++i) {
            Component component = parent.getComponent(i);
            int height = component.getPreferredSize().height;
            preferredHeight = Math.max(preferredHeight, height);
        }
        return preferredHeight + insets.top + insets.bottom;
    }

    private int getPreferredWidth(Container parent) {
        int n = parent.getComponentCount();
        int lastWidth = n == 3 ? parent.getComponent((int)2).getPreferredSize().width : 0;
        Insets insets = parent.getInsets();
        return insets.left + 2 * this.hgap + 2 * this.componentWidth + lastWidth;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Component component;
        int n = parent.getComponentCount();
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int x = insets.left;
        int y = insets.top;
        if (n > 0) {
            component = parent.getComponent(0);
            component.setBounds(x, y, this.componentWidth, component.getPreferredSize().height);
        }
        x += this.componentWidth + this.hgap;
        if (n > 1) {
            component = parent.getComponent(1);
            component.setBounds(x, y, this.componentWidth, component.getPreferredSize().height);
        }
        x += this.componentWidth + this.hgap;
        if (n > 2) {
            component = parent.getComponent(2);
            int remainingWidth = d.width - insets.left - insets.right - x;
            component.setBounds(x, y, remainingWidth, component.getPreferredSize().height);
        }
    }
}

