/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReadTextDialog
extends DialogComponentProvider {
    private JTextArea textArea;
    private JPanel workPanel;

    public ReadTextDialog(String title, String text) {
        super(title, true, false, true, false);
        this.init(this.createWorkPanel(text));
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    private void init(JPanel workPanelToInit) {
        this.setTransient(true);
        this.addWorkPanel(workPanelToInit);
        this.addOKButton();
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    @Override
    protected void okCallback() {
        this.close();
    }

    private JPanel createWorkPanel(String text) {
        this.workPanel = new JPanel(new BorderLayout());
        this.textArea = new JTextArea(10, 80);
        this.textArea.setText(text);
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(5, 5, 5, 5));
        DockingUtils.setTransparent(this.textArea);
        this.textArea.setCaretPosition(0);
        JScrollPane scrolledDetails = new JScrollPane(this.textArea);
        this.workPanel.add((Component)scrolledDetails, "Center");
        return this.workPanel;
    }
}

