/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import ghidra.framework.preferences.Preferences;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.CenterTranslateIcon;

public class ToggleNavigationAid
extends AbstractAction {
    private static final Icon ENABLED_ICON = ResourceManager.loadImage((String)"images/software-update-available.png");
    private static final Icon CANCEL_ICON = ResourceManager.loadImage((String)"images/dialog-cancel.png");
    private static Icon DISABLED_ICON;
    private boolean showingNavigationAid = true;

    public ToggleNavigationAid() {
        this.putValue("SmallIcon", new SelfPaintingIcon());
        this.putValue("ShortDescription", "Paints an on-screen marker to show the current location when navigating within the help system");
        CenterTranslateIcon translatedIcon = new CenterTranslateIcon(CANCEL_ICON, ENABLED_ICON.getIconWidth());
        ImageIcon disabledBaseIcon = ResourceManager.getDisabledIcon((Icon)ENABLED_ICON, (int)50);
        DISABLED_ICON = new MultiIcon((Icon)disabledBaseIcon, new Icon[]{translatedIcon});
        String value = Preferences.getProperty((String)"SHOW.HELP.NAVIGATION.AID");
        if (value != null) {
            this.showingNavigationAid = Boolean.parseBoolean(value);
        } else {
            this.savePreference();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showingNavigationAid = !this.showingNavigationAid;
        this.savePreference();
    }

    private void savePreference() {
        Preferences.setProperty((String)"SHOW.HELP.NAVIGATION.AID", (String)Boolean.toString(this.showingNavigationAid));
        Preferences.store();
    }

    private class SelfPaintingIcon
    implements Icon {
        private SelfPaintingIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getIcon();
            icon.paintIcon(c, g, x, y);
        }

        private Icon getIcon() {
            return ToggleNavigationAid.this.showingNavigationAid ? ENABLED_ICON : DISABLED_ICON;
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }
    }
}

