/*
 * Decompiled with CFR 0.152.
 */
package docking.action.builder;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.builder.AbstractActionBuilder;
import docking.menu.MultiActionDockingAction;
import java.util.Collections;
import java.util.List;

public class MultiActionBuilder
extends AbstractActionBuilder<MultiActionDockingAction, ActionContext, MultiActionBuilder> {
    private List<DockingActionIf> actionList = Collections.emptyList();
    private boolean performActionOnButtonClick = true;

    public MultiActionBuilder(String name, String owner) {
        super(name, owner);
    }

    @Override
    protected MultiActionBuilder self() {
        return this;
    }

    @Override
    public MultiActionDockingAction build() {
        this.validate();
        MultiActionDockingAction action = new MultiActionDockingAction(this.name, this.owner){

            @Override
            public void actionPerformed(ActionContext context) {
                MultiActionBuilder.this.actionCallback.accept(context);
            }
        };
        this.decorateAction(action);
        action.setActions(this.actionList);
        action.setPerformActionOnButtonClick(this.performActionOnButtonClick);
        return action;
    }

    public MultiActionBuilder withActions(List<DockingActionIf> list) {
        this.actionList = list;
        for (DockingActionIf action : this.actionList) {
            if (action.getMenuBarData() != null) continue;
            throw new IllegalStateException("actions in the actionList must have MenuBarData defined");
        }
        return this.self();
    }

    public MultiActionBuilder performActionOnButtonClick(boolean b) {
        this.performActionOnButtonClick = b;
        return this.self();
    }

    @Override
    protected void validate() {
        if (this.performActionOnButtonClick) {
            super.validate();
        }
        if (this.actionList == null) {
            throw new IllegalStateException("No ActionList has been set");
        }
    }
}

