/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.oat.OatConstants;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatHeader_10;
import ghidra.file.formats.android.oat.OatHeader_11;
import ghidra.file.formats.android.oat.OatHeader_12;
import ghidra.file.formats.android.oat.OatHeader_KitKat;
import ghidra.file.formats.android.oat.OatHeader_Lollipop;
import ghidra.file.formats.android.oat.OatHeader_Marshmallow;
import ghidra.file.formats.android.oat.OatHeader_Nougat;
import ghidra.file.formats.android.oat.OatHeader_Oreo;
import ghidra.file.formats.android.oat.OatHeader_Oreo_M2;
import ghidra.file.formats.android.oat.OatHeader_Pie;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.bundle.OatBundleFactory;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public final class OatHeaderFactory {
    public static final OatHeader newOatHeader(BinaryReader reader) throws IOException, UnsupportedOatVersionException {
        String magic = new String(reader.readByteArray(0L, "oat\n".length()));
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("oat\n") && OatConstants.isSupportedVersion(version)) {
            switch (version) {
                case "007": {
                    return new OatHeader_KitKat(reader);
                }
                case "039": 
                case "045": 
                case "051": {
                    return new OatHeader_Lollipop(reader);
                }
                case "064": {
                    return new OatHeader_Marshmallow(reader);
                }
                case "079": 
                case "088": {
                    return new OatHeader_Nougat(reader);
                }
                case "124": 
                case "126": {
                    return new OatHeader_Oreo(reader);
                }
                case "131": {
                    return new OatHeader_Oreo_M2(reader);
                }
                case "138": {
                    return new OatHeader_Pie(reader);
                }
                case "170": {
                    return new OatHeader_10(reader);
                }
                case "183": {
                    return new OatHeader_11(reader);
                }
                case "195": {
                    return new OatHeader_12(reader);
                }
            }
        }
        throw new UnsupportedOatVersionException(magic, version);
    }

    public static final void parseOatHeader(OatHeader oatHeader, Program oatProgram, BinaryReader reader, TaskMonitor monitor, MessageLog log) throws UnsupportedOatVersionException, IOException {
        OatBundle bundle = OatBundleFactory.getOatBundle(oatProgram, oatHeader, monitor, log);
        oatHeader.parse(reader, bundle);
        bundle.close();
    }
}

