/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControlOutputStyle;
import net.htmlparser.jericho.FormControlType;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;

public abstract class FormControl
extends Segment {
    FormControlType formControlType;
    String name;
    ElementContainer elementContainer;
    FormControlOutputStyle outputStyle = FormControlOutputStyle.NORMAL;
    private static final String CHECKBOX_NULL_DEFAULT_VALUE = "on";
    private static Comparator<FormControl> COMPARATOR = new PositionComparator();

    static FormControl construct(Element element) {
        String tagName = element.getStartTag().getName();
        if (tagName == "input") {
            String typeAttributeValue = element.getAttributes().getRawValue("type");
            if (typeAttributeValue == null) {
                return new InputFormControl(element, FormControlType.TEXT);
            }
            FormControlType formControlType = FormControlType.getFromInputElementType(typeAttributeValue);
            if (formControlType == null) {
                if (FormControlType.isNonFormControl(typeAttributeValue)) {
                    return null;
                }
                if (element.source.logger.isErrorEnabled()) {
                    element.source.logger.error(element.source.getRowColumnVector(element.begin).appendTo(new StringBuilder(200)).append(": INPUT control with unrecognised type \"").append(typeAttributeValue).append("\" assumed to be type \"text\"").toString());
                }
                formControlType = FormControlType.TEXT;
            }
            switch (formControlType) {
                case TEXT: {
                    return new InputFormControl(element, formControlType);
                }
                case CHECKBOX: 
                case RADIO: {
                    return new RadioCheckboxFormControl(element, formControlType);
                }
                case SUBMIT: {
                    return new SubmitFormControl(element, formControlType);
                }
                case IMAGE: {
                    return new ImageSubmitFormControl(element);
                }
                case HIDDEN: 
                case PASSWORD: 
                case FILE: {
                    return new InputFormControl(element, formControlType);
                }
            }
            throw new AssertionError((Object)formControlType);
        }
        if (tagName == "select") {
            return new SelectFormControl(element);
        }
        if (tagName == "textarea") {
            return new TextAreaFormControl(element);
        }
        if (tagName == "button") {
            return "submit".equalsIgnoreCase(element.getAttributes().getRawValue("type")) ? new SubmitFormControl(element, FormControlType.BUTTON) : null;
        }
        return null;
    }

    private FormControl(Element element, FormControlType formControlType, boolean loadPredefinedValue) {
        super(element.source, element.begin, element.end);
        this.elementContainer = new ElementContainer(element, loadPredefinedValue);
        this.formControlType = formControlType;
        this.name = element.getAttributes().getValue("name");
        this.verifyName();
    }

    public final FormControlType getFormControlType() {
        return this.formControlType;
    }

    public final String getName() {
        return this.name;
    }

    public final Element getElement() {
        return this.elementContainer.element;
    }

    public Iterator<Element> getOptionElementIterator() {
        throw new UnsupportedOperationException("Only SELECT controls contain OPTION elements");
    }

    public FormControlOutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(FormControlOutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    public final Map<String, String> getAttributesMap() {
        return this.elementContainer.getAttributesMap();
    }

    public final boolean isDisabled() {
        return this.elementContainer.getBooleanAttribute("disabled");
    }

    public final void setDisabled(boolean disabled) {
        this.elementContainer.setBooleanAttribute("disabled", disabled);
    }

    public boolean isChecked() {
        throw new UnsupportedOperationException("This property is only relevant for CHECKBOX and RADIO controls");
    }

    public String getPredefinedValue() {
        return this.elementContainer.predefinedValue;
    }

    public Collection<String> getPredefinedValues() {
        if (this.getPredefinedValue() == null) {
            Collections.emptySet();
        }
        return Collections.singleton(this.getPredefinedValue());
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        this.addValuesTo(values);
        return values;
    }

    public final void clearValues() {
        this.setValue(null);
    }

    public abstract boolean setValue(String var1);

    public boolean addValue(String value) {
        return this.setValue(value);
    }

    abstract void addValuesTo(Collection<String> var1);

    abstract void addToFormFields(FormFields var1);

    abstract void replaceInOutputDocument(OutputDocument var1);

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.formControlType);
        if (this.name != null) {
            sb.append(" name=\"").append(this.name).append('\"');
        }
        if (this.elementContainer.predefinedValue != null) {
            sb.append(" PredefinedValue=\"").append(this.elementContainer.predefinedValue).append('\"');
        }
        sb.append(" - ").append(this.getElement().getDebugInfo());
        return sb.toString();
    }

    final String getDisplayValueHTML(CharSequence text, boolean whiteSpaceFormatting) {
        StringBuilder sb = new StringBuilder((text == null ? 0 : text.length() * 2) + 50);
        sb.append('<').append(FormControlOutputStyle.ConfigDisplayValue.ElementName);
        try {
            for (String attributeName : FormControlOutputStyle.ConfigDisplayValue.AttributeNames) {
                String attributeValue = this.elementContainer.getAttributeValue(attributeName);
                if (attributeValue == null) continue;
                Attribute.appendHTML(sb, attributeName, attributeValue);
            }
            sb.append('>');
            if (text == null || text.length() == 0) {
                sb.append(FormControlOutputStyle.ConfigDisplayValue.EmptyHTML);
            } else if (whiteSpaceFormatting) {
                sb.append(CharacterReference.encodeWithWhiteSpaceFormatting(text));
            } else {
                CharacterReference.appendEncode((Appendable)sb, text, false);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        sb.append("</").append(FormControlOutputStyle.ConfigDisplayValue.ElementName).append('>');
        return sb.toString();
    }

    final void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
        this.elementContainer.replaceAttributesInOutputDocumentIfModified(outputDocument);
    }

    static List<FormControl> getAll(Segment segment) {
        ArrayList<FormControl> list = new ArrayList<FormControl>();
        FormControl.getAll(segment, list, "input");
        FormControl.getAll(segment, list, "textarea");
        FormControl.getAll(segment, list, "select");
        FormControl.getAll(segment, list, "button");
        Collections.sort(list, COMPARATOR);
        return list;
    }

    private static void getAll(Segment segment, ArrayList<FormControl> list, String tagName) {
        for (Element element : segment.getAllElements(tagName)) {
            FormControl formControl = element.getFormControl();
            if (formControl == null) continue;
            list.add(formControl);
        }
    }

    private static String getString(char ch, int length) {
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    private void verifyName() {
        if (this.formControlType.isSubmit()) {
            return;
        }
        if (this.name == null) {
            return;
        }
        if (this.name.length() != 0) {
            return;
        }
        Source source = this.getElement().source;
        if (source.logger.isErrorEnabled()) {
            source.logger.error(this.getElement().source.getRowColumnVector(this.getElement().begin).appendTo(new StringBuilder(200)).append(": compulsory \"name\" attribute of ").append((Object)this.formControlType).append(" control is empty").toString());
        }
    }

    private static final void addValueTo(Collection<String> collection, String value) {
        collection.add(value != null ? value : "");
    }

    static final class ElementContainer {
        public final Element element;
        public Map<String, String> attributesMap = null;
        public String predefinedValue;

        public ElementContainer(Element element, boolean loadPredefinedValue) {
            this.element = element;
            this.predefinedValue = loadPredefinedValue ? element.getAttributes().getValue("value") : null;
        }

        public Map<String, String> getAttributesMap() {
            if (this.attributesMap == null) {
                this.attributesMap = this.element.getAttributes().getMap(true);
            }
            return this.attributesMap;
        }

        public boolean setSelected(String value, String selectedOrChecked, boolean allowMultipleValues) {
            if (value != null && this.predefinedValue.equals(value.toString())) {
                this.setBooleanAttribute(selectedOrChecked, true);
                return true;
            }
            if (!allowMultipleValues) {
                this.setBooleanAttribute(selectedOrChecked, false);
            }
            return false;
        }

        public String getAttributeValue(String attributeName) {
            if (this.attributesMap != null) {
                return this.attributesMap.get(attributeName);
            }
            return this.element.getAttributes().getValue(attributeName);
        }

        public void setAttributeValue(String attributeName, String value) {
            if (value == null) {
                this.setBooleanAttribute(attributeName, false);
                return;
            }
            if (this.attributesMap != null) {
                this.attributesMap.put(attributeName, value);
                return;
            }
            String existingValue = this.getAttributeValue(attributeName);
            if (existingValue != null && existingValue.equals(value)) {
                return;
            }
            this.getAttributesMap().put(attributeName, value);
        }

        public boolean getBooleanAttribute(String attributeName) {
            if (this.attributesMap != null) {
                return this.attributesMap.containsKey(attributeName);
            }
            return this.element.getAttributes().get(attributeName) != null;
        }

        public void setBooleanAttribute(String attributeName, boolean value) {
            boolean oldValue = this.getBooleanAttribute(attributeName);
            if (value == oldValue) {
                return;
            }
            if (value) {
                this.getAttributesMap().put(attributeName, attributeName);
            } else {
                this.getAttributesMap().remove(attributeName);
            }
        }

        public void replaceAttributesInOutputDocumentIfModified(OutputDocument outputDocument) {
            if (this.attributesMap != null) {
                outputDocument.replace(this.element.getAttributes(), this.attributesMap);
            }
        }
    }

    private static final class PositionComparator
    implements Comparator<FormControl> {
        private PositionComparator() {
        }

        @Override
        public int compare(FormControl formControl1, FormControl formControl2) {
            int formControl2Begin;
            int formControl1Begin = formControl1.getElement().getBegin();
            if (formControl1Begin < (formControl2Begin = formControl2.getElement().getBegin())) {
                return -1;
            }
            if (formControl1Begin > formControl2Begin) {
                return 1;
            }
            return 0;
        }
    }

    static final class SelectFormControl
    extends FormControl {
        public ElementContainer[] optionElementContainers;

        public SelectFormControl(Element element) {
            super(element, element.getAttributes().get("multiple") != null ? FormControlType.SELECT_MULTIPLE : FormControlType.SELECT_SINGLE, false);
            List<Element> optionElements = element.getAllElements("option");
            this.optionElementContainers = new ElementContainer[optionElements.size()];
            int x = 0;
            for (Element optionElement : optionElements) {
                ElementContainer optionElementContainer = new ElementContainer(optionElement, true);
                if (optionElementContainer.predefinedValue == null) {
                    optionElementContainer.predefinedValue = CharacterReference.decodeCollapseWhiteSpace(optionElementContainer.element.getContent());
                }
                this.optionElementContainers[x++] = optionElementContainer;
            }
        }

        @Override
        public String getPredefinedValue() {
            throw new UnsupportedOperationException("Use getPredefinedValues() method instead on SELECT controls");
        }

        @Override
        public Collection<String> getPredefinedValues() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.optionElementContainers.length * 2, 1.0f);
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                linkedHashSet.add(this.optionElementContainers[i].predefinedValue);
            }
            return linkedHashSet;
        }

        @Override
        public Iterator<Element> getOptionElementIterator() {
            return new OptionElementIterator();
        }

        @Override
        public boolean setValue(String value) {
            return this.addValue(value, false);
        }

        @Override
        public boolean addValue(String value) {
            return this.addValue(value, this.formControlType == FormControlType.SELECT_MULTIPLE);
        }

        private boolean addValue(String value, boolean allowMultipleValues) {
            boolean valueFound = false;
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].setSelected(value, "selected", allowMultipleValues)) continue;
                valueFound = true;
            }
            return valueFound;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                FormControl.addValueTo(collection, this.optionElementContainers[i].predefinedValue);
            }
        }

        @Override
        void addToFormFields(FormFields formFields) {
            for (int i = 0; i < this.optionElementContainers.length; ++i) {
                formFields.add(this, this.optionElementContainers[i].predefinedValue);
            }
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                StringBuilder sb = new StringBuilder(100);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    if (!this.optionElementContainers[i].getBooleanAttribute("selected")) continue;
                    sb.append(SelectFormControl.getOptionLabel(this.optionElementContainers[i].element));
                    sb.append(FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator);
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - FormControlOutputStyle.ConfigDisplayValue.MultipleValueSeparator.length());
                }
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(sb, false));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                for (int i = 0; i < this.optionElementContainers.length; ++i) {
                    this.optionElementContainers[i].replaceAttributesInOutputDocumentIfModified(outputDocument);
                }
            }
        }

        private static String getOptionLabel(Element optionElement) {
            String labelAttributeValue = optionElement.getAttributeValue("label");
            if (labelAttributeValue != null) {
                return labelAttributeValue;
            }
            return CharacterReference.decodeCollapseWhiteSpace(optionElement.getContent());
        }

        private final class OptionElementIterator
        implements Iterator<Element> {
            private int i = 0;

            private OptionElementIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.i < SelectFormControl.this.optionElementContainers.length;
            }

            @Override
            public Element next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SelectFormControl.this.optionElementContainers[this.i++].element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class ImageSubmitFormControl
    extends SubmitFormControl {
        public ImageSubmitFormControl(Element element) {
            super(element, FormControlType.IMAGE);
        }

        @Override
        void addToFormFields(FormFields formFields) {
            super.addToFormFields(formFields);
            formFields.addName(this, this.name + ".x");
            formFields.addName(this, this.name + ".y");
        }
    }

    static class SubmitFormControl
    extends FormControl {
        public SubmitFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
        }

        @Override
        public boolean setValue(String value) {
            return false;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
        }

        @Override
        void addToFormFields(FormFields formFields) {
            if (this.getPredefinedValue() != null) {
                formFields.add(this);
            }
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class RadioCheckboxFormControl
    extends FormControl {
        public RadioCheckboxFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, true);
            if (this.elementContainer.predefinedValue == null) {
                this.elementContainer.predefinedValue = FormControl.CHECKBOX_NULL_DEFAULT_VALUE;
                if (element.source.logger.isErrorEnabled()) {
                    element.source.logger.error(element.source.getRowColumnVector(element.begin).appendTo(new StringBuilder(200)).append(": compulsory \"value\" attribute of ").append((Object)formControlType).append(" control \"").append(this.name).append("\" is missing, assuming the value \"").append(FormControl.CHECKBOX_NULL_DEFAULT_VALUE).append('\"').toString());
                }
            }
        }

        @Override
        public boolean setValue(String value) {
            return this.elementContainer.setSelected(value, "checked", false);
        }

        @Override
        public boolean addValue(String value) {
            return this.elementContainer.setSelected(value, "checked", this.formControlType == FormControlType.CHECKBOX);
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            if (this.isChecked()) {
                FormControl.addValueTo(collection, this.getPredefinedValue());
            }
        }

        @Override
        public boolean isChecked() {
            return this.elementContainer.getBooleanAttribute("checked");
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else {
                if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                    String html;
                    String string = html = this.isChecked() ? FormControlOutputStyle.ConfigDisplayValue.CheckedHTML : FormControlOutputStyle.ConfigDisplayValue.UncheckedHTML;
                    if (html != null) {
                        outputDocument.replace(this.getElement(), html);
                        return;
                    }
                    this.setDisabled(true);
                }
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }

    static final class TextAreaFormControl
    extends FormControl {
        public String value = UNCHANGED;
        private static final String UNCHANGED = new String();

        public TextAreaFormControl(Element element) {
            super(element, FormControlType.TEXTAREA, false);
        }

        @Override
        public boolean setValue(String value) {
            this.value = value;
            return true;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            FormControl.addValueTo(collection, this.getValue());
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                outputDocument.replace(this.getElement(), this.getDisplayValueHTML(this.getValue(), true));
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
                if (this.value != UNCHANGED) {
                    outputDocument.replace(this.getElement().getContent(), CharacterReference.encode(this.value, false));
                }
            }
        }

        private String getValue() {
            return this.value == UNCHANGED ? CharacterReference.decode(this.getElement().getContent()) : this.value;
        }
    }

    static final class InputFormControl
    extends FormControl {
        public InputFormControl(Element element, FormControlType formControlType) {
            super(element, formControlType, false);
        }

        @Override
        public boolean setValue(String value) {
            this.elementContainer.setAttributeValue("value", value);
            return true;
        }

        @Override
        void addValuesTo(Collection<String> collection) {
            FormControl.addValueTo(collection, this.elementContainer.getAttributeValue("value"));
        }

        @Override
        void addToFormFields(FormFields formFields) {
            formFields.add(this);
        }

        @Override
        void replaceInOutputDocument(OutputDocument outputDocument) {
            if (this.outputStyle == FormControlOutputStyle.REMOVE) {
                outputDocument.remove(this.getElement());
            } else if (this.outputStyle == FormControlOutputStyle.DISPLAY_VALUE) {
                String output = null;
                if (this.formControlType != FormControlType.HIDDEN) {
                    String value = this.elementContainer.getAttributeValue("value");
                    if (this.formControlType == FormControlType.PASSWORD && value != null) {
                        value = FormControl.getString(FormControlOutputStyle.ConfigDisplayValue.PasswordChar, value.length());
                    }
                    output = this.getDisplayValueHTML(value, false);
                }
                outputDocument.replace(this.getElement(), output);
            } else {
                this.replaceAttributesInOutputDocumentIfModified(outputDocument);
            }
        }
    }
}

