/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClipBox
extends JDialog
implements ActionListener {
    private static String BLANK = "        ";
    private static String ILLEGAL = "ILLEGAL!";
    private static String ZERO = "     ";
    Hackit hackit;
    JButton canF;
    JButton okF;
    JTextField clipStartT;
    JTextField clipEndT;
    JLabel titleL;
    JLabel errorL;
    private boolean statusOK;
    private int nStart;
    private int nEnd;
    private int total;
    private String name;

    ClipBox(Hackit hackit) {
        super(hackit, "Set Cell Clipping", true);
        this.hackit = hackit;
        this.getContentPane().setLayout(new GridLayout(4, 1));
        this.titleL = new JLabel("File pathname, total cells");
        this.getContentPane().add(this.titleL);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 5, 5));
        JLabel incBL = new JLabel("Cells to clip from beginning:");
        this.clipStartT = new JTextField(5);
        this.clipStartT.setText(ZERO);
        p1.add(incBL);
        p1.add(this.clipStartT);
        JLabel incEL = new JLabel("Cells to clip from end:");
        this.clipEndT = new JTextField(5);
        this.clipEndT.setText(ZERO);
        p1.add(incEL);
        p1.add(this.clipEndT);
        this.getContentPane().add(p1);
        this.errorL = new JLabel(BLANK);
        this.getContentPane().add(this.errorL);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        this.okF = new JButton("OK");
        this.okF.addActionListener(this);
        this.canF = new JButton("Cancel");
        this.canF.addActionListener(this);
        p2.add(this.okF);
        p2.add(this.canF);
        this.getContentPane().add(p2);
        this.getRootPane().setDefaultButton(this.okF);
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        Object target = evt.getSource();
        boolean done = false;
        if (target == this.okF || target == this.canF) {
            if (target == this.okF) {
                try {
                    this.nStart = Integer.valueOf(this.clipStartT.getText().trim());
                }
                catch (Exception e) {
                    this.nStart = 0;
                }
                try {
                    this.nEnd = Integer.valueOf(this.clipEndT.getText().trim());
                }
                catch (Exception e) {
                    this.nEnd = 0;
                }
                if (this.nStart + this.nEnd >= this.total || this.nStart < 0 || this.nEnd < 0) {
                    this.set(this.name, this.total);
                    this.errorL.setText(ILLEGAL);
                } else {
                    done = true;
                }
                this.statusOK = true;
            } else {
                this.statusOK = false;
                done = true;
            }
            if (done) {
                this.errorL.setText(BLANK);
                this.setVisible(false);
            }
        }
    }

    public void set(String name, int total) {
        this.total = total;
        this.name = name;
        this.titleL.setText(name + " Total cells: " + total);
        this.clipStartT.setText(ZERO);
        this.clipEndT.setText(ZERO);
        this.pack();
    }

    public void setVisible(boolean tf) {
        if (tf) {
            this.setLocation(this.hackit.getLocation());
        }
        super.setVisible(tf);
    }

    public int getClip() {
        return this.nStart;
    }

    public int getRetain() {
        return this.total - this.nStart - this.nEnd;
    }

    public boolean getStatus() {
        return this.statusOK;
    }
}

