<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


  <xsl:output method="xml" media-type="text/xml" standalone="yes" indent="yes" encoding="utf-8" version="1.0"/>



  <!-- Documents template, all or one  -->

  <xsl:template match="GBSet">
  
    <xsl:element name="giv">
      <xsl:attribute name="name">
      <xsl:text>Genbank Features, </xsl:text>
      <xsl:value-of select='./GBSeq/GBSeq_locus[1]'/> 
      </xsl:attribute>


      <xsl:element name="view">
        <xsl:attribute name="name">Single Panel</xsl:attribute>
        <xsl:attribute name="from">1</xsl:attribute>
        <xsl:attribute name="to"><xsl:value-of select='./GBSeq/GBSeq_length'/></xsl:attribute> 
        <xsl:attribute name="edge">0.01</xsl:attribute>
		
 
        <xsl:element name="map-panel">
          <xsl:attribute name="label">Genbank Features - Nucleotide</xsl:attribute>
          <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
          <xsl:attribute name="buoyancy">Floating</xsl:attribute>
          <xsl:attribute name="h-gap">3</xsl:attribute>
          <xsl:attribute name="v-gap">3</xsl:attribute>
 
 
          <xsl:element name="style-for">
            <xsl:attribute name="color">Magenta</xsl:attribute>
            <xsl:attribute name="bar-height">7</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:text>gene</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Orange</xsl:attribute>
            <xsl:attribute name="bar-height">7</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:text>CDS</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Red</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>intron</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Copper</xsl:attribute>
            <xsl:attribute name="bar-height">5</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>LTR</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Forest Green</xsl:attribute>
            <xsl:attribute name="bar-height">3</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>repeat_region</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue Gray</xsl:attribute>
            <xsl:attribute name="bar-height">3</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>misc_feature</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Plum</xsl:attribute>
            <xsl:attribute name="bar-height">5</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>mRNA</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Goldenrod</xsl:attribute>
            <xsl:attribute name="bar-height">5</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>tRNA</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Green</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
          <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>exon</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Raw Umber</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:text>promoter</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Raw Sienna</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:attribute name="lbl-display">Bigger</xsl:attribute>
            <xsl:text>sig_peptide</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Gold</xsl:attribute>
            <xsl:text>mat_peptide</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>polyA_signal</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>polyA_site</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>variation</xsl:text>
          </xsl:element>

          <xsl:element name="group">
            <xsl:attribute name="name">intron/exons</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='intron']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='exon']/GBFeature_intervals/GBInterval"/>
          </xsl:element>


	      <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='repeat_region']/GBFeature_intervals/GBInterval"/>
	      <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='mRNA']/GBFeature_intervals/GBInterval"/>
	      <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='LTR']/GBFeature_intervals/GBInterval"/>
	      <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='promoter']/GBFeature_intervals/GBInterval"/>
          <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='gene']/GBFeature_intervals/GBInterval"/>
          <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='tRNA']/GBFeature_intervals/GBInterval"/>


          <xsl:element name="group">
            <xsl:attribute name="name">Coding</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='CDS']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='sig_peptide']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='mat_peptide']/GBFeature_intervals/GBInterval"/>
          </xsl:element>


          <xsl:element name="group">
            <xsl:attribute name="name">poly-A</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='polyA_signal']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='polyA_site']/GBFeature_intervals/GBInterval"/>
          </xsl:element>

          <xsl:element name="group">
            <xsl:attribute name="name">Variation</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='variation']/GBFeature_intervals/GBInterval"/>
          </xsl:element>

          <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='misc_feature']/GBFeature_intervals/GBInterval"/>


        </xsl:element>
        
      </xsl:element>
    </xsl:element>

  </xsl:template>


  <!-- ====================================================================================  -->
 
 
  <xsl:template match="GBInterval">
    <xsl:element name="element">
      <xsl:attribute name="name">
        <xsl:value-of select="../../GBFeature_key"/>
      </xsl:attribute>
      <xsl:attribute name="type">
        <xsl:value-of select="../../GBFeature_key"/>
      </xsl:attribute>
      <xsl:apply-templates select="./GBInterval_from"/>
      <xsl:apply-templates select="./GBInterval_to"/>
      <xsl:apply-templates select="./GBInterval_point"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="GBInterval_from">
      <xsl:attribute name="from"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>

  <xsl:template match="GBInterval_to">
      <xsl:attribute name="to"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>

  <xsl:template match="GBInterval_point">
      <xsl:attribute name="from"><xsl:value-of select="."/></xsl:attribute>
      <xsl:attribute name="to"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>


  
</xsl:stylesheet>


