/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.orf;

import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapGlyphListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

public class ORFGlyphListener
implements MapGlyphListener {
    JLabel reporterLabel;
    PropertyChangeListener listener;

    public ORFGlyphListener(PropertyChangeListener propertyChangeListener, JLabel jLabel) {
        this.reporterLabel = jLabel;
        this.listener = propertyChangeListener;
    }

    public void glyphSelected(MapGlyph mapGlyph) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mapGlyph != null) {
            boolean bl = mapGlyph.getLabel().equals("ORF");
            int[] nArray = (int[])mapGlyph.getClientProperty("region");
            stringBuffer.append(mapGlyph.getLabel()).append(", ");
            stringBuffer.append(nArray[1]);
            stringBuffer.append(nArray[0] > 0 ? "->" : "<-");
            stringBuffer.append(nArray[2]);
            int n = nArray[2] - nArray[1] + 1;
            if (bl) {
                stringBuffer.append(" (" + n + " bp");
                stringBuffer.append(", ").append(n / 3 + " aa)");
            }
            int[] nArray2 = new int[]{nArray[1] - 1, nArray[2]};
            this.listener.propertyChange(new PropertyChangeEvent(this, "orfSelectionChanged", null, nArray2));
        }
        if (this.reporterLabel != null) {
            this.reporterLabel.setText(stringBuffer.toString());
        }
    }

    public void glyphLaunched(MapGlyph mapGlyph) {
        int[] nArray;
        boolean bl;
        if (mapGlyph != null && (bl = mapGlyph.getLabel().equals("ORF")) && (nArray = (int[])mapGlyph.getClientProperty("region"))[0] > 0) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "orfDoubleClicked", null, null));
        }
    }
}

