/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.format;

import com.informagen.F;
import com.informagen.sa.format.SequenceFormatter;

public class GenBank
extends SequenceFormatter {
    public GenBank() {
        this.mLineSize = 60;
        this.mBlockSize = 10;
    }

    public StringBuffer allocate() {
        int n = this.mSequence.length();
        return new StringBuffer(n + 10 * (n / 50) + n / 10 + 120);
    }

    protected void formatHeader() {
        this.mFormatted.append("LOCUS       ");
        this.mFormatted.append(this.mCodeword != null ? this.mCodeword : "UNTITLED");
        this.mFormatted.append("         ");
        this.mFormatted.append(this.mSequence.length());
        this.mFormatted.append(this.mIsProtein ? " aa" : " bp");
        this.mFormatted.append("        XXX   UPDATED  ").append(this.formatTime("dd-MMM-yyyy HH:mm") + '\n');
        if (this.mTitle != null) {
            this.mFormatted.append("DEFINITION  " + this.mTitle + '\n');
        }
        this.mFormatted.append("ORIGIN\n");
    }

    protected void formatSequence() {
        this.mFormatted.append("        1 ");
        char[] cArray = this.mSequence.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            this.mFormatted.append(cArray[i]);
            ++n;
            if (++n2 == this.mBlockSize) {
                this.mFormatted.append(' ');
                n2 = 0;
            }
            if (n != this.mLineSize) continue;
            this.mFormatted.append("\n");
            this.mFormatted.append(F.f(i + 2, 9)).append(' ');
            n = 0;
            n2 = 0;
        }
    }

    protected void formatEnding() {
        this.mFormatted.append("\n//\n");
    }
}

