/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestAnalysisPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class DigestReportPanel
extends JPanel
implements DigestAnalysisPanel {
    protected final JTextArea textArea = new JTextArea();
    protected final String title;

    public DigestReportPanel(String string) {
        this.title = string;
        this.buildUI();
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.textArea.setFont(new Font("Courier", 0, Util.isWindows() ? 10 : 12));
        this.textArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 30);
        this.add((Component)jScrollPane, "Center");
    }

    protected void writeHeader(Digest digest) {
        StringBuffer stringBuffer = new StringBuffer();
        Sequence sequence = digest.getSequence();
        stringBuffer.append(sequence.getUID()).append("\n");
        stringBuffer.append(sequence.getTitle()).append("\n\n");
        this.textArea.setText(stringBuffer.toString());
    }

    public void selectionChanged(int[] nArray) {
    }

    public void printPanel() {
        String string = this.textArea.getText();
        PanelPrinter panelPrinter = new PanelPrinter(string);
        panelPrinter.setPointSize(9);
        panelPrinter.print();
    }

    public void savePanel() {
        String string = this.textArea.getText();
        String string2 = "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, string, this.title + ".txt");
    }
}

