/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.FormPanel;
import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPageFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PFPageSetupDialog
extends JDialog
implements ActionListener {
    private PFPageFormat pageFormat = new PFPageFormat();
    private FormPanel fieldPanel = new FormPanel(5, 5, 5, 5);
    private JPanel buttonPanel = new JPanel();
    private BorderLayout dialogLayout = new BorderLayout();
    private FlowLayout buttonLayout = new FlowLayout();
    private JLabel labelPaperSize = new JLabel("Paper size:");
    private JLabel labelPaperSource = new JLabel("Paper source:");
    private JLabel labelLeftMargin = new JLabel("Left margin:");
    private JLabel labelRightMargin = new JLabel("Right margin:");
    private JLabel labelTopMargin = new JLabel("Top margin:");
    private JLabel labelBottomMargin = new JLabel("Bottom margin:");
    private JLabel labelPageOrientation = new JLabel("Page orientation");
    private JComboBox comboPaperSize;
    private JComboBox comboPaperSource = new JComboBox();
    private JTextField textLeftMargin = new JTextField(10);
    private JTextField textRightMargin = new JTextField(10);
    private JTextField textTopMargin = new JTextField(10);
    private JTextField textBottomMargin = new JTextField(10);
    private JComboBox comboPageOrientation;
    private JButton buttonAccept = new JButton("Accept");
    private JButton buttonCancel = new JButton("Cancel");

    public PFPageSetupDialog(PFPageFormat pFPageFormat) {
        super(new JFrame(), "Page dialog", true);
        if (pFPageFormat != null) {
            this.pageFormat = pFPageFormat;
        }
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(this.dialogLayout);
        this.getContentPane().add((Component)this.fieldPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setSize(new Dimension(500, 300));
        this.setFields();
        this.fieldPanel.add((Component)this.labelPaperSize, this.comboPaperSize, 0, 0);
        this.fieldPanel.add((Component)this.labelPaperSource, this.comboPaperSource, 0, 1);
        this.fieldPanel.add((Component)this.labelLeftMargin, this.textLeftMargin, 2, 0);
        this.fieldPanel.add((Component)this.labelRightMargin, this.textRightMargin, 2, 1);
        this.fieldPanel.add((Component)this.labelTopMargin, this.textTopMargin, 3, 0);
        this.fieldPanel.add((Component)this.labelBottomMargin, this.textBottomMargin, 3, 1);
        this.comboPaperSource.setEnabled(false);
        this.buttonPanel.add(this.buttonAccept);
        this.buttonPanel.add(this.buttonCancel);
        this.buttonAccept.setActionCommand("Accept");
        this.buttonCancel.setActionCommand("Cancel");
        this.buttonAccept.addActionListener(this);
        this.buttonCancel.addActionListener(this);
    }

    private void setFields() {
        this.comboPaperSize = new JComboBox<String>(this.pageFormat.getPageSizeDefinition());
        this.comboPaperSize.setSelectedIndex(this.pageFormat.getPageSizeIndex());
        this.textLeftMargin.setText(this.pageFormat.getLeftMargin().toString());
        this.textRightMargin.setText(this.pageFormat.getRightMargin().toString());
        this.textTopMargin.setText(this.pageFormat.getTopMargin().toString());
        this.textBottomMargin.setText(this.pageFormat.getBottomMargin().toString());
        this.comboPageOrientation = new JComboBox<String>(this.pageFormat.getPageOrientationDefinition());
        this.comboPageOrientation.setSelectedIndex(this.pageFormat.getPageOrientation());
    }

    public void getFields() {
        this.pageFormat.setPageSize(this.comboPaperSize.getSelectedIndex());
        this.pageFormat.setLeftMargin(new PFInchUnit(new Double(this.textLeftMargin.getText())));
        this.pageFormat.setRightMargin(new PFInchUnit(new Double(this.textRightMargin.getText())));
        this.pageFormat.setTopMargin(new PFInchUnit(new Double(this.textTopMargin.getText())));
        this.pageFormat.setBottomMargin(new PFInchUnit(new Double(this.textBottomMargin.getText())));
        this.pageFormat.setPageOrientation(this.comboPageOrientation.getSelectedIndex());
    }

    public PFPageFormat showDialog() {
        this.pack();
        this.show();
        return this.pageFormat;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Accept")) {
            this.getFields();
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

