/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.exceptions.AddressAccessException;
import edsim51sh.exceptions.OperandExpectedException;
import edsim51sh.instructions.CodeByte;

public abstract class Instruction
extends CodeByte {
    private String operand0String;
    private String operand1String;
    public String preAssembledLine;
    public boolean isByteInstruction = true;
    public String mneumonic = "ABSTRACT";
    public int size = 1;
    public int cycles = 1;
    public int operand0 = 0;
    public int operand1 = 0;

    public abstract int execute(Memory var1, int var2) throws Exception;

    public abstract Instruction getInstruction(String var1);

    public abstract int getOpcode();

    public int incrementPc(int pc) throws AddressAccessException {
        if ((pc += this.size) > 65535) {
            pc -= 65536;
        }
        return pc;
    }

    public void setOperand0String(String s) throws Exception {
        if (this.size > 1 && (s == null || s.equals(""))) {
            throw new OperandExpectedException(this.preAssembledLine);
        }
        this.operand0String = s.trim();
    }

    public String getOperand0String() {
        return this.operand0String;
    }

    public void setOperand1String(String s) throws Exception {
        if (s == null || s.equals("") && this.size > 2) {
            throw new OperandExpectedException(this.preAssembledLine);
        }
        this.operand1String = s.trim();
    }

    public String getOperand1String() {
        return this.operand1String;
    }

    public void extractOperand0String(String line) throws Exception {
        this.setOperand0String(line.replaceFirst(this.mneumonic.trim(), ""));
    }

    public void extractOperand1String(String line) throws Exception {
        this.setOperand1String("");
    }

    public String toString() {
        return this.mneumonic + Text.inHex(this.operand0, false) + "H";
    }

    @Override
    public int getValue() {
        return this.getOpcode();
    }
}

