/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.PairwiseDomainSimilarity;

public class CountsBasedPairwiseDomainSimilarity
implements PairwiseDomainSimilarity {
    private final short _copy_number_difference;
    private final short _counts_sum;

    public CountsBasedPairwiseDomainSimilarity(short s, short s2) {
        if (s2 <= 0) {
            throw new IllegalArgumentException("attempt to use copy sum of less than or equal to 0: " + s2);
        }
        if (Math.abs(s) > s2) {
            throw new IllegalArgumentException("attempt to use absolute copy number difference larger than copy number sum");
        }
        this._copy_number_difference = s;
        this._counts_sum = s2;
    }

    @Override
    public int getDifferenceInCounts() {
        return this._copy_number_difference;
    }

    @Override
    public double getSimilarityScore() {
        return 1.0 - (double)Math.abs(this._copy_number_difference) / (double)this._counts_sum;
    }
}

