/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.webservices;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.webservices.BasicPhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;

public final class WebserviceUtil {
    public static final String PFAM_INST = "pfam";
    public static final String PFAM_NAME = "Pfam";
    public static final String PFAM_SERVER = "http://pfam.xfam.org";
    public static final String TOL_NAME = "Tree of Life (ToL)";
    public static final String TOL_URL_BASE = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=";
    public static final String TOL_WEBSERVER = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=__query__";
    public static final String TREE_BASE_DESC = "This data set was downloaded from TreeBASE, a relational database of phylogenetic knowledge. TreeBASE has been supported by the NSF, Harvard University, Yale University, SDSC and UC Davis. Please do not remove this acknowledgment.";
    public static final String TREE_BASE_INST = "treebase";
    public static final String TREE_BASE_NAME = "TreeBASE";
    public static final String TREE_FAM_INST = "tree_fam";
    public static final String TREE_FAM_NAME = "TreeFam";
    public static final String TREE_FAM_URL_BASE = "http://www.treefam.org/family/TF";
    public static final String TREEBASE_PHYLOWS_STUDY_URL_BASE = "https://treebase.org/treebase-web/phylows/study/TB2:S";
    public static final String TREEBASE_PHYLOWS_TREE_URL_BASE = "https://treebase.org/treebase-web/phylows/tree/TB2:Tr";

    public static List<PhylogeniesWebserviceClient> createDefaultClients() {
        ArrayList<PhylogeniesWebserviceClient> arrayList = new ArrayList<PhylogeniesWebserviceClient>();
        arrayList.add(new BasicPhylogeniesWebserviceClient(TREE_BASE_NAME, "Read Tree from TreeBASE...", "Use TreeBASE to obtain a evolutionary tree", "Please enter a TreeBASE tree (\"Tr\") identifier (without the \"Tr\")\n(Examples: 2406, 422, 2654, 825, 4931, 2518, 4934)", WebservicesManager.WsPhylogenyFormat.TREEBASE_TREE, null, "https://treebase.org/treebase-web/phylows/tree/TB2:Tr__query__?format=nexus", true, "https://treebase.org", TREE_BASE_INST));
        arrayList.add(new BasicPhylogeniesWebserviceClient(PFAM_NAME, "Read Domain Tree from Pfam...", "Use  Pfam to obtain gene trees for seed alignments", "Please enter a Pfam (PF) accession number\n(Examples: 01849 for NAC, 00452 for Bcl-2, 00046 for Homeobox)", WebservicesManager.WsPhylogenyFormat.PFAM, null, "http://pfam.xfam.org/family/PF__query__/tree/download", false, PFAM_SERVER, PFAM_INST));
        arrayList.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Gene Tree from TreeFam...", "Use TreeFam to obtain a gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/family/TF__query__/tree/newick", true, "http://www.treefam.org", TREE_FAM_INST));
        arrayList.add(new BasicPhylogeniesWebserviceClient(TOL_NAME, "Read Tree from Tree of Life (ToL)...", "Use ToL webservice to obtain a evolutionary tree", "Please enter a Tree of Life node identifier\n(Examples: 14923 for ray-finned fishes, 19386 for Cephalopoda, 2461 for Cnidaria)", WebservicesManager.WsPhylogenyFormat.TOL_XML_RESPONSE, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, TOL_WEBSERVER, true, "http://tolweb.org", null));
        return arrayList;
    }

    public static void processInstructions(PhylogeniesWebserviceClient phylogeniesWebserviceClient, Phylogeny phylogeny) throws PhyloXmlDataFormatException {
        if (phylogeniesWebserviceClient.getProcessingInstructions().equals(TREE_FAM_INST)) {
            WebserviceUtil.processTreeFamTrees(phylogeny);
        } else if (phylogeniesWebserviceClient.getProcessingInstructions().equals(PFAM_INST)) {
            WebserviceUtil.extractSpTremblAccFromNodeName(phylogeny, "sptrembl");
            PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "bootstrap");
        } else if (phylogeniesWebserviceClient.getProcessingInstructions().equals(TREE_BASE_INST)) {
            if (PhylogenyMethods.isInternalNamesLookLikeConfidences(phylogeny)) {
                PhylogenyMethods.transferInternalNodeNamesToConfidence(phylogeny, "");
            }
            WebserviceUtil.processTreeBaseTrees(phylogeny);
        }
    }

    static void extractSpTremblAccFromNodeName(Phylogeny phylogeny, String string) {
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogeny);
        while (preorderTreeIterator.hasNext()) {
            String string2;
            String string3;
            int n;
            PhylogenyNode phylogenyNode = preorderTreeIterator.next();
            if (ForesterUtil.isEmpty(phylogenyNode.getName()) || (n = (string3 = phylogenyNode.getName()).lastIndexOf("/")) <= 0 || ForesterUtil.isEmpty(string2 = string3.substring(0, n))) continue;
            Sequence sequence = new Sequence();
            Accession accession = new Accession(string2, string);
            sequence.setAccession(accession);
            phylogenyNode.getNodeData().setSequence(sequence);
        }
    }

    static void processTreeBaseTrees(Phylogeny phylogeny) {
        phylogeny.setDescription(TREE_BASE_DESC);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            Sequence sequence;
            Accession accession;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (ForesterUtil.isEmpty(phylogenyNode.getName()) || (accession = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getName())) == null) continue;
            if (!phylogenyNode.getNodeData().isHasSequence()) {
                phylogenyNode.getNodeData().addSequence(new Sequence());
            }
            if ((sequence = phylogenyNode.getNodeData().getSequence()).getAccession() != null) continue;
            sequence.setAccession(accession);
        }
    }

    static void processTreeFamTrees(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyData phylogenyData;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) {
                phylogenyNode.getNodeData().setEvent(null);
                if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && (phylogenyData = SequenceAccessionTools.parseAccessorFromString(phylogenyNode.getName())) != null) {
                    Sequence sequence;
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().addSequence(new Sequence());
                    }
                    if ((sequence = phylogenyNode.getNodeData().getSequence()).getAccession() == null) {
                        sequence.setAccession((Accession)phylogenyData);
                    }
                }
            } else {
                if (phylogenyNode.getBranchData() != null && phylogenyNode.getBranchData().isHasConfidences() && phylogenyNode.getBranchData().getConfidence(0) != null) {
                    phylogenyNode.getBranchData().getConfidence(0).setType("bootstrap");
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().addTaxonomy(new Taxonomy());
                    }
                    if (ForesterUtil.isEmpty(((Taxonomy)(phylogenyData = phylogenyNode.getNodeData().getTaxonomy())).getScientificName())) {
                        ((Taxonomy)phylogenyData).setScientificName(phylogenyNode.getName());
                        phylogenyNode.setName("");
                    }
                }
            }
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() == null) continue;
            phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), "ncbi"));
        }
    }
}

