/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.util.TypomaticJButton;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

final class ControlPanel
extends JPanel
implements ActionListener {
    static final Font jcb_bold_font = new Font(Configuration.getDefaultFontFamilyName(), 1, Configuration.getGuiFontSize());
    static final Font jcb_font = new Font(Configuration.getDefaultFontFamilyName(), 0, Configuration.getGuiFontSize());
    static final Font js_font = new Font(Configuration.getDefaultFontFamilyName(), 0, Configuration.getGuiFontSize());
    private static final String RETURN_TO_SUPER_TREE_TEXT = "R";
    private static final String SEARCH_TIP_TEXT = "Enter text to search for. Use ',' for logical OR and '+' for logical AND (not used in this manner for regular expression searches).";
    private static final long serialVersionUID = -8463483932821545633L;
    private NodeClickAction _action_when_node_clicked;
    private int _add_new_node_item;
    private Map<Integer, String> _all_click_to_names;
    private Map<String, Color> _annotation_colors;
    private int _blast_item;
    private JComboBox<String> _click_to_combobox;
    private JLabel _click_to_label;
    private List<String> _click_to_names;
    private int _collapse_cb_item;
    private int _uncollapse_all_cb_item;
    private int _order_subtree_cb_item;
    private JCheckBox _color_acc_species;
    private JCheckBox _color_acc_sequence;
    private JCheckBox _color_according_to_annotation;
    private boolean _color_branches;
    private JCheckBox _use_visual_styles_cb;
    private int _color_subtree_cb_item;
    private int _change_node_font_item;
    private final Configuration _configuration;
    private int _copy_subtree_item;
    private int _cut_subtree_item;
    private JButton _decr_domain_structure_evalue_thr;
    private int _delete_node_or_subtree_item;
    private JRadioButton _display_as_unaligned_phylogram_rb;
    private JRadioButton _display_as_aligned_phylogram_rb;
    private JRadioButton _display_as_cladogram_rb;
    private ButtonGroup _display_as_buttongroup;
    private JCheckBox _display_internal_data;
    private JCheckBox _display_external_data;
    private JLabel _domain_display_label;
    private JTextField _domain_structure_evalue_thr_tf;
    private JTextField _depth_collapse_depth_tf;
    private JTextField _rank_collapse_depth_tf;
    private List<Options.PHYLOGENY_DISPLAY_TYPE> _tree_display_types;
    private JCheckBox _dynamically_hide_data;
    private int _edit_node_data_item;
    private int _get_ext_desc_data;
    private JButton _incr_domain_structure_evalue_thr;
    private final MainPanel _mainpanel;
    private JCheckBox _node_desc_popup_cb;
    private int _open_pdb_item;
    private int _open_seq_web_item;
    private int _open_tax_web_item;
    private int _color_node_font_item;
    private JButton _order;
    private int _paste_subtree_item;
    private int _reroot_cb_item;
    private JButton _return_to_super_tree;
    private JLabel _search_found_label_0;
    private JLabel _search_found_label_1;
    private JButton _search_reset_button_0;
    private JButton _search_reset_button_1;
    private JTextField _search_tf_0;
    private JTextField _search_tf_1;
    private int _select_nodes_item;
    private Sequence _selected_query_seq;
    private JCheckBox _seq_relation_confidence_switch;
    private JComboBox<SequenceRelation.SEQUENCE_RELATION_TYPE> _sequence_relation_type_box;
    private JCheckBox _show_annotation;
    private JCheckBox _show_binary_character_counts;
    private JCheckBox _show_binary_characters;
    private int _show_data_item;
    private JCheckBox _show_domain_architectures;
    private JCheckBox _show_mol_seqs;
    private JCheckBox _write_branch_length_values;
    private JCheckBox _show_events;
    private JCheckBox _show_gene_names;
    private JCheckBox _show_node_names;
    private JCheckBox _show_properties_cb;
    private JCheckBox _show_seq_names;
    private JCheckBox _show_seq_symbols;
    private JCheckBox _show_sequence_acc;
    private JComboBox<String> _show_sequence_relations;
    private JCheckBox _show_taxo_code;
    private JCheckBox _show_taxo_rank;
    private JCheckBox _show_taxo_common_names;
    private JCheckBox _show_taxo_images_cb;
    private JCheckBox _show_taxo_scientific_names;
    private JCheckBox _show_vector_data_cb;
    private JButton _show_whole;
    private int _sort_descendents_item;
    private Map<String, Color> _species_colors;
    private Map<String, Color> _sequence_colors;
    private int _subtree_cb_item;
    private int _swap_cb_item;
    private JButton _uncollapse_all;
    private JCheckBox _width_branches;
    private JCheckBox _write_confidence;
    private JButton _zoom_in_domain_structure;
    private JButton _zoom_in_x;
    private JButton _zoom_in_y;
    private JLabel _zoom_label;
    private JButton _zoom_out_domain_structure;
    private JButton _zoom_out_x;
    private JButton _zoom_out_y;
    private JButton _decr_depth_collapse_level;
    private JButton _incr_depth_collapse_level;
    private JLabel _depth_collapse_label;
    private JButton _decr_rank_collapse_level;
    private JButton _incr_rank_collapse_level;
    private JLabel _rank_collapse_label;

    ControlPanel(MainPanel mainPanel, Configuration configuration) {
        this.init();
        this._mainpanel = mainPanel;
        this._configuration = configuration;
        if (!this._configuration.isUseNativeUI()) {
            this.setBackground(this.getConfiguration().getGuiBackgroundColor());
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this.setupControls();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            TreePanel treePanel;
            if (actionEvent.getSource() == this._color_acc_sequence) {
                if (this._color_acc_species != null) {
                    this._color_acc_species.setSelected(false);
                }
            } else if (actionEvent.getSource() == this._color_acc_species && this._color_acc_sequence != null) {
                this._color_acc_sequence.setSelected(false);
            }
            if ((treePanel = this.getMainPanel().getCurrentTreePanel()) == null) {
                return;
            }
            if (actionEvent.getSource() == this._click_to_combobox) {
                this.setClickToAction(this._click_to_combobox.getSelectedIndex());
                this.getCurrentTreePanel().repaint();
            } else if (actionEvent.getSource() == this._show_binary_characters) {
                if (this._show_binary_character_counts != null && this._show_binary_characters.isSelected()) {
                    this._show_binary_character_counts.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (actionEvent.getSource() == this._show_binary_character_counts) {
                if (this._show_binary_characters != null && this._show_binary_character_counts.isSelected()) {
                    this._show_binary_characters.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (actionEvent.getSource() == this._show_domain_architectures) {
                this.search0();
                this.search1();
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (treePanel != null && treePanel.getPhylogeny() != null) {
                if (actionEvent.getSource() == this.getDisplayAsUnalignedPhylogramRb()) {
                    this.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM);
                    this.showWhole();
                }
                if (actionEvent.getSource() == this.getDisplayAsAlignedPhylogramRb()) {
                    this.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM);
                    this.showWhole();
                }
                if (actionEvent.getSource() == this.getDisplayAsCladogramRb()) {
                    this.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
                    this.showWhole();
                } else if (actionEvent.getSource() == this._zoom_in_x) {
                    this.zoomInX(1.25f, 1.2f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_in_y) {
                    this.zoomInY(1.25f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_out_x) {
                    this.zoomOutX(0.8f, 0.8333333f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_out_y) {
                    this.zoomOutY(0.8f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._show_whole) {
                    this.displayedPhylogenyMightHaveChanged(true);
                    this.showWhole();
                } else if (actionEvent.getSource() == this._return_to_super_tree) {
                    this.returnedToSuperTreePressed();
                } else if (actionEvent.getSource() == this._order) {
                    this.orderPressed(treePanel);
                } else if (actionEvent.getSource() == this._uncollapse_all) {
                    this.uncollapseAll(treePanel);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (actionEvent.getSource() == this._zoom_in_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomInDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._zoom_out_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomOutDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._decr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().decreaseDomainStructureEvalueThresholdExp();
                    this.search0();
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._incr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().increaseDomainStructureEvalueThresholdExp();
                    this.search0();
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._search_tf_0) {
                    this.search0();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._search_tf_1) {
                    this.search1();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (this._dynamically_hide_data != null && actionEvent.getSource() == this._dynamically_hide_data && !this._dynamically_hide_data.isSelected()) {
                    this.setDynamicHidingIsOn(false);
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (actionEvent.getSource() == this._decr_depth_collapse_level || actionEvent.getSource() == this._incr_depth_collapse_level) {
                    if (actionEvent.getSource() == this._decr_depth_collapse_level) {
                        this._mainpanel.getCurrentTreePanel().decreaseDepthCollapseLevel();
                    } else {
                        this._mainpanel.getCurrentTreePanel().increaseDepthCollapseLevel();
                    }
                    this.search0();
                    this.search1();
                    this._mainpanel.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                    this._mainpanel.getCurrentTreePanel().getPhylogeny().recalculateNumberOfExternalDescendants(true);
                    this._mainpanel.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                    this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
                    this._mainpanel.getCurrentTreePanel().setNodeInPreorderToNull();
                    this.displayedPhylogenyMightHaveChanged(true);
                    this._mainpanel.getCurrentTreePanel().resetPreferredSize();
                    this._mainpanel.getCurrentTreePanel().updateOvSizes();
                    this._mainpanel.adjustJScrollPane();
                    this.showWhole();
                    this.repaint();
                } else if (actionEvent.getSource() == this._decr_rank_collapse_level || actionEvent.getSource() == this._incr_rank_collapse_level) {
                    if (actionEvent.getSource() == this._decr_rank_collapse_level) {
                        this._mainpanel.getCurrentTreePanel().decreaseRankCollapseLevel();
                    } else {
                        this._mainpanel.getCurrentTreePanel().increaseRankCollapseLevel();
                    }
                    this.search0();
                    this.search1();
                    this._mainpanel.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
                    this._mainpanel.getCurrentTreePanel().getPhylogeny().recalculateNumberOfExternalDescendants(true);
                    this._mainpanel.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                    this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
                    this._mainpanel.getCurrentTreePanel().setNodeInPreorderToNull();
                    this.displayedPhylogenyMightHaveChanged(true);
                    this._mainpanel.getCurrentTreePanel().resetPreferredSize();
                    this._mainpanel.getCurrentTreePanel().updateOvSizes();
                    this._mainpanel.adjustJScrollPane();
                    this.showWhole();
                    this.repaint();
                } else {
                    this.displayedPhylogenyMightHaveChanged(true);
                }
            }
            treePanel.requestFocus();
            treePanel.requestFocusInWindow();
            treePanel.requestFocus();
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        catch (Error error) {
            AptxUtil.unexpectedError(error);
        }
    }

    void orderPressed(TreePanel treePanel) {
        PhylogenyMethods.DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
        if (this.isShowTaxonomyScientificNames() || this.isShowTaxonomyCode()) {
            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
        } else if (this.isShowSeqNames() || this.isShowSeqSymbols() || this.isShowGeneNames()) {
            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
        }
        PhylogenyMethods.orderAppearanceX(treePanel.getPhylogeny().getRoot(), true, dESCENDANT_SORT_PRIORITY);
        treePanel.setNodeInPreorderToNull();
        treePanel.getPhylogeny().externalNodesHaveChanged();
        treePanel.getPhylogeny().clearHashIdToNodeMap();
        treePanel.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        treePanel.resetNodeIdToDistToLeafMap();
        treePanel.setEdited(true);
        this.displayedPhylogenyMightHaveChanged(true);
    }

    void returnedToSuperTreePressed() {
        if (this.getCurrentTreePanel().isCurrentTreeIsSubtree()) {
            this._mainpanel.getCurrentTreePanel().superTree();
            this.showWhole();
        }
    }

    public JCheckBox getColorAccSequenceCb() {
        return this._color_acc_sequence;
    }

    public JCheckBox getColorAccSpeciesCb() {
        return this._color_acc_species;
    }

    public JRadioButton getDisplayAsCladogramRb() {
        return this._display_as_cladogram_rb;
    }

    public JRadioButton getDisplayAsAlignedPhylogramRb() {
        return this._display_as_aligned_phylogram_rb;
    }

    public JRadioButton getDisplayAsUnalignedPhylogramRb() {
        return this._display_as_unaligned_phylogram_rb;
    }

    public JCheckBox getDynamicallyHideData() {
        return this._dynamically_hide_data;
    }

    public JCheckBox getNodeDescPopupCb() {
        return this._node_desc_popup_cb;
    }

    public Sequence getSelectedQuerySequence() {
        return this._selected_query_seq;
    }

    public JComboBox<String> getSequenceRelationBox() {
        if (this._show_sequence_relations == null) {
            this._show_sequence_relations = new JComboBox();
            this._show_sequence_relations.setFocusable(false);
            this._show_sequence_relations.setMaximumRowCount(20);
            this._show_sequence_relations.setFont(js_font);
            if (!this._configuration.isUseNativeUI()) {
                this._show_sequence_relations.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
                this._show_sequence_relations.setForeground(this.getConfiguration().getGuiButtonTextColor());
            }
            this._show_sequence_relations.addItem("-----");
            this._show_sequence_relations.setToolTipText("To display orthology information for selected query");
        }
        return this._show_sequence_relations;
    }

    public JComboBox<SequenceRelation.SEQUENCE_RELATION_TYPE> getSequenceRelationTypeBox() {
        if (this._sequence_relation_type_box == null) {
            this._sequence_relation_type_box = new JComboBox();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE : SequenceRelation.SEQUENCE_RELATION_TYPE.values()) {
                this._sequence_relation_type_box.addItem(sEQUENCE_RELATION_TYPE);
            }
            this._sequence_relation_type_box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ControlPanel.this._mainpanel.getCurrentPhylogeny() != null) {
                        ControlPanel.this.setSequenceRelationQueries(ControlPanel.this.getMainPanel().getCurrentPhylogeny().getSequenceRelationQueries());
                    }
                }
            });
        }
        return this._sequence_relation_type_box;
    }

    public JCheckBox getShowEventsCb() {
        return this._show_events;
    }

    public JCheckBox getUseVisualStylesCb() {
        return this._use_visual_styles_cb;
    }

    public JCheckBox getWriteConfidenceCb() {
        return this._write_confidence;
    }

    public boolean isShowMolSequences() {
        return this._show_mol_seqs != null && this._show_mol_seqs.isSelected();
    }

    public boolean isShowProperties() {
        return this._show_properties_cb != null && this._show_properties_cb.isSelected();
    }

    public boolean isShowTaxonomyImages() {
        return this._show_taxo_images_cb != null && this._show_taxo_images_cb.isSelected();
    }

    public boolean isShowVectorData() {
        return this._show_vector_data_cb != null && this._show_vector_data_cb.isSelected();
    }

    public void setSequenceRelationQueries(Collection<Sequence> collection) {
        JComboBox<String> jComboBox = this.getSequenceRelationBox();
        while (jComboBox.getItemCount() > 1) {
            jComboBox.removeItemAt(1);
        }
        final HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE = (SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)this._sequence_relation_type_box.getSelectedItem());
        if (sEQUENCE_RELATION_TYPE == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Sequence objectArray : collection) {
            if (!objectArray.isHasSequenceRelations()) continue;
            int n = 0;
            for (SequenceRelation sequenceRelation : objectArray.getSequenceRelations()) {
                if (!sequenceRelation.getType().equals((Object)sEQUENCE_RELATION_TYPE)) continue;
                n = 1;
                break;
            }
            if (n == 0) continue;
            arrayList.add(objectArray.getName());
            hashMap.put(objectArray.getName(), objectArray);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (String string : stringArray) {
            jComboBox.addItem(string);
        }
        for (ItemListener itemListener : jComboBox.getItemListeners()) {
            jComboBox.removeItemListener(itemListener);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ControlPanel.this._selected_query_seq = (Sequence)hashMap.get(itemEvent.getItem());
                ControlPanel.this._mainpanel.getCurrentTreePanel().repaint();
            }
        });
    }

    private void addClickToOption(int n, String string) {
        this._click_to_combobox.addItem(string);
        this._click_to_names.add(string);
        this._all_click_to_names.put(n, string);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._click_to_combobox.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
    }

    private void addSequenceRelationBlock() {
        JLabel jLabel = new JLabel("");
        jLabel.setSize(1, 1);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("Sequence relations to display");
        JLabel jLabel3 = ControlPanel.customizeLabel(new JLabel("(type) "), this.getConfiguration());
        jLabel3.setFont(js_font.deriveFont(7));
        this.getSequenceRelationTypeBox().setFocusable(false);
        this._sequence_relation_type_box.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._sequence_relation_type_box.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            this._sequence_relation_type_box.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        this._sequence_relation_type_box.setRenderer((ListCellRenderer<SequenceRelation.SEQUENCE_RELATION_TYPE>)new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = new DefaultListCellRenderer().getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object != null && object instanceof SequenceRelation.SEQUENCE_RELATION_TYPE) {
                    ((DefaultListCellRenderer)component).setText(SequenceRelation.getPrintableNameByType((SequenceRelation.SEQUENCE_RELATION_TYPE)((Object)object)));
                }
                return component;
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._sequence_relation_type_box.setMinimumSize(new Dimension(115, 17));
        this._sequence_relation_type_box.setPreferredSize(new Dimension(115, 20));
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBackground(this.getBackground());
        jPanel.add(jLabel3);
        jPanel.add(this._sequence_relation_type_box);
        this.add(ControlPanel.customizeLabel(jLabel2, this.getConfiguration()));
        this.add(jPanel);
        this.add(this.getSequenceRelationBox());
        if (this._configuration.doDisplayOption(22)) {
            this.addCheckbox(22, this._configuration.getDisplayTitle(22));
            this.setCheckbox(22, this._configuration.doCheckOption(22));
        }
    }

    private List<Options.PHYLOGENY_DISPLAY_TYPE> getTreeDisplayTypes() {
        return this._tree_display_types;
    }

    private final MainFrame getMainFrame() {
        return this.getMainPanel().getMainFrame();
    }

    private void init() {
        this._tree_display_types = new ArrayList<Options.PHYLOGENY_DISPLAY_TYPE>();
        this.setSpeciesColors(new HashMap<String, Color>());
        this.setSequenceColors(new HashMap<String, Color>());
        this.setAnnotationColors(new HashMap<String, Color>());
    }

    private Options.PHYLOGENY_DISPLAY_TYPE getTreeDisplayType(int n) {
        return this.getTreeDisplayTypes().get(n);
    }

    private void search0(MainPanel mainPanel, Phylogeny phylogeny, String string) {
        this.getSearchFoundCountsLabel0().setVisible(true);
        this.getSearchResetButton0().setEnabled(true);
        this.getSearchResetButton0().setVisible(true);
        String[] stringArray = null;
        HashSet<Long> hashSet = null;
        string = string.replaceAll("\\s+", " ");
        stringArray = string.indexOf(44) >= 0 && !this.getOptions().isSearchWithRegex() ? string.split(",+") : new String[]{string.trim()};
        if (stringArray != null && stringArray.length > 0) {
            hashSet = new HashSet<Long>();
            for (String string2 : stringArray) {
                if (ForesterUtil.isEmpty(string2)) continue;
                String string3 = string2.trim();
                TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
                if (string3.indexOf(43) > 0 && !this.getOptions().isSearchWithRegex()) {
                    hashSet.addAll(PhylogenyMethods.searchDataLogicalAnd(string3.split("\\++"), phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.isShowDomainArchitectures(), treePanel != null ? Math.pow(10.0, treePanel.getDomainStructureEvalueThresholdExp()) : 0.0));
                    continue;
                }
                hashSet.addAll(PhylogenyMethods.searchData(string3, phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.getOptions().isSearchWithRegex(), this.isShowDomainArchitectures(), treePanel != null ? Math.pow(10.0, treePanel.getDomainStructureEvalueThresholdExp()) : 0.0));
            }
            if (this.getOptions().isInverseSearchResult()) {
                List<PhylogenyNode> list = PhylogenyMethods.obtainAllNodesAsList(phylogeny);
                HashSet<Long> hashSet2 = hashSet;
                hashSet = new HashSet();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PhylogenyNode phylogenyNode = (PhylogenyNode)iterator.next();
                    if (hashSet2.contains(phylogenyNode.getId()) || !phylogenyNode.isHasNodeData()) continue;
                    hashSet.add(phylogenyNode.getId());
                }
            }
        }
        if (hashSet != null && hashSet.size() > 0) {
            mainPanel.getCurrentTreePanel().setFoundNodes0(new HashSet<Long>());
            for (Long l : hashSet) {
                mainPanel.getCurrentTreePanel().getFoundNodes0().add(l);
            }
            this.setSearchFoundCountsOnLabel0(hashSet.size());
        } else {
            this.setSearchFoundCountsOnLabel0(0);
            this.searchReset0();
        }
    }

    private void search1(MainPanel mainPanel, Phylogeny phylogeny, String string) {
        this.getSearchFoundCountsLabel1().setVisible(true);
        this.getSearchResetButton1().setEnabled(true);
        this.getSearchResetButton1().setVisible(true);
        String[] stringArray = null;
        HashSet<Long> hashSet = null;
        string = string.replaceAll("\\s+", " ");
        stringArray = string.indexOf(44) >= 0 && !this.getOptions().isSearchWithRegex() ? string.split(",+") : new String[]{string.trim()};
        if (stringArray != null && stringArray.length > 0) {
            hashSet = new HashSet<Long>();
            for (String string2 : stringArray) {
                if (ForesterUtil.isEmpty(string2)) continue;
                String string3 = string2.trim();
                TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
                if (string3.indexOf(43) > 0 && !this.getOptions().isSearchWithRegex()) {
                    hashSet.addAll(PhylogenyMethods.searchDataLogicalAnd(string3.split("\\++"), phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.isShowDomainArchitectures(), treePanel != null ? Math.pow(10.0, treePanel.getDomainStructureEvalueThresholdExp()) : 0.0));
                    continue;
                }
                hashSet.addAll(PhylogenyMethods.searchData(string3, phylogeny, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly(), this.getOptions().isSearchWithRegex(), this.isShowDomainArchitectures(), treePanel != null ? Math.pow(10.0, treePanel.getDomainStructureEvalueThresholdExp()) : 0.0));
            }
            if (this.getOptions().isInverseSearchResult()) {
                List<PhylogenyNode> list = PhylogenyMethods.obtainAllNodesAsList(phylogeny);
                HashSet<Long> hashSet2 = hashSet;
                hashSet = new HashSet();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PhylogenyNode phylogenyNode = (PhylogenyNode)iterator.next();
                    if (hashSet2.contains(phylogenyNode.getId()) || !phylogenyNode.isHasNodeData()) continue;
                    hashSet.add(phylogenyNode.getId());
                }
            }
        }
        if (hashSet != null && hashSet.size() > 0) {
            mainPanel.getCurrentTreePanel().setFoundNodes1(new HashSet<Long>());
            for (Long l : hashSet) {
                mainPanel.getCurrentTreePanel().getFoundNodes1().add(l);
            }
            this.setSearchFoundCountsOnLabel1(hashSet.size());
        } else {
            this.setSearchFoundCountsOnLabel1(0);
            this.searchReset1();
        }
    }

    private void setTreeDisplayType(int n, Options.PHYLOGENY_DISPLAY_TYPE pHYLOGENY_DISPLAY_TYPE) {
        this.getTreeDisplayTypes().set(n, pHYLOGENY_DISPLAY_TYPE);
    }

    private void setupClickToOptions() {
        int n = this._configuration.getDefaultDisplayClicktoOption();
        int n2 = 0;
        int n3 = 0;
        if (this._configuration.doDisplayClickToOption(0)) {
            this._show_data_item = n3;
            this.addClickToOption(0, this._configuration.getClickToTitle(0));
            if (n == 0) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(1)) {
            this._collapse_cb_item = n3;
            this.addClickToOption(1, this._configuration.getClickToTitle(1));
            if (n == 1) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(21)) {
            this._uncollapse_all_cb_item = n3;
            this.addClickToOption(21, this._configuration.getClickToTitle(21));
            if (n == 21) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(2)) {
            this._reroot_cb_item = n3;
            this.addClickToOption(2, this._configuration.getClickToTitle(2));
            if (n == 2) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(3)) {
            this._subtree_cb_item = n3;
            this.addClickToOption(3, this._configuration.getClickToTitle(3));
            if (n == 3) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(4)) {
            this._swap_cb_item = n3;
            this.addClickToOption(4, this._configuration.getClickToTitle(4));
            if (n == 4) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(22)) {
            this._order_subtree_cb_item = n3;
            this.addClickToOption(22, this._configuration.getClickToTitle(22));
            if (n == 22) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(18)) {
            this._sort_descendents_item = n3;
            this.addClickToOption(18, this._configuration.getClickToTitle(18));
            if (n == 18) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(5)) {
            this._color_node_font_item = n3;
            this.addClickToOption(5, this._configuration.getClickToTitle(5));
            if (n == 5) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(6)) {
            this._change_node_font_item = n3;
            this.addClickToOption(6, this._configuration.getClickToTitle(6));
            if (n == 6) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(7)) {
            this._color_subtree_cb_item = n3;
            this.addClickToOption(7, this._configuration.getClickToTitle(7));
            if (n == 7) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(8)) {
            this._open_seq_web_item = n3;
            this.addClickToOption(8, this._configuration.getClickToTitle(8));
            if (n == 8) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(9)) {
            this._open_pdb_item = n3;
            this.addClickToOption(9, this._configuration.getClickToTitle(9));
            if (n == 9) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(10)) {
            this._open_tax_web_item = n3;
            this.addClickToOption(10, this._configuration.getClickToTitle(10));
            if (n == 10) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(11)) {
            this._blast_item = n3;
            this.addClickToOption(11, this._configuration.getClickToTitle(11));
            if (n == 11) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(20)) {
            this._select_nodes_item = n3;
            this.addClickToOption(20, this._configuration.getClickToTitle(20));
            if (n == 20) {
                n2 = n3;
            }
            ++n3;
        }
        if (this._configuration.doDisplayClickToOption(19)) {
            this._get_ext_desc_data = n3;
            if (!ForesterUtil.isEmpty(this.getConfiguration().getLabelForGetExtDescendentsData())) {
                this.addClickToOption(19, this.getConfiguration().getLabelForGetExtDescendentsData());
            } else {
                this.addClickToOption(19, this.getConfiguration().getClickToTitle(19));
            }
            if (n == 19) {
                n2 = n3;
            }
            ++n3;
        }
        if (this.getOptions().isEditable()) {
            if (this._configuration.doDisplayClickToOption(12)) {
                this._cut_subtree_item = n3;
                this.addClickToOption(12, this._configuration.getClickToTitle(12));
                if (n == 12) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(13)) {
                this._copy_subtree_item = n3;
                this.addClickToOption(13, this._configuration.getClickToTitle(13));
                if (n == 13) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(14)) {
                this._paste_subtree_item = n3;
                this.addClickToOption(14, this._configuration.getClickToTitle(14));
                if (n == 14) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(15)) {
                this._delete_node_or_subtree_item = n3;
                this.addClickToOption(15, this._configuration.getClickToTitle(15));
                if (n == 15) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(16)) {
                this._add_new_node_item = n3;
                this.addClickToOption(16, this._configuration.getClickToTitle(16));
                if (n == 16) {
                    n2 = n3;
                }
                ++n3;
            }
            if (this._configuration.doDisplayClickToOption(17)) {
                this._edit_node_data_item = n3;
                this.addClickToOption(17, this._configuration.getClickToTitle(17));
                if (n == 17) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        this._click_to_combobox.setSelectedIndex(n2);
        this.setClickToAction(n2);
    }

    private void setupDisplayCheckboxes() {
        if (this._configuration.doDisplayOption(16)) {
            this.addCheckbox(16, this._configuration.getDisplayTitle(16));
            this.setCheckbox(16, this._configuration.doCheckOption(16));
        }
        if (this._configuration.doDisplayOption(21)) {
            this.addCheckbox(21, this._configuration.getDisplayTitle(21));
            this.setCheckbox(21, this._configuration.doCheckOption(21));
        }
        if (this._configuration.doDisplayOption(15)) {
            this.addCheckbox(15, this._configuration.getDisplayTitle(15));
            this.setCheckbox(15, this._configuration.doCheckOption(15));
        }
        if (this._configuration.doDisplayOption(30)) {
            this.addCheckbox(30, this._configuration.getDisplayTitle(30));
            this.setCheckbox(30, this._configuration.doCheckOption(30));
        }
        if (this._configuration.doDisplayOption(7)) {
            this.addCheckbox(7, this._configuration.getDisplayTitle(7));
            this.setCheckbox(7, this._configuration.doCheckOption(7));
        }
        if (this._configuration.doDisplayOption(6)) {
            this.addCheckbox(6, this._configuration.getDisplayTitle(6));
            this.setCheckbox(6, this._configuration.doCheckOption(6));
        }
        if (this._configuration.doDisplayOption(19)) {
            this.addCheckbox(19, this._configuration.getDisplayTitle(19));
            this.setCheckbox(19, this._configuration.doCheckOption(19));
        }
        if (this._configuration.doDisplayOption(8)) {
            this.addCheckbox(8, this._configuration.getDisplayTitle(8));
            this.setCheckbox(8, this._configuration.doCheckOption(8));
        }
        if (this._configuration.doDisplayOption(9)) {
            this.addCheckbox(9, this._configuration.getDisplayTitle(9));
            this.setCheckbox(9, this._configuration.doCheckOption(9));
        }
        JLabel jLabel = new JLabel("Display Data:");
        jLabel.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jLabel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(jLabel);
        if (this._configuration.doDisplayOption(1)) {
            this.addCheckbox(1, this._configuration.getDisplayTitle(1));
            this.setCheckbox(1, this._configuration.doCheckOption(1));
        }
        if (this._configuration.doDisplayOption(2)) {
            this.addCheckbox(2, this._configuration.getDisplayTitle(2));
            this.setCheckbox(2, this._configuration.doCheckOption(2));
        }
        if (this._configuration.doDisplayOption(17)) {
            this.addCheckbox(17, this._configuration.getDisplayTitle(17));
            this.setCheckbox(17, this._configuration.doCheckOption(17));
        }
        if (this._configuration.doDisplayOption(18)) {
            this.addCheckbox(18, this._configuration.getDisplayTitle(18));
            this.setCheckbox(18, this._configuration.doCheckOption(18));
        }
        if (this._configuration.doDisplayOption(29)) {
            this.addCheckbox(29, this._configuration.getDisplayTitle(29));
            this.setCheckbox(29, this._configuration.doCheckOption(29));
        }
        if (this._configuration.doDisplayOption(13)) {
            this.addCheckbox(13, this._configuration.getDisplayTitle(13));
            this.setCheckbox(13, this._configuration.doCheckOption(13));
        }
        if (this._configuration.doDisplayOption(26)) {
            this.addCheckbox(26, this._configuration.getDisplayTitle(26));
            this.setCheckbox(26, this._configuration.doCheckOption(26));
        }
        if (this._configuration.doDisplayOption(20)) {
            this.addCheckbox(20, this._configuration.getDisplayTitle(20));
            this.setCheckbox(20, this._configuration.doCheckOption(20));
        }
        if (this._configuration.doDisplayOption(14)) {
            this.addCheckbox(14, this._configuration.getDisplayTitle(14));
            this.setCheckbox(14, this._configuration.doCheckOption(14));
        }
        if (this._configuration.doDisplayOption(3)) {
            this.addCheckbox(3, this._configuration.getDisplayTitle(3));
            this.setCheckbox(3, this._configuration.doCheckOption(3));
        }
        if (this._configuration.doDisplayOption(4)) {
            this.addCheckbox(4, this._configuration.getDisplayTitle(4));
            this.setCheckbox(4, this._configuration.doCheckOption(4));
        }
        if (this._configuration.doDisplayOption(28)) {
            this.addCheckbox(28, this._configuration.getDisplayTitle(28));
            this.setCheckbox(28, this._configuration.doCheckOption(28));
        }
        if (this._configuration.doDisplayOption(11)) {
            this.addCheckbox(11, this._configuration.getDisplayTitle(11));
            this.setCheckbox(11, this._configuration.doCheckOption(11));
        }
        if (this._configuration.doDisplayOption(12)) {
            this.addCheckbox(12, this._configuration.getDisplayTitle(12));
            this.setCheckbox(12, this._configuration.doCheckOption(12));
        }
        if (this._configuration.doDisplayOption(10)) {
            this.addCheckbox(10, this._configuration.getDisplayTitle(10));
            this.setCheckbox(10, this._configuration.doCheckOption(10));
        }
        if (this._configuration.doDisplayOption(27)) {
            this.addCheckbox(27, this._configuration.getDisplayTitle(27));
            this.setCheckbox(27, this._configuration.doCheckOption(27));
        }
        if (this._configuration.doDisplayOption(5)) {
            this.addCheckbox(5, this._configuration.getDisplayTitle(5));
            this.setCheckbox(5, this._configuration.doCheckOption(5));
        }
        if (this._configuration.doDisplayOption(23)) {
            this.addCheckbox(23, this._configuration.getDisplayTitle(23));
            this.setCheckbox(23, this._configuration.doCheckOption(23));
        }
        if (this._configuration.doDisplayOption(25)) {
            this.addCheckbox(25, this._configuration.getDisplayTitle(25));
            this.setCheckbox(25, this._configuration.doCheckOption(25));
        }
        if (this._configuration.doDisplayOption(24)) {
            this.addCheckbox(24, this._configuration.getDisplayTitle(24));
            this.setCheckbox(24, this._configuration.doCheckOption(24));
        }
    }

    private void setVisibilityOfDomainStrucureControls() {
        MainFrame mainFrame;
        if (this._zoom_in_domain_structure != null && (mainFrame = this.getMainFrame()) != null) {
            if (this.isShowDomainArchitectures()) {
                this._domain_display_label.setVisible(true);
                this._zoom_in_domain_structure.setVisible(true);
                this._zoom_out_domain_structure.setVisible(true);
                this._decr_domain_structure_evalue_thr.setVisible(true);
                this._incr_domain_structure_evalue_thr.setVisible(true);
                this._domain_structure_evalue_thr_tf.setVisible(true);
                if (mainFrame._right_line_up_domains_cbmi != null) {
                    mainFrame._right_line_up_domains_cbmi.setVisible(true);
                }
                if (mainFrame._show_domain_labels != null) {
                    mainFrame._show_domain_labels.setVisible(true);
                }
            } else {
                this._domain_display_label.setVisible(false);
                this._zoom_in_domain_structure.setVisible(false);
                this._zoom_out_domain_structure.setVisible(false);
                this._decr_domain_structure_evalue_thr.setVisible(false);
                this._incr_domain_structure_evalue_thr.setVisible(false);
                this._domain_structure_evalue_thr_tf.setVisible(false);
                if (mainFrame._right_line_up_domains_cbmi != null) {
                    mainFrame._right_line_up_domains_cbmi.setVisible(false);
                }
                if (mainFrame._show_domain_labels != null) {
                    mainFrame._show_domain_labels.setVisible(false);
                }
            }
        }
    }

    void activateButtonToReturnToSuperTree(int n) {
        if (--n > 0) {
            this._return_to_super_tree.setText("R " + n);
        } else {
            this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        }
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        this._return_to_super_tree.setEnabled(true);
    }

    void activateButtonToUncollapseAll() {
        this._uncollapse_all.setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        this._uncollapse_all.setEnabled(true);
    }

    void addButtons() {
        JLabel jLabel = new JLabel("");
        jLabel.setOpaque(false);
        this.add(jLabel);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this.getConfiguration().isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
            jPanel2.setBackground(this.getBackground());
            jPanel3.setBackground(this.getBackground());
            jPanel4.setBackground(this.getBackground());
        }
        this._zoom_label = new JLabel("Zoom:");
        this.add(this._zoom_label);
        ControlPanel.customizeLabel(this._zoom_label, this.getConfiguration());
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        if (this.getConfiguration().isUseNativeUI()) {
            this._zoom_in_x = new TypomaticJButton("+");
            this._zoom_out_x = new TypomaticJButton("-");
        } else {
            this._zoom_in_x = new TypomaticJButton("X+");
            this._zoom_out_x = new TypomaticJButton("X-");
        }
        this._zoom_in_y = new TypomaticJButton("Y+");
        this._zoom_out_y = new TypomaticJButton("Y-");
        this._show_whole = new JButton("F");
        this._show_whole.setToolTipText("fit and center tree display [Alt+C, Home, or Esc]");
        this._zoom_in_x.setToolTipText("zoom in horizontally [Alt+Right or Shift+Alt+mousewheel]");
        this._zoom_in_y.setToolTipText("zoom in vertically [Alt+Up or Shift+mousewheel]");
        this._zoom_out_x.setToolTipText("zoom out horizontally [Alt+Left or Shift+Alt+mousewheel]");
        this._zoom_out_y.setToolTipText("zoom out vertically [Alt+Down or Shift+mousewheel]");
        if (this.getConfiguration().isUseNativeUI() && ForesterUtil.isMac()) {
            this._zoom_out_x.setPreferredSize(new Dimension(55, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(55, 10));
        } else {
            this._zoom_out_x.setPreferredSize(new Dimension(10, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(10, 10));
        }
        this._zoom_out_y.setPreferredSize(new Dimension(10, 10));
        this._zoom_in_y.setPreferredSize(new Dimension(10, 10));
        this._show_whole.setPreferredSize(new Dimension(10, 10));
        this._return_to_super_tree = new JButton(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setToolTipText("return to the super-tree (if in sub-tree) [Alt+R]");
        this._return_to_super_tree.setEnabled(false);
        this._order = new JButton("O");
        this._order.setToolTipText("order all [Alt+O]");
        this._uncollapse_all = new JButton("U");
        this._uncollapse_all.setToolTipText("uncollapse all [Alt+U]");
        this.addJButton(this._zoom_in_y, jPanel);
        this.addJButton(this._zoom_out_x, jPanel2);
        this.addJButton(this._show_whole, jPanel2);
        this.addJButton(this._zoom_in_x, jPanel2);
        this.addJButton(this._zoom_out_y, jPanel3);
        JLabel jLabel2 = new JLabel("");
        this.add(jLabel2);
        this.add(jPanel4);
        this.addJButton(this._order, jPanel4);
        this.addJButton(this._return_to_super_tree, jPanel4);
        this.addJButton(this._uncollapse_all, jPanel4);
        if (this.getConfiguration().doDisplayOption(10)) {
            this.setUpControlsForDomainStrucures();
        }
        this.setUpControlsForDepthCollapse();
        this.setUpControlsForRankCollapse();
        JLabel jLabel3 = new JLabel("");
        this.add(jLabel3);
        this.setVisibilityOfDomainStrucureControls();
    }

    void addCheckbox(int n, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        switch (n) {
            case 15: {
                this._display_internal_data = new JCheckBox(string);
                this._display_internal_data.setToolTipText("To allow or disallow display of internal labels");
                this.addJCheckBox(this._display_internal_data, jPanel);
                this.add(jPanel);
                break;
            }
            case 30: {
                this._display_external_data = new JCheckBox(string);
                this._display_external_data.setToolTipText("To allow or disallow display of external labels");
                this.addJCheckBox(this._display_external_data, jPanel);
                this.add(jPanel);
                break;
            }
            case 6: {
                this._color_acc_species = new JCheckBox(string);
                this._color_acc_species.setToolTipText("To colorize node labels as a function of taxonomy");
                this.addJCheckBox(this._color_acc_species, jPanel);
                this.add(jPanel);
                break;
            }
            case 7: {
                this._color_acc_sequence = new JCheckBox(string);
                this._color_acc_sequence.setToolTipText("To colorize node labels as a function of sequence name");
                this.addJCheckBox(this._color_acc_sequence, jPanel);
                this.add(jPanel);
                break;
            }
            case 19: {
                this._color_according_to_annotation = new JCheckBox(string);
                this._color_according_to_annotation.setToolTipText("To colorize sequence annotation labels as a function of sequence annotation");
                this.addJCheckBox(this._color_according_to_annotation, jPanel);
                this.add(jPanel);
                break;
            }
            case 1: {
                this._show_node_names = new JCheckBox(string);
                this.addJCheckBox(this._show_node_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 17: {
                this._show_taxo_scientific_names = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_scientific_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 18: {
                this._show_taxo_common_names = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_common_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 2: {
                this._show_taxo_code = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_code, jPanel);
                this.add(jPanel);
                break;
            }
            case 29: {
                this._show_taxo_rank = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_rank, jPanel);
                this.add(jPanel);
                break;
            }
            case 24: {
                this._show_taxo_images_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_taxo_images_cb, jPanel);
                this.add(jPanel);
                break;
            }
            case 11: {
                this._show_binary_characters = new JCheckBox(string);
                this.addJCheckBox(this._show_binary_characters, jPanel);
                this.add(jPanel);
                break;
            }
            case 3: {
                this._show_annotation = new JCheckBox(string);
                this.addJCheckBox(this._show_annotation, jPanel);
                this.add(jPanel);
                break;
            }
            case 12: {
                this._show_binary_character_counts = new JCheckBox(string);
                this.addJCheckBox(this._show_binary_character_counts, jPanel);
                this.add(jPanel);
                break;
            }
            case 4: {
                this._write_confidence = new JCheckBox(string);
                this.addJCheckBox(this.getWriteConfidenceCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 5: {
                this._show_events = new JCheckBox(string);
                this.addJCheckBox(this.getShowEventsCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 8: {
                this._use_visual_styles_cb = new JCheckBox(string);
                this.getUseVisualStylesCb().setToolTipText("To use visual styles (node colors, fonts) and branch colors, if present");
                this.addJCheckBox(this.getUseVisualStylesCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 9: {
                this._width_branches = new JCheckBox(string);
                this._width_branches.setToolTipText("To use branch width values, if present");
                this.addJCheckBox(this._width_branches, jPanel);
                this.add(jPanel);
                break;
            }
            case 28: {
                this._write_branch_length_values = new JCheckBox(string);
                this.addJCheckBox(this._write_branch_length_values, jPanel);
                this.add(jPanel);
                break;
            }
            case 10: {
                this._show_domain_architectures = new JCheckBox(string);
                this.addJCheckBox(this._show_domain_architectures, jPanel);
                this.add(jPanel);
                break;
            }
            case 27: {
                this._show_mol_seqs = new JCheckBox(string);
                this.addJCheckBox(this._show_mol_seqs, jPanel);
                this.add(jPanel);
                break;
            }
            case 13: {
                this._show_seq_names = new JCheckBox(string);
                this.addJCheckBox(this._show_seq_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 26: {
                this._show_gene_names = new JCheckBox(string);
                this.addJCheckBox(this._show_gene_names, jPanel);
                this.add(jPanel);
                break;
            }
            case 20: {
                this._show_seq_symbols = new JCheckBox(string);
                this.addJCheckBox(this._show_seq_symbols, jPanel);
                this.add(jPanel);
                break;
            }
            case 14: {
                this._show_sequence_acc = new JCheckBox(string);
                this.addJCheckBox(this._show_sequence_acc, jPanel);
                this.add(jPanel);
                break;
            }
            case 16: {
                this._dynamically_hide_data = new JCheckBox(string);
                this.getDynamicallyHideData().setToolTipText("To hide labels depending on expected visibility");
                this.addJCheckBox(this.getDynamicallyHideData(), jPanel);
                this.add(jPanel);
                break;
            }
            case 21: {
                this._node_desc_popup_cb = new JCheckBox(string);
                this.getNodeDescPopupCb().setToolTipText("To enable mouse rollover display of basic node data");
                this.addJCheckBox(this.getNodeDescPopupCb(), jPanel);
                this.add(jPanel);
                break;
            }
            case 22: {
                this._seq_relation_confidence_switch = new JCheckBox(string);
                this.addJCheckBox(this._seq_relation_confidence_switch, jPanel);
                this.add(jPanel);
                break;
            }
            case 23: {
                this._show_vector_data_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_vector_data_cb, jPanel);
                this.add(jPanel);
                break;
            }
            case 25: {
                this._show_properties_cb = new JCheckBox(string);
                this.addJCheckBox(this._show_properties_cb, jPanel);
                this.add(jPanel);
                break;
            }
            default: {
                throw new RuntimeException("unknown checkbox: " + n);
            }
        }
    }

    void addJButton(JButton jButton, JPanel jPanel) {
        jButton.setFocusPainted(false);
        jButton.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jButton.setBorder(BorderFactory.createLineBorder(this.getConfiguration().getGuiButtonBorderColor()));
            jButton.setBackground(this.getConfiguration().getGuiButtonBackgroundColor());
            jButton.setForeground(this.getConfiguration().getGuiButtonTextColor());
        }
        jPanel.add(jButton);
        jButton.addActionListener(this);
    }

    void addJCheckBox(JCheckBox jCheckBox, JPanel jPanel) {
        jCheckBox.setFocusPainted(false);
        jCheckBox.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jCheckBox.setBackground(this.getConfiguration().getGuiBackgroundColor());
            jCheckBox.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        jPanel.add((Component)jCheckBox, "Center");
        jCheckBox.addActionListener(this);
    }

    private final void setupJRadioButton(JRadioButton jRadioButton) {
        jRadioButton.setFocusPainted(false);
        jRadioButton.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jRadioButton.setBackground(this.getConfiguration().getGuiBackgroundColor());
            jRadioButton.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        jRadioButton.addActionListener(this);
    }

    void addJTextField(JTextField jTextField, JPanel jPanel) {
        if (!this._configuration.isUseNativeUI()) {
            jTextField.setForeground(this.getConfiguration().getGuiBackgroundColor());
            jTextField.setFont(jcb_font);
        }
        jPanel.add(jTextField);
        jTextField.addActionListener(this);
    }

    void deactivateButtonToReturnToSuperTree() {
        this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setForeground(this.getConfiguration().getGuiButtonTextColor());
        this._return_to_super_tree.setEnabled(false);
    }

    void deactivateButtonToUncollapseAll() {
        this._uncollapse_all.setForeground(this.getConfiguration().getGuiButtonTextColor());
        this._uncollapse_all.setEnabled(false);
    }

    void displayedPhylogenyMightHaveChanged(boolean bl) {
        if (this._mainpanel != null && this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            if (bl) {
                this._mainpanel.getCurrentTreePanel().initNodeData();
                this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
            }
            if (this.getOptions().isShowOverview()) {
                this._mainpanel.getCurrentTreePanel().updateOvSizes();
            }
            this._mainpanel.getCurrentTreePanel().recalculateMaxDistanceToRoot();
            this.setVisibilityOfDomainStrucureControls();
            this.updateDomainStructureEvaluethresholdDisplay();
            this.updateDepthCollapseDepthDisplay();
            this.updateRankCollapseRankDisplay();
            this.getMainPanel().getControlPanel();
            this._mainpanel.getCurrentTreePanel().updateButtonToUncollapseAll();
            this._mainpanel.getCurrentTreePanel().calculateScaleDistance();
            this._mainpanel.getCurrentTreePanel().calcMaxDepth();
            this._mainpanel.adjustJScrollPane();
            this._mainpanel.getCurrentTreePanel().repaint();
        }
    }

    void endClickToOptions() {
        this._click_to_combobox.addActionListener(this);
    }

    NodeClickAction getActionWhenNodeClicked() {
        return this._action_when_node_clicked;
    }

    Map<Integer, String> getAllClickToItems() {
        return this._all_click_to_names;
    }

    Map<String, Color> getAnnotationColors() {
        return this._annotation_colors;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    Options getOptions() {
        return this.getMainPanel().getOptions();
    }

    JLabel getSearchFoundCountsLabel0() {
        return this._search_found_label_0;
    }

    JLabel getSearchFoundCountsLabel1() {
        return this._search_found_label_1;
    }

    JButton getSearchResetButton0() {
        return this._search_reset_button_0;
    }

    JButton getSearchResetButton1() {
        return this._search_reset_button_1;
    }

    JTextField getSearchTextField0() {
        return this._search_tf_0;
    }

    JTextField getSearchTextField1() {
        return this._search_tf_1;
    }

    Map<String, Color> getSequenceColors() {
        return this._sequence_colors;
    }

    List<String> getSingleClickToNames() {
        return this._click_to_names;
    }

    Map<String, Color> getSpeciesColors() {
        return this._species_colors;
    }

    boolean isAntialiasScreenText() {
        return true;
    }

    boolean isColorAccordingToAnnotation() {
        return this._color_according_to_annotation != null && this._color_according_to_annotation.isSelected();
    }

    boolean isColorAccordingToSequence() {
        return this._color_acc_sequence != null && this._color_acc_sequence.isSelected();
    }

    boolean isColorAccordingToTaxonomy() {
        return this._color_acc_species != null && this._color_acc_species.isSelected();
    }

    boolean isDrawPhylogram() {
        Options.PHYLOGENY_DISPLAY_TYPE pHYLOGENY_DISPLAY_TYPE = this.getTreeDisplayType(this.getMainPanel().getCurrentTabIndex());
        return pHYLOGENY_DISPLAY_TYPE == Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM || pHYLOGENY_DISPLAY_TYPE == Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM;
    }

    boolean isDynamicallyHideData() {
        return this.getDynamicallyHideData() != null && this.getDynamicallyHideData().isSelected();
    }

    boolean isEvents() {
        return this.getShowEventsCb() != null && this.getShowEventsCb().isSelected();
    }

    boolean isNodeDescPopup() {
        return this.getNodeDescPopupCb() != null && this.getNodeDescPopupCb().isSelected();
    }

    boolean isShowAnnotation() {
        return this._show_annotation != null && this._show_annotation.isSelected();
    }

    boolean isShowBinaryCharacterCounts() {
        return this._show_binary_character_counts != null && this._show_binary_character_counts.isSelected();
    }

    boolean isShowBinaryCharacters() {
        return this._show_binary_characters != null && this._show_binary_characters.isSelected();
    }

    boolean isShowConfidenceValues() {
        return this.getWriteConfidenceCb() != null && this.getWriteConfidenceCb().isSelected();
    }

    boolean isShowDomainArchitectures() {
        return this._show_domain_architectures != null && this._show_domain_architectures.isSelected();
    }

    boolean isShowGeneNames() {
        return this._show_gene_names != null && this._show_gene_names.isSelected();
    }

    boolean isShowInternalData() {
        return this._display_internal_data == null || this._display_internal_data.isSelected();
    }

    boolean isShowExternalData() {
        return this._display_external_data == null || this._display_external_data.isSelected();
    }

    boolean isShowNodeNames() {
        return this._show_node_names != null && this._show_node_names.isSelected();
    }

    boolean isShowSeqNames() {
        return this._show_seq_names != null && this._show_seq_names.isSelected();
    }

    boolean isShowSeqSymbols() {
        return this._show_seq_symbols != null && this._show_seq_symbols.isSelected();
    }

    boolean isShowSequenceAcc() {
        return this._show_sequence_acc != null && this._show_sequence_acc.isSelected();
    }

    boolean isShowSequenceRelationConfidence() {
        return this._seq_relation_confidence_switch != null && this._seq_relation_confidence_switch.isSelected();
    }

    boolean isShowSequenceRelations() {
        return this._show_sequence_relations != null && this._show_sequence_relations.getSelectedIndex() > 0;
    }

    boolean isShowTaxonomyCode() {
        return this._show_taxo_code != null && this._show_taxo_code.isSelected();
    }

    boolean isShowTaxonomyRank() {
        return this._show_taxo_rank != null && this._show_taxo_rank.isSelected();
    }

    boolean isShowTaxonomyCommonNames() {
        return this._show_taxo_common_names != null && this._show_taxo_common_names.isSelected();
    }

    boolean isShowTaxonomyScientificNames() {
        return this._show_taxo_scientific_names != null && this._show_taxo_scientific_names.isSelected();
    }

    boolean isUseVisualStyles() {
        return this.getUseVisualStylesCb() != null && this.getUseVisualStylesCb().isSelected() || this.getUseVisualStylesCb() == null && this._color_branches;
    }

    boolean isWidthBranches() {
        return this._width_branches != null && this._width_branches.isSelected();
    }

    boolean isWriteBranchLengthValues() {
        return this._write_branch_length_values != null && this._write_branch_length_values.isSelected();
    }

    void phylogenyAdded(Configuration configuration) {
        if (configuration.isDrawAsPhylogram()) {
            this.getTreeDisplayTypes().add(Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM);
        } else {
            this.getTreeDisplayTypes().add(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
        }
    }

    void phylogenyRemoved(int n) {
        this.getTreeDisplayTypes().remove(n);
    }

    void search0() {
        MainPanel mainPanel = this.getMainPanel();
        Phylogeny phylogeny = mainPanel.getCurrentPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        String string = this.getSearchTextField0().getText();
        if (string != null) {
            string = string.trim();
        }
        if (!ForesterUtil.isEmpty(string)) {
            this.search0(mainPanel, phylogeny, string);
        } else {
            this.getSearchFoundCountsLabel0().setVisible(false);
            this.getSearchResetButton0().setEnabled(false);
            this.getSearchResetButton0().setVisible(false);
            this.searchReset0();
        }
    }

    void search1() {
        MainPanel mainPanel = this.getMainPanel();
        Phylogeny phylogeny = mainPanel.getCurrentPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        String string = this.getSearchTextField1().getText();
        if (string != null) {
            string = string.trim();
        }
        if (!ForesterUtil.isEmpty(string)) {
            this.search1(mainPanel, phylogeny, string);
        } else {
            this.getSearchFoundCountsLabel1().setVisible(false);
            this.getSearchResetButton1().setEnabled(false);
            this.getSearchResetButton1().setVisible(false);
            this.searchReset1();
        }
    }

    void searchReset0() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes0(null);
        }
    }

    void searchReset1() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes1(null);
        }
    }

    void setActionWhenNodeClicked(NodeClickAction nodeClickAction) {
        this._action_when_node_clicked = nodeClickAction;
    }

    void setAnnotationColors(Map<String, Color> map) {
        this._annotation_colors = map;
    }

    void setCheckbox(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (this.getDisplayAsUnalignedPhylogramRb() == null) break;
                this.getDisplayAsUnalignedPhylogramRb().setSelected(bl);
                this.getDisplayAsAlignedPhylogramRb().setSelected(!bl);
                this.getDisplayAsCladogramRb().setSelected(!bl);
                break;
            }
            case 15: {
                if (this._display_internal_data == null) break;
                this._display_internal_data.setSelected(bl);
                break;
            }
            case 30: {
                if (this._display_external_data == null) break;
                this._display_external_data.setSelected(bl);
                break;
            }
            case 6: {
                if (this._color_acc_species == null) break;
                this._color_acc_species.setSelected(bl);
                break;
            }
            case 7: {
                if (this._color_acc_sequence == null) break;
                this._color_acc_sequence.setSelected(bl);
                break;
            }
            case 19: {
                if (this._color_according_to_annotation == null) break;
                this._color_according_to_annotation.setSelected(bl);
                break;
            }
            case 1: {
                if (this._show_node_names == null) break;
                this._show_node_names.setSelected(bl);
                break;
            }
            case 17: {
                if (this._show_taxo_scientific_names == null) break;
                this._show_taxo_scientific_names.setSelected(bl);
                break;
            }
            case 18: {
                if (this._show_taxo_common_names == null) break;
                this._show_taxo_common_names.setSelected(bl);
                break;
            }
            case 2: {
                if (this._show_taxo_code == null) break;
                this._show_taxo_code.setSelected(bl);
                break;
            }
            case 29: {
                if (this._show_taxo_rank == null) break;
                this._show_taxo_rank.setSelected(bl);
                break;
            }
            case 24: {
                if (this._show_taxo_images_cb == null) break;
                this._show_taxo_images_cb.setSelected(bl);
                break;
            }
            case 3: {
                if (this._show_annotation == null) break;
                this._show_annotation.setSelected(bl);
                break;
            }
            case 11: {
                if (this._show_binary_characters == null) break;
                this._show_binary_characters.setSelected(bl);
                break;
            }
            case 12: {
                if (this._show_binary_character_counts == null) break;
                this._show_binary_character_counts.setSelected(bl);
                break;
            }
            case 4: {
                if (this.getWriteConfidenceCb() == null) break;
                this.getWriteConfidenceCb().setSelected(bl);
                break;
            }
            case 5: {
                if (this.getShowEventsCb() == null) break;
                this.getShowEventsCb().setSelected(bl);
                break;
            }
            case 8: {
                if (this.getUseVisualStylesCb() == null) break;
                this.getUseVisualStylesCb().setSelected(bl);
                break;
            }
            case 9: {
                if (this._width_branches == null) break;
                this._width_branches.setSelected(bl);
                break;
            }
            case 10: {
                if (this._show_domain_architectures == null) break;
                this._show_domain_architectures.setSelected(bl);
                break;
            }
            case 28: {
                if (this._write_branch_length_values == null) break;
                this._write_branch_length_values.setSelected(bl);
                break;
            }
            case 27: {
                if (this._show_mol_seqs == null) break;
                this._show_mol_seqs.setSelected(bl);
                break;
            }
            case 13: {
                if (this._show_seq_names == null) break;
                this._show_seq_names.setSelected(bl);
                break;
            }
            case 26: {
                if (this._show_gene_names == null) break;
                this._show_gene_names.setSelected(bl);
                break;
            }
            case 20: {
                if (this._show_seq_symbols == null) break;
                this._show_seq_symbols.setSelected(bl);
                break;
            }
            case 23: {
                if (this._show_vector_data_cb == null) break;
                this._show_vector_data_cb.setSelected(bl);
                break;
            }
            case 25: {
                if (this._show_properties_cb == null) break;
                this._show_properties_cb.setSelected(bl);
                break;
            }
            case 14: {
                if (this._show_sequence_acc == null) break;
                this._show_sequence_acc.setSelected(bl);
                break;
            }
            case 16: {
                if (this.getDynamicallyHideData() == null) break;
                this.getDynamicallyHideData().setSelected(bl);
                break;
            }
            case 21: {
                if (this.getNodeDescPopupCb() == null) break;
                this.getNodeDescPopupCb().setSelected(bl);
                break;
            }
            case 22: {
                if (this._seq_relation_confidence_switch == null) break;
                this._seq_relation_confidence_switch.setSelected(bl);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown checkbox: " + n));
            }
        }
    }

    void setCheckbox(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    void setClickToAction(int n) {
        if (n == this._show_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SHOW_DATA);
        } else if (n == this._collapse_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLLAPSE);
        } else if (n == this._reroot_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.REROOT);
        } else if (n == this._subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SUBTREE);
        } else if (n == this._swap_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SWAP);
        } else if (n == this._color_subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_SUBTREE);
        } else if (n == this._open_seq_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_SEQ_WEB);
        } else if (n == this._sort_descendents_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SORT_DESCENDENTS);
        } else if (n == this._blast_item) {
            this.setActionWhenNodeClicked(NodeClickAction.BLAST);
        } else if (n == this._open_tax_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_TAX_WEB);
        } else if (n == this._cut_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CUT_SUBTREE);
        } else if (n == this._copy_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COPY_SUBTREE);
        } else if (n == this._delete_node_or_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.DELETE_NODE_OR_SUBTREE);
        } else if (n == this._paste_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.PASTE_SUBTREE);
        } else if (n == this._add_new_node_item) {
            this.setActionWhenNodeClicked(NodeClickAction.ADD_NEW_NODE);
        } else if (n == this._edit_node_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.EDIT_NODE_DATA);
        } else if (n == this._select_nodes_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SELECT_NODES);
        } else if (n == this._get_ext_desc_data) {
            this.setActionWhenNodeClicked(NodeClickAction.GET_EXT_DESC_DATA);
        } else if (n == this._open_pdb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_PDB_WEB);
        } else if (n == this._color_node_font_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_NODE_FONT);
        } else if (n == this._change_node_font_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CHANGE_NODE_FONT);
        } else if (n == this._uncollapse_all_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.UNCOLLAPSE_ALL);
        } else if (n == this._order_subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.ORDER_SUBTREE);
        } else {
            throw new RuntimeException("unknown action: " + n);
        }
        this._click_to_combobox.setSelectedIndex(n);
    }

    void setColorBranches(boolean bl) {
        this._color_branches = bl;
    }

    void setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE pHYLOGENY_DISPLAY_TYPE) {
        switch (pHYLOGENY_DISPLAY_TYPE) {
            case UNALIGNED_PHYLOGRAM: {
                this.getDisplayAsUnalignedPhylogramRb().setSelected(true);
                break;
            }
            case ALIGNED_PHYLOGRAM: {
                this.getDisplayAsAlignedPhylogramRb().setSelected(true);
                break;
            }
            case CLADOGRAM: {
                this.getDisplayAsCladogramRb().setSelected(true);
            }
        }
        this.setTreeDisplayType(this.getMainPanel().getCurrentTabIndex(), pHYLOGENY_DISPLAY_TYPE);
    }

    void setDrawPhylogramEnabled(boolean bl) {
        if (this.getDisplayAsAlignedPhylogramRb() != null && this.getDisplayAsUnalignedPhylogramRb() != null && this.getDisplayAsCladogramRb() != null) {
            this.getDisplayAsAlignedPhylogramRb().setEnabled(bl);
            this.getDisplayAsUnalignedPhylogramRb().setEnabled(bl);
            this.getDisplayAsCladogramRb().setEnabled(bl);
        }
    }

    void setDynamicHidingIsOn(boolean bl) {
        if (bl) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiCheckboxAndButtonActiveColor());
        } else if (!this._configuration.isUseNativeUI()) {
            this.getDynamicallyHideData().setForeground(this.getConfiguration().getGuiButtonTextColor());
        } else {
            this.getDynamicallyHideData().setForeground(Color.BLACK);
        }
    }

    void setSearchFoundCountsOnLabel0(int n) {
        this.getSearchFoundCountsLabel0().setText("Found: " + n);
    }

    void setSearchFoundCountsOnLabel1(int n) {
        this.getSearchFoundCountsLabel1().setText("Found: " + n);
    }

    void setSequenceColors(Map<String, Color> map) {
        this._sequence_colors = map;
    }

    void setShowEvents(boolean bl) {
        if (this.getShowEventsCb() == null) {
            this._show_events = new JCheckBox("");
        }
        this.getShowEventsCb().setSelected(bl);
    }

    void setSpeciesColors(Map<String, Color> map) {
        this._species_colors = map;
    }

    void setupControls() {
        this.setupTreeDisplayTypeOptions();
        this.setupDisplayCheckboxes();
        if (this._configuration.displaySequenceRelations()) {
            this.addSequenceRelationBlock();
        }
        this.startClickToOptions();
        this.setupClickToOptions();
        this.endClickToOptions();
        this.addButtons();
        this.setupSearchTools0();
        this.setupSearchTools1();
    }

    void setupTreeDisplayTypeOptions() {
        this._display_as_unaligned_phylogram_rb = new JRadioButton("P");
        this._display_as_aligned_phylogram_rb = new JRadioButton("A");
        this._display_as_cladogram_rb = new JRadioButton("C");
        this._display_as_buttongroup = new ButtonGroup();
        this._display_as_buttongroup.add(this._display_as_unaligned_phylogram_rb);
        this._display_as_buttongroup.add(this._display_as_aligned_phylogram_rb);
        this._display_as_buttongroup.add(this._display_as_cladogram_rb);
        this.getDisplayAsUnalignedPhylogramRb().setToolTipText("(unaligned) phylogram");
        this.getDisplayAsAlignedPhylogramRb().setToolTipText("aligned phylogram");
        this.getDisplayAsCladogramRb().setToolTipText("cladogram");
        this.setupJRadioButton(this.getDisplayAsUnalignedPhylogramRb());
        this.setupJRadioButton(this.getDisplayAsAlignedPhylogramRb());
        this.setupJRadioButton(this.getDisplayAsCladogramRb());
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 0, 0));
        jPanel.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jPanel.setBackground(this.getConfiguration().getGuiBackgroundColor());
            jPanel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        jPanel.add(this._display_as_unaligned_phylogram_rb);
        jPanel.add(this._display_as_aligned_phylogram_rb);
        jPanel.add(this._display_as_cladogram_rb);
        this.add(jPanel);
    }

    void setUpControlsForDomainStrucures() {
        this._domain_display_label = new JLabel("Domain Architectures:");
        this.add(ControlPanel.customizeLabel(this._domain_display_label, this.getConfiguration()));
        this.add(this._domain_display_label);
        this._zoom_in_domain_structure = new TypomaticJButton("d+");
        this._zoom_out_domain_structure = new TypomaticJButton("d-");
        this._decr_domain_structure_evalue_thr = new JButton("-");
        this._incr_domain_structure_evalue_thr = new JButton("+");
        this._zoom_in_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._zoom_out_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._decr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setToolTipText("Increase the E-value threshold by a factor of 10");
        this._decr_domain_structure_evalue_thr.setToolTipText("Decrease the E-value threshold by a factor of 10");
        this._domain_structure_evalue_thr_tf = new JTextField(3);
        this._domain_structure_evalue_thr_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._domain_structure_evalue_thr_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._domain_structure_evalue_thr_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._domain_structure_evalue_thr_tf.setBorder(null);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
            jPanel2.setBackground(this.getBackground());
        }
        this.add(jPanel);
        this.add(jPanel2);
        this.addJButton(this._zoom_out_domain_structure, jPanel);
        this.addJButton(this._zoom_in_domain_structure, jPanel);
        this.addJButton(this._decr_domain_structure_evalue_thr, jPanel2);
        this.addJTextField(this._domain_structure_evalue_thr_tf, jPanel2);
        this.addJButton(this._incr_domain_structure_evalue_thr, jPanel2);
    }

    void setUpControlsForDepthCollapse() {
        this._depth_collapse_label = new JLabel("Collapse by Node Depth:");
        this._depth_collapse_label.setToolTipText("to automaticall collapse nodes with a depth equal or larger than a threshold");
        this.add(ControlPanel.customizeLabel(this._depth_collapse_label, this.getConfiguration()));
        this.add(this._depth_collapse_label);
        this._decr_depth_collapse_level = new TypomaticJButton("-");
        this._incr_depth_collapse_level = new TypomaticJButton("+");
        this._decr_depth_collapse_level.setPreferredSize(new Dimension(10, 10));
        this._incr_depth_collapse_level.setPreferredSize(new Dimension(10, 10));
        this._decr_depth_collapse_level.setToolTipText("to decrease the depth threshold (wraps around)");
        this._incr_depth_collapse_level.setToolTipText("to increase the depth threshold (wraps around)");
        this._depth_collapse_depth_tf = new JTextField(3);
        this._depth_collapse_depth_tf.setToolTipText("the current depth threshold");
        this._depth_collapse_depth_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._depth_collapse_depth_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._depth_collapse_depth_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._depth_collapse_depth_tf.setBorder(null);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
        }
        this.add(jPanel);
        this.addJButton(this._decr_depth_collapse_level, jPanel);
        this.addJTextField(this._depth_collapse_depth_tf, jPanel);
        this.addJButton(this._incr_depth_collapse_level, jPanel);
    }

    void setUpControlsForRankCollapse() {
        this._rank_collapse_label = new JLabel("Collapse by Node Rank:");
        this._rank_collapse_label.setToolTipText("to automatically collapse nodes with a taxonomic rank equal or lower than a threshold");
        this.add(ControlPanel.customizeLabel(this._rank_collapse_label, this.getConfiguration()));
        this.add(this._rank_collapse_label);
        this._decr_rank_collapse_level = new TypomaticJButton("-");
        this._incr_rank_collapse_level = new TypomaticJButton("+");
        this._decr_rank_collapse_level.setPreferredSize(new Dimension(10, 10));
        this._incr_rank_collapse_level.setPreferredSize(new Dimension(10, 10));
        this._decr_rank_collapse_level.setToolTipText("to decrease the taxonomic rank threshold (wraps around)");
        this._incr_rank_collapse_level.setToolTipText("to increase the taxonomic rank threshold (wraps around)");
        this._rank_collapse_depth_tf = new JTextField(3);
        this._rank_collapse_depth_tf.setToolTipText("the current taxonomic rank threshold");
        this._rank_collapse_depth_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._rank_collapse_depth_tf.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._rank_collapse_depth_tf.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._rank_collapse_depth_tf.setBorder(null);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            jPanel.setBackground(this.getBackground());
        }
        this.add(jPanel);
        this.addJButton(this._decr_rank_collapse_level, jPanel);
        this.addJTextField(this._rank_collapse_depth_tf, jPanel);
        this.addJButton(this._incr_rank_collapse_level, jPanel);
    }

    void setupSearchTools0() {
        JLabel jLabel = new JLabel("Search (A):");
        jLabel.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jLabel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(jLabel);
        jLabel.setToolTipText(SEARCH_TIP_TEXT);
        this._search_found_label_0 = new JLabel();
        this.getSearchFoundCountsLabel0().setVisible(false);
        this._search_found_label_0.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label_0.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this._search_tf_0 = new JTextField(3);
        this._search_tf_0.setToolTipText(SEARCH_TIP_TEXT);
        this._search_tf_0.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf_0.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._search_tf_0.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._search_tf_0.setBorder(null);
        }
        this._search_reset_button_0 = new JButton();
        this.getSearchResetButton0().setText("Reset");
        this.getSearchResetButton0().setEnabled(false);
        this.getSearchResetButton0().setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel.setBackground(this.getBackground());
        this.add(jPanel);
        jPanel2.setBackground(this.getBackground());
        this.add(jPanel2);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ControlPanel.this.search0();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.searchReset0();
                ControlPanel.this.setSearchFoundCountsOnLabel0(0);
                ControlPanel.this.getSearchFoundCountsLabel0().setVisible(false);
                ControlPanel.this.getSearchTextField0().setText("");
                ControlPanel.this.getSearchResetButton0().setEnabled(false);
                ControlPanel.this.getSearchResetButton0().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button_0.addActionListener(actionListener);
        this._search_tf_0.addKeyListener(keyAdapter);
        this.addJTextField(this._search_tf_0, jPanel);
        jPanel2.add(this._search_found_label_0);
        this.addJButton(this._search_reset_button_0, jPanel2);
    }

    void setupSearchTools1() {
        JLabel jLabel = new JLabel("Search (B):");
        jLabel.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jLabel.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this.add(jLabel);
        jLabel.setToolTipText(SEARCH_TIP_TEXT);
        this._search_found_label_1 = new JLabel();
        this.getSearchFoundCountsLabel1().setVisible(false);
        this._search_found_label_1.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label_1.setForeground(this.getConfiguration().getGuiCheckboxTextColor());
        }
        this._search_tf_1 = new JTextField(3);
        this._search_tf_1.setToolTipText(SEARCH_TIP_TEXT);
        this._search_tf_1.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf_1.setForeground(this.getConfiguration().getGuiMenuBackgroundColor());
            this._search_tf_1.setBackground(this.getConfiguration().getGuiCheckboxTextColor());
            this._search_tf_1.setBorder(null);
        }
        this._search_reset_button_1 = new JButton();
        this.getSearchResetButton1().setText("Reset");
        this.getSearchResetButton1().setEnabled(false);
        this.getSearchResetButton1().setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel.setBackground(this.getBackground());
        this.add(jPanel);
        jPanel2.setBackground(this.getBackground());
        this.add(jPanel2);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ControlPanel.this.search1();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.searchReset1();
                ControlPanel.this.setSearchFoundCountsOnLabel1(0);
                ControlPanel.this.getSearchFoundCountsLabel1().setVisible(false);
                ControlPanel.this.getSearchTextField1().setText("");
                ControlPanel.this.getSearchResetButton1().setEnabled(false);
                ControlPanel.this.getSearchResetButton1().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button_1.addActionListener(actionListener);
        this._search_tf_1.addKeyListener(keyAdapter);
        this.addJTextField(this._search_tf_1, jPanel);
        jPanel2.add(this._search_found_label_1);
        this.addJButton(this._search_reset_button_1, jPanel2);
    }

    void setVisibilityOfDomainStrucureCB() {
        try {
            if (this.getCurrentTreePanel() != null && (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(false);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(false);
                }
            } else if (this.isShowDomainArchitectures()) {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(true);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(true);
                }
            } else {
                if (this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi != null) {
                    this.getMainPanel().getMainFrame()._right_line_up_domains_cbmi.setVisible(false);
                }
                if (this.getMainPanel().getMainFrame()._show_domain_labels != null) {
                    this.getMainPanel().getMainFrame()._show_domain_labels.setVisible(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setVisibilityOfX() {
        MainFrame mainFrame = this.getMainFrame();
        if (mainFrame != null) {
            if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().getPhylogeny() != null) {
                if (AptxUtil.isHasAtLeastOneBranchWithSupportSD(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mainFrame._show_confidence_stddev_cbmi != null) {
                        mainFrame._show_confidence_stddev_cbmi.setVisible(true);
                    }
                } else if (mainFrame._show_confidence_stddev_cbmi != null) {
                    mainFrame._show_confidence_stddev_cbmi.setVisible(false);
                }
                if (AptxUtil.isHasAtLeastOneNodeWithScientificName(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mainFrame._abbreviate_scientific_names != null) {
                        mainFrame._abbreviate_scientific_names.setVisible(true);
                    }
                } else if (mainFrame._abbreviate_scientific_names != null) {
                    mainFrame._abbreviate_scientific_names.setVisible(false);
                }
                if (AptxUtil.isHasAtLeastOneNodeWithSequenceAnnotation(this.getCurrentTreePanel().getPhylogeny())) {
                    if (mainFrame._show_annotation_ref_source != null) {
                        mainFrame._show_annotation_ref_source.setVisible(true);
                    }
                } else if (mainFrame._show_annotation_ref_source != null) {
                    mainFrame._show_annotation_ref_source.setVisible(false);
                }
            }
            if (this.isDrawPhylogram() || this.getCurrentTreePanel() != null && (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                if (mainFrame._non_lined_up_cladograms_rbmi != null) {
                    mainFrame._non_lined_up_cladograms_rbmi.setVisible(false);
                }
                if (mainFrame._ext_node_dependent_cladogram_rbmi != null) {
                    mainFrame._ext_node_dependent_cladogram_rbmi.setVisible(false);
                }
            } else {
                if (mainFrame._non_lined_up_cladograms_rbmi != null) {
                    mainFrame._non_lined_up_cladograms_rbmi.setVisible(true);
                }
                if (mainFrame._ext_node_dependent_cladogram_rbmi != null) {
                    mainFrame._ext_node_dependent_cladogram_rbmi.setVisible(true);
                }
            }
            if (this.isDrawPhylogram()) {
                if (mainFrame._show_scale_cbmi != null) {
                    mainFrame._show_scale_cbmi.setVisible(true);
                }
            } else if (mainFrame._show_scale_cbmi != null) {
                mainFrame._show_scale_cbmi.setVisible(false);
            }
            if (this.getCurrentTreePanel() != null) {
                if (this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || this.getCurrentTreePanel().getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    if (mainFrame._label_direction_cbmi != null) {
                        mainFrame._label_direction_cbmi.setVisible(true);
                    }
                } else if (mainFrame._label_direction_cbmi != null) {
                    mainFrame._label_direction_cbmi.setVisible(false);
                }
            }
        }
    }

    void showAnnotations() {
        if (this._show_annotation != null) {
            this._show_annotation.setSelected(true);
        }
        if (this._color_according_to_annotation != null) {
            this._color_according_to_annotation.setSelected(true);
        }
        if (this._color_acc_species != null) {
            this._color_acc_species.setSelected(false);
        }
        if (this._color_acc_sequence != null) {
            this._color_acc_sequence.setSelected(false);
        }
        this._mainpanel.getCurrentTreePanel().repaint();
    }

    void showWhole() {
        if (this._mainpanel.getCurrentScrollPane() == null || this._mainpanel.getCurrentTreePanel().getPhylogeny().isEmpty()) {
            return;
        }
        this.getCurrentTreePanel().updateSetOfCollapsedExternalNodes();
        this.displayedPhylogenyMightHaveChanged(true);
        this._mainpanel.getCurrentTreePanel().updateOvSettings();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().updateOvSizes();
    }

    void showWholeAll() {
        for (TreePanel treePanel : this._mainpanel.getTreePanels()) {
            if (treePanel == null) continue;
            treePanel.validate();
            treePanel.calcParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height);
            treePanel.resetPreferredSize();
            treePanel.repaint();
        }
    }

    void startClickToOptions() {
        JLabel jLabel = new JLabel("");
        jLabel.setFont(jcb_font);
        this.add(jLabel);
        this._click_to_label = new JLabel("Click on Node to:");
        this.add(ControlPanel.customizeLabel(this._click_to_label, this.getConfiguration()));
        this._click_to_combobox = new JComboBox();
        this._click_to_combobox.setFocusable(false);
        this._click_to_combobox.setMaximumRowCount(14);
        this._click_to_combobox.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(this.getConfiguration().getGuiBackgroundColor());
        }
        this.add(this._click_to_combobox);
        this._all_click_to_names = new HashMap<Integer, String>();
        this._click_to_names = new ArrayList<String>();
    }

    void tabChanged() {
        if (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && this.getCurrentTreePanel().getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setDrawPhylogramEnabled(true);
                this.setTreeDisplayType(this.getTreeDisplayType(this.getMainPanel().getCurrentTabIndex()));
            } else {
                this.setDrawPhylogramEnabled(false);
                this.setTreeDisplayType(Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM);
            }
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getMainPanel().getCurrentTreePanel().getPhylogenyGraphicsType());
            this.getMainPanel().getCurrentTreePanel().updateSubSuperTreeButton();
            this.getMainPanel().getCurrentTreePanel().updateButtonToUncollapseAll();
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
            this.getMainPanel().getControlPanel().updateDomainStructureEvaluethresholdDisplay();
            this.getMainPanel().getControlPanel().updateDepthCollapseDepthDisplay();
            this.getMainPanel().getControlPanel().updateRankCollapseRankDisplay();
            this.getSequenceRelationTypeBox().removeAllItems();
            for (SequenceRelation.SEQUENCE_RELATION_TYPE sEQUENCE_RELATION_TYPE : this.getMainPanel().getCurrentPhylogeny().getRelevantSequenceRelationTypes()) {
                this._sequence_relation_type_box.addItem(sEQUENCE_RELATION_TYPE);
            }
            this.getMainPanel().getCurrentTreePanel().repaint();
        }
    }

    final void uncollapseAll(TreePanel treePanel) {
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny != null && !phylogeny.isEmpty()) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                phylogenyNode.setCollapse(false);
            }
            treePanel.resetNodeIdToDistToLeafMap();
            treePanel.updateSetOfCollapsedExternalNodes();
            phylogeny.recalculateNumberOfExternalDescendants(false);
            treePanel.setNodeInPreorderToNull();
            phylogeny.clearHashIdToNodeMap();
            treePanel.resetDepthCollapseDepthValue();
            treePanel.resetRankCollapseRankValue();
            this.showWhole();
        }
    }

    final void updateDomainStructureEvaluethresholdDisplay() {
        if (this._domain_structure_evalue_thr_tf != null) {
            this._domain_structure_evalue_thr_tf.setText("10^" + this.getMainPanel().getCurrentTreePanel().getDomainStructureEvalueThresholdExp());
        }
    }

    private final String obtainDepthCollapseDepthValue() {
        if (this.getMainPanel().getCurrentTreePanel() == null) {
            return "";
        }
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.getNumberOfExternalNodes() < 3) {
            return "off";
        }
        if (treePanel.getDepthCollapseDepthValue() < 0) {
            treePanel.setDepthCollapseDepthValue(PhylogenyMethods.calculateMaxDepth(phylogeny));
            return "off";
        }
        if (treePanel.getDepthCollapseDepthValue() == PhylogenyMethods.calculateMaxDepth(phylogeny)) {
            return "off";
        }
        return String.valueOf(treePanel.getDepthCollapseDepthValue());
    }

    private final String obtainRankCollapseDepthValue() {
        if (this.getMainPanel().getCurrentTreePanel() == null) {
            return "";
        }
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.getNumberOfExternalNodes() < 3) {
            return "off";
        }
        String[] stringArray = PhylogenyMethods.obtainPresentRanksSorted(phylogeny);
        if (stringArray.length < 1) {
            return "off";
        }
        if (treePanel.getRankCollapseRankValue() < 0) {
            treePanel.setRankCollapseRankValue(stringArray.length - 1);
            return "off";
        }
        if (treePanel.getRankCollapseRankValue() == stringArray.length - 1) {
            return "off";
        }
        return String.valueOf(treePanel.getRankCollapseRankValue());
    }

    final void updateDepthCollapseDepthDisplay() {
        if (this._depth_collapse_depth_tf != null) {
            this._depth_collapse_depth_tf.setText(" " + this.obtainDepthCollapseDepthValue());
        }
    }

    final void updateRankCollapseRankDisplay() {
        if (this._rank_collapse_depth_tf != null) {
            String string = this.obtainRankCollapseDepthValue();
            if (string.equals("off")) {
                this._rank_collapse_depth_tf.setText(" off");
                this._rank_collapse_depth_tf.setToolTipText("the current taxonomic rank threshold");
            } else {
                String[] stringArray = PhylogenyMethods.obtainPresentRanksSorted(this.getMainPanel().getCurrentTreePanel().getPhylogeny());
                int n = Integer.parseInt(string);
                this._rank_collapse_depth_tf.setText(stringArray[n]);
                this._rank_collapse_depth_tf.setToolTipText(n + 1 + "/" + (stringArray.length - 1) + ": " + stringArray[Integer.parseInt(string)]);
            }
        }
    }

    final void zoomInX(float f, float f2) {
        JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.0f);
        if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
            double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
            treePanel.setXdistance(treePanel.getXdistance() * f);
            treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
        } else {
            int n = jScrollBar.getMaximum() - jScrollBar.getMinimum() - jScrollBar.getVisibleAmount() - jScrollBar.getValue();
            treePanel.setXdistance(treePanel.getXdistance() * f);
            treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getMinimum() - n - jScrollBar.getVisibleAmount());
        }
        treePanel.resetPreferredSize();
        treePanel.updateOvSizes();
    }

    final void zoomInY(float f) {
        JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.1f);
        double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
        treePanel.setYdistance(treePanel.getYdistance() * f);
        this.getMainPanel().adjustJScrollPane();
        treePanel.resetPreferredSize();
        this.getMainPanel().getCurrentScrollPane().getViewport().validate();
        jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
        treePanel.resetPreferredSize();
        treePanel.updateOvSizes();
    }

    final void zoomOutX(float f, float f2) {
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(1.0f);
        if ((double)(treePanel.getXdistance() * f) > 0.0) {
            JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar();
            if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
                this.getMainPanel().adjustJScrollPane();
                treePanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
                treePanel.setXdistance(treePanel.getXdistance() * f);
                treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
                this.getMainPanel().adjustJScrollPane();
                treePanel.resetPreferredSize();
                this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
            } else {
                int n = jScrollBar.getMaximum() - jScrollBar.getMinimum() - jScrollBar.getVisibleAmount() - jScrollBar.getValue();
                treePanel.setXdistance(treePanel.getXdistance() * f);
                treePanel.setXcorrectionFactor(treePanel.getXcorrectionFactor() * f2);
                if (n > 0) {
                    this.getMainPanel().adjustJScrollPane();
                    treePanel.resetPreferredSize();
                    this.getMainPanel().getCurrentScrollPane().getViewport().validate();
                    jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getMinimum() - n - jScrollBar.getVisibleAmount());
                }
            }
            treePanel.resetPreferredSize();
            treePanel.updateOvSizes();
        }
    }

    private final boolean isDrawPhylogram(int n) {
        Options.PHYLOGENY_DISPLAY_TYPE pHYLOGENY_DISPLAY_TYPE = this.getTreeDisplayType(n);
        return pHYLOGENY_DISPLAY_TYPE == Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM | pHYLOGENY_DISPLAY_TYPE == Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM;
    }

    final void zoomOutY(float f) {
        TreePanel treePanel = this.getMainPanel().getCurrentTreePanel();
        treePanel.multiplyUrtFactor(0.9f);
        if ((double)(treePanel.getYdistance() * f) > 0.0) {
            JScrollBar jScrollBar = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar();
            double d = (double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / ((double)jScrollBar.getValue() + (double)jScrollBar.getVisibleAmount() / 2.0);
            treePanel.setYdistance(treePanel.getYdistance() * f);
            this.getMainPanel().adjustJScrollPane();
            treePanel.resetPreferredSize();
            this.getMainPanel().getCurrentScrollPane().getViewport().validate();
            jScrollBar.setValue(ForesterUtil.roundToInt((double)(jScrollBar.getMaximum() - jScrollBar.getMinimum()) / d - (double)jScrollBar.getVisibleAmount() / 2.0));
            treePanel.resetPreferredSize();
            treePanel.updateOvSizes();
        }
    }

    static final JLabel customizeLabel(JLabel jLabel, Configuration configuration) {
        jLabel.setFont(jcb_bold_font);
        if (!configuration.isUseNativeUI()) {
            jLabel.setForeground(configuration.getGuiCheckboxTextColor());
            jLabel.setBackground(configuration.getGuiBackgroundColor());
        }
        return jLabel;
    }

    public final JCheckBox getUseBranchWidthsCb() {
        return this._width_branches;
    }

    public Options.PHYLOGENY_DISPLAY_TYPE getTreeDisplayType() {
        if (this._display_as_unaligned_phylogram_rb.isSelected()) {
            return Options.PHYLOGENY_DISPLAY_TYPE.UNALIGNED_PHYLOGRAM;
        }
        if (this._display_as_aligned_phylogram_rb.isSelected()) {
            return Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM;
        }
        return Options.PHYLOGENY_DISPLAY_TYPE.CLADOGRAM;
    }

    static enum NodeClickAction {
        ADD_NEW_NODE,
        BLAST,
        COLLAPSE,
        COLOR_SUBTREE,
        COPY_SUBTREE,
        CUT_SUBTREE,
        DELETE_NODE_OR_SUBTREE,
        EDIT_NODE_DATA,
        GET_EXT_DESC_DATA,
        OPEN_PDB_WEB,
        OPEN_SEQ_WEB,
        OPEN_TAX_WEB,
        PASTE_SUBTREE,
        REROOT,
        SELECT_NODES,
        SHOW_DATA,
        SORT_DESCENDENTS,
        SUBTREE,
        SWAP,
        CHANGE_NODE_FONT,
        COLOR_NODE_FONT,
        UNCOLLAPSE_ALL,
        ORDER_SUBTREE;

    }
}

