/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.dynoptions;

import com.martiansoftware.jsap.JSAPResult;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.lang.reflect.Field;
import java.util.Set;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicOptionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicOptionRegistry.class);
    private static ObjectAVLTreeSet<DynamicOptionClient> registeredDOClients = new ObjectAVLTreeSet();
    private static String[] dymamicOptions;

    private DynamicOptionRegistry() {
    }

    public static void register(DynamicOptionClient client) {
        if (!registeredDOClients.contains((Object)client)) {
            LOG.trace("Adding client " + client);
            registeredDOClients.add((Object)client);
        }
    }

    public static void parseCommandLineOptions(JSAPResult jsapResult) {
        DynamicOptionRegistry.parseCommandLineOptions(jsapResult.getStringArray("dynamic-options"));
    }

    public static void parseCommandLineOptions(String[] dynamicOptions) {
        dymamicOptions = dynamicOptions;
        for (String dymamicOption : dynamicOptions) {
            boolean parsed = false;
            for (DynamicOptionClient doc : registeredDOClients) {
                if (!doc.acceptsOption(dymamicOption)) continue;
                parsed = true;
                break;
            }
            if (parsed) continue;
            System.err.println("Error: none of the installed tools could parse dynamic option: " + dymamicOption);
            System.exit(1);
        }
    }

    public static void printHelp() {
        System.out.println("The following dynamic options have been defined:");
        for (DynamicOptionClient doc : registeredDOClients) {
            String[] keys = doc.getKeys();
            String[] helpMessages = doc.getHelpMessages();
            String[] defaultValues = doc.getDefaultValues();
            int i = 0;
            System.out.println("-x " + doc.getClassname() + ":");
            for (String key : keys) {
                System.out.printf("  - %s: %s default: %s%n", key, helpMessages[i], defaultValues[i]);
                ++i;
            }
            System.out.println();
        }
    }

    public static void autoRegister() {
        Reflections reflections = new Reflections("org.campagnelab.goby", new Scanner[]{new FieldAnnotationsScanner()});
        Set result = reflections.getFieldsAnnotatedWith(RegisterThis.class);
        for (Field field : result) {
            try {
                DynamicOptionClient doc = (DynamicOptionClient)field.get(null);
                DynamicOptionRegistry.register(doc);
            }
            catch (IllegalAccessException e) {
                LOG.error("Unable to register dynamic option client. ", (Throwable)e);
            }
        }
    }
}

