/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class UnboundedFifoPool<T> {
    ObjectArrayList<T> array;
    private int tailIndex = 0;
    private int headIndex = 0;
    int numElements = 0;
    private int capacity;

    public UnboundedFifoPool(int capacity) {
        this.array = new ObjectArrayList(capacity);
    }

    public UnboundedFifoPool() {
        this.array = new ObjectArrayList();
    }

    public final void add(T element) {
        ++this.numElements;
        this.capacity = Math.max(this.capacity, this.tailIndex + 1);
        while (this.array.size() <= this.capacity) {
            this.array.add(null);
        }
        this.array.set(this.tailIndex, element);
        this.advanceTailIndex();
    }

    public final T remove() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot remove element from empty pool");
        }
        Object element = this.array.get(this.headIndex);
        this.advanceHeadIndex();
        --this.numElements;
        if (this.isEmpty()) {
            this.headIndex = 0;
            this.tailIndex = 0;
        }
        return (T)element;
    }

    private void advanceHeadIndex() {
        this.headIndex = this.headIndex % this.capacity + 1;
    }

    private void advanceTailIndex() {
        this.tailIndex = this.tailIndex % this.capacity + 1;
    }

    public final boolean isEmpty() {
        return this.numElements == 0;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.remove();
        }
        this.array.size(0);
        this.array.trim();
    }

    public int size() {
        return this.numElements;
    }
}

