/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.campagnelab.goby.reads.ReadSet;
import org.campagnelab.goby.reads.Reads;
import org.campagnelab.goby.reads.ReadsReader;
import org.campagnelab.goby.reads.SequenceDigests;

public class ReadsLoader {
    private final ReadSet readIndexFilter;
    private SequenceDigests[] digests;
    private final ObjectArrayList<byte[]> compressedReads;
    private int numReads;
    private final File readsFile;
    private static final int MAX_PROCESS_READS = Integer.MAX_VALUE;
    private int readLength;
    private byte[] byteBuffer;
    private final int numberOfMismaches = 0;
    private boolean colorSpace;

    public int getReadLength() {
        return this.readLength;
    }

    public ReadsLoader(ReadSet readIndexFilter, File readsFile) {
        this.readIndexFilter = readIndexFilter;
        this.compressedReads = new ObjectArrayList(1000000);
        this.readsFile = readsFile;
    }

    public void setColorSpace(boolean colorSpace) {
        this.colorSpace = colorSpace;
    }

    public int read() throws IOException {
        ProgressLogger progress = new ProgressLogger();
        progress.displayFreeMemory = true;
        progress.start((CharSequence)"parsing reads");
        ReadsReader readsReader = new ReadsReader(new FileInputStream(this.readsFile));
        int maxReadLength = 0;
        int minReadLength = Integer.MAX_VALUE;
        for (Reads.ReadEntry readEntry : readsReader) {
            if (this.readIndexFilter == null || this.readIndexFilter.contains(readEntry.getReadIndex())) {
                maxReadLength = Math.max(maxReadLength, readEntry.getReadLength());
                if ((minReadLength = Math.min(minReadLength, readEntry.getReadLength())) != maxReadLength) {
                    System.err.println("The read length must be fixed.");
                    System.exit(1);
                }
                if (this.digests == null) {
                    this.digests = new SequenceDigests[2];
                    this.digests[0] = new SequenceDigests(minReadLength, true);
                    this.digests[1] = new SequenceDigests(minReadLength, false);
                }
                this.byteBuffer = new byte[maxReadLength];
                int readIndex = readEntry.getReadIndex();
                byte[] bytes = readEntry.getSequence().toByteArray();
                for (SequenceDigests digest : this.digests) {
                    digest.digestAndStore(bytes, 0, readIndex);
                }
                System.arraycopy(bytes, 0, this.byteBuffer, 0, maxReadLength);
                if (readIndex > this.compressedReads.size() - 1) {
                    this.compressedReads.size((readIndex + 1) * 3 / 2);
                }
                this.compressedReads.set(readIndex, (Object)this.byteBuffer);
                progress.lightUpdate();
                if (this.numReads > Integer.MAX_VALUE) break;
            }
            ++this.numReads;
        }
        this.readLength = minReadLength;
        this.compressedReads.size(this.numReads + 1);
        readsReader.close();
        progress.stop((CharSequence)"Finished parsing reads.");
        return this.numReads;
    }

    public ObjectList<byte[]> getCompressedReads() {
        return this.compressedReads;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public SequenceDigests[] getDigests() {
        return this.digests;
    }
}

