/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.OutputStream;
import org.campagnelab.goby.compression.FastArithmeticCoder;
import org.campagnelab.goby.compression.FastArithmeticDecoder;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.reads.Reads;

public class ReadCodec2
implements ReadCodec {
    private FastArithmeticCoder sequenceCoder;
    private FastArithmeticCoder qualityScoreCoder;
    public static final int CODEC_REGISTRATION_CODE = 2;
    private boolean isFirst;
    FastByteArrayOutputStream os = new FastByteArrayOutputStream();
    OutputBitStream out = new OutputBitStream((OutputStream)this.os);
    private FastArithmeticDecoder sequenceDecoder;
    private FastArithmeticDecoder qualityScoreDecoder;

    @Override
    public String name() {
        return "read-codec-2";
    }

    @Override
    public byte registrationCode() {
        return 2;
    }

    @Override
    public Reads.ReadEntry.Builder encode(Reads.ReadEntry.Builder source) {
        Reads.ReadEntry.Builder result = Reads.ReadEntry.newBuilder();
        result.mergeFrom(source.build());
        try {
            this.out.flush();
            this.os.reset();
            if (!this.isFirst) {
                this.out.writeInt(2, 8);
            }
            if (source.hasSequence()) {
                this.writeBit(this.out, true);
                this.compressSequence(source.getSequence(), this.out);
                result.clearSequence();
            } else {
                this.writeBit(this.out, false);
            }
            if (source.hasQualityScores()) {
                this.writeBit(this.out, true);
                this.compressQuality(source.getQualityScores(), this.out);
                result.clearQualityScores();
            } else {
                this.writeBit(this.out, false);
            }
            if (source.hasSequencePair()) {
                this.writeBit(this.out, true);
                this.compressSequence(source.getSequencePair(), this.out);
                result.clearSequencePair();
            } else {
                this.writeBit(this.out, false);
            }
            if (source.hasQualityScoresPair()) {
                this.writeBit(this.out, true);
                this.compressQuality(source.getQualityScoresPair(), this.out);
                result.clearQualityScoresPair();
            } else {
                this.writeBit(this.out, false);
            }
            this.out.flush();
            ByteString compressedData = ByteString.copyFrom((byte[])this.os.array, (int)0, (int)((int)this.os.length()));
            result.setCompressedData(compressedData);
            this.isFirst = false;
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void writeBit(OutputBitStream out, boolean bit) throws IOException {
        out.writeBit(bit);
    }

    private void compressQuality(ByteString qualityScores, OutputBitStream out) throws IOException {
        int i;
        int first;
        byte[] quals = qualityScores.toByteArray();
        int previous = first = quals[0];
        int max = first;
        for (i = 1; i < quals.length; ++i) {
            max = Math.max(quals[i], max);
        }
        out.writeInt(max, 8);
        for (i = 0; i < quals.length; ++i) {
            int delta = max - quals[i];
            long bits = out.writtenBits();
            out.writeGamma(delta);
            long newbits = out.writtenBits();
            previous = quals[i];
        }
    }

    private ByteString decodeQualityScore(InputBitStream input, int readLength) throws IOException {
        byte first;
        ByteArrayList buffer = new ByteArrayList(readLength);
        byte previous = first = (byte)input.readInt(8);
        for (int i = 0; i < readLength; ++i) {
            int delta = input.readGamma();
            int newQual = this.bijectionReverse(delta) + previous;
            buffer.add((byte)newQual);
        }
        return ByteString.copyFrom((byte[])buffer.toByteArray());
    }

    private int bijectionForward(int x) {
        if (x > 0) {
            return x << 1;
        }
        return -x << 2;
    }

    private int bijectionReverse(int y) {
        if ((y & 1) != 0) {
            return y >> 1;
        }
        return -(y >> 1);
    }

    private void compressSequence(ByteString sequence, OutputBitStream out) throws IOException {
        for (int i = 0; i < sequence.size(); ++i) {
            this.sequenceCoder.encode(this.codeBase(sequence.byteAt(i)), out);
        }
        this.sequenceCoder.flush(out);
    }

    private int codeBase(byte base) {
        switch (base) {
            case 65: {
                return 0;
            }
            case 67: {
                return 1;
            }
            case 84: {
                return 2;
            }
            case 71: {
                return 3;
            }
            case 78: {
                return 4;
            }
        }
        return -1;
    }

    private byte decodeBase(int decode) {
        switch (decode) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 84;
            }
            case 3: {
                return 71;
            }
            case 4: {
                return 78;
            }
        }
        return -1;
    }

    @Override
    public Reads.ReadEntry.Builder decode(Reads.ReadEntry source) {
        if (!source.hasCompressedData()) {
            return null;
        }
        InputBitStream input = new InputBitStream(source.getCompressedData().toByteArray());
        try {
            int codecRegistrationStored;
            if (this.isFirst && (codecRegistrationStored = input.readInt(8)) != 2) {
                return null;
            }
            Reads.ReadEntry.Builder result = Reads.ReadEntry.newBuilder();
            result.mergeFrom(source);
            if (input.readBit() == 1) {
                ByteString sequence = this.decodeSequence(input, source.getReadLength());
                result.setSequence(sequence);
            }
            if (input.readBit() == 1) {
                ByteString qual = this.decodeQualityScore(input, source.getReadLength());
                result.setQualityScores(qual);
            }
            if (input.readBit() == 1) {
                ByteString sequencePair = this.decodeSequence(input, source.getReadLength());
                result.setSequencePair(sequencePair);
            }
            if (input.readBit() == 1) {
                ByteString qualPair = this.decodeSequence(input, source.getReadLength());
                result.setQualityScoresPair(qualPair);
            }
            result.clearCompressedData();
            this.isFirst = false;
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final void newChunk() {
        this.sequenceCoder = new FastArithmeticCoder(5);
        this.sequenceDecoder = new FastArithmeticDecoder(5);
        this.qualityScoreCoder = new FastArithmeticCoder(255);
        this.qualityScoreDecoder = new FastArithmeticDecoder(255);
        this.isFirst = true;
    }

    public ReadCodec2() {
        this.newChunk();
    }

    private ByteString decodeSequence(InputBitStream input, int readLength) throws IOException {
        ByteArrayList buffer = new ByteArrayList(readLength);
        for (int i = 0; i < readLength; ++i) {
            buffer.add(this.decodeBase(this.sequenceDecoder.decode(input)));
        }
        return ByteString.copyFrom((byte[])buffer.toByteArray());
    }
}

