/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.processors;

import com.google.protobuf.ByteString;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ConcatSortedAlignmentReader;
import org.campagnelab.goby.alignments.processors.AlignmentProcessorInterface;
import org.campagnelab.goby.alignments.processors.DummyGenomeAlignmentTargetMapper;
import org.campagnelab.goby.alignments.processors.GenomeAlignmentTargetMapper;
import org.campagnelab.goby.alignments.processors.InfoForTarget;
import org.campagnelab.goby.alignments.processors.ObservedIndel;
import org.campagnelab.goby.alignments.processors.SkipToIterator;
import org.campagnelab.goby.alignments.processors.SkipToListIterator;
import org.campagnelab.goby.alignments.processors.SkipToSortedReader;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.util.KnownIndelSet;
import org.campagnelab.goby.util.WarningCounter;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealignmentProcessor
implements AlignmentProcessorInterface {
    @RegisterThis
    public static final DynamicOptionClient doc = new DynamicOptionClient(RealignmentProcessor.class, "known-indel-set:path to set of known indels generated by VCFToKnownIndelsMode");
    private IndexedIdentifier targetIdentifiers;
    int windowLength = 0;
    int currentTargetIndex = -1;
    private int numTargets;
    private KnownIndelSet knownIndels;
    private int processedCount;
    private int numEntriesRealigned;
    private GenomeAlignmentTargetMapper targetMapper;
    private int previousActiveTargetIndex = -1;
    private IntSortedSet activeTargetIndices = new IntAVLTreeSet();
    private WarningCounter genomeNull = new WarningCounter(2);
    private ObjectArrayList<InfoForTarget> targetInfo = new ObjectArrayList();
    private final SkipToIterator iterator;
    private RandomAccessSequenceInterface genome;
    int enqueuedCount = 0;
    private final boolean[] directions = new boolean[]{true, false};
    private static final Logger LOG = LoggerFactory.getLogger(RealignmentProcessor.class);

    public static final DynamicOptionClient doc() {
        return doc;
    }

    @Override
    public int getModifiedCount() {
        return this.numEntriesRealigned;
    }

    @Override
    public int getProcessedCount() {
        return this.processedCount;
    }

    private void initalizeKnownIndels() {
        String knownIndelsPath = doc.getString("known-indel-set");
        if (knownIndelsPath != null && knownIndelsPath.length() > 0) {
            try {
                this.knownIndels = new KnownIndelSet(knownIndelsPath);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Error loading known indel set: " + knownIndelsPath);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Error findind KnownIndelSetCreator class.");
            }
        }
    }

    public RealignmentProcessor(ConcatSortedAlignmentReader sortedReaders) {
        this.targetIdentifiers = sortedReaders.getTargetIdentifiers();
        this.iterator = new SkipToSortedReader(sortedReaders);
        this.numTargets = sortedReaders.getNumberOfTargets();
        this.targetInfo = new ObjectArrayList(this.numTargets);
        this.initalizeKnownIndels();
    }

    public RealignmentProcessor(ObjectListIterator<Alignments.AlignmentEntry> entryIterator) {
        this.iterator = new SkipToListIterator(entryIterator);
        this.initalizeKnownIndels();
    }

    @Override
    public Alignments.AlignmentEntry nextRealignedEntry(int targetIndex, int position) throws IOException {
        int windowStartPosition;
        int previousWindowStart;
        boolean mustLoadPool;
        if (this.activeTargetIndices.isEmpty()) {
            mustLoadPool = true;
        } else {
            InfoForTarget backTargetInfo = (InfoForTarget)this.targetInfo.get(this.activeTargetIndices.firstInt());
            InfoForTarget frontTargetInfo = (InfoForTarget)this.targetInfo.get(this.activeTargetIndices.lastInt());
            int wl = this.windowLength == 0 ? 1000 : this.windowLength;
            boolean bl = mustLoadPool = backTargetInfo.entriesInWindow.isEmpty() || this.currentTargetIndex == -1 || this.activeTargetIndices.firstInt() == this.currentTargetIndex && backTargetInfo.maxEntryPosition < backTargetInfo.windowStartPosition + wl || this.activeTargetIndices.lastInt() > this.currentTargetIndex && frontTargetInfo.entriesInWindow.isEmpty();
        }
        if (mustLoadPool) {
            Alignments.AlignmentEntry entry;
            int windowStartPosition2 = Integer.MAX_VALUE;
            int minTargetIndex = Integer.MAX_VALUE;
            do {
                if ((entry = this.iterator.skipTo(targetIndex, position)) != null) {
                    int entryTargetIndex = entry.getTargetIndex();
                    this.currentTargetIndex = minTargetIndex = Math.min(minTargetIndex, entry.getTargetIndex());
                    if (this.activeTargetIndices.isEmpty() || this.activeTargetIndices.lastInt() != entryTargetIndex) {
                        this.activeTargetIndices.add(entryTargetIndex);
                    }
                    InfoForTarget frontInfo = this.reallocateTargetInfo(entryTargetIndex);
                    this.pushEntryToPool(frontInfo, position, entry);
                    windowStartPosition2 = frontInfo.windowStartPosition;
                    continue;
                }
                if (!this.activeTargetIndices.isEmpty()) continue;
                this.targetInfo.clear();
                return null;
            } while (entry != null && entry.getTargetIndex() == this.activeTargetIndices.firstInt() && entry.getPosition() < windowStartPosition2 + this.windowLength);
        }
        int backTargetIndex = this.activeTargetIndices.firstInt();
        while (((InfoForTarget)this.targetInfo.get((int)backTargetIndex)).entriesInWindow.isEmpty()) {
            this.activeTargetIndices.rem(backTargetIndex);
            ((InfoForTarget)this.targetInfo.get(backTargetIndex)).clear();
            if (this.activeTargetIndices.isEmpty()) {
                this.targetInfo.clear();
                return null;
            }
            backTargetIndex = this.activeTargetIndices.firstInt();
        }
        InfoForTarget backInfo = (InfoForTarget)this.targetInfo.get(backTargetIndex);
        if (backInfo.entriesInWindow.isEmpty() && this.activeTargetIndices.isEmpty()) {
            this.targetInfo.clear();
            return null;
        }
        Alignments.AlignmentEntry returnedEntry = backInfo.remove();
        if (backInfo.positionsWithSpanningIndel.size() > 0) {
            returnedEntry = this.realign(returnedEntry, backInfo);
        }
        if (returnedEntry.getTargetIndex() > this.currentTargetIndex) {
            for (int i = 0; i < returnedEntry.getTargetIndex(); ++i) {
                this.pruneTargetInfo(i);
            }
        }
        if ((previousWindowStart = backInfo.windowStartPosition) != (windowStartPosition = Math.max(backInfo.windowStartPosition, returnedEntry.getPosition()))) {
            int lastPosition = windowStartPosition - 1;
            backInfo.removeIndels(previousWindowStart, lastPosition);
        }
        backInfo.windowStartPosition = windowStartPosition;
        ++this.processedCount;
        return returnedEntry;
    }

    private void pruneTargetInfo(int targetIndex) {
        ((InfoForTarget)this.targetInfo.get(targetIndex)).clear();
    }

    private InfoForTarget reallocateTargetInfo(int targetIndex) {
        int intermediateTargetIndex = this.targetInfo.size() - 1;
        while (intermediateTargetIndex <= targetIndex) {
            if (this.knownIndels != null) {
                try {
                    this.targetInfo.add((Object)new InfoForTarget(++intermediateTargetIndex, this.knownIndels.getAllIndelsInChrom(this.targetMapper.getAlignmentId(this.currentTargetIndex))));
                }
                catch (NullPointerException e) {
                    System.out.println("There is something wrong with the indel set. Perhaps it is aligned to a different genome than the reads?");
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                this.targetInfo.add((Object)new InfoForTarget(++intermediateTargetIndex));
            }
            this.numTargets = this.targetInfo.size();
        }
        return (InfoForTarget)this.targetInfo.get(targetIndex);
    }

    private Alignments.AlignmentEntry realign(Alignments.AlignmentEntry entry, InfoForTarget tinfo) {
        int currentBestScore = 0;
        ObservedIndel bestScoreIndel = null;
        boolean bestScoreDirection = false;
        for (ObservedIndel indel : tinfo.potentialIndels) {
            if (!this.entryOverlapsIndel(indel, entry)) continue;
            for (boolean direction : this.directions) {
                int realignedScore = this.score(entry, indel, direction, currentBestScore, this.genome);
                if (realignedScore <= currentBestScore) continue;
                currentBestScore = realignedScore;
                bestScoreIndel = indel;
                bestScoreDirection = direction;
            }
        }
        if (currentBestScore <= 0) {
            return entry;
        }
        ++this.numEntriesRealigned;
        return this.realign(entry, bestScoreIndel, bestScoreDirection, currentBestScore);
    }

    private boolean entryOverlapsIndel(ObservedIndel indel, Alignments.AlignmentEntry entry) {
        int entryStart = entry.getPosition();
        int entryEnd = entryStart + entry.getTargetAlignedLength();
        int indelStart = indel.getStart();
        int indelEnd = indel.getEnd();
        return entryStart <= indelStart && indelEnd <= entryEnd || entryStart < indelEnd && entryEnd > indelStart || entryEnd > indelStart && entryStart < indelEnd;
    }

    private Alignments.AlignmentEntry realign(Alignments.AlignmentEntry entry, ObservedIndel indel, boolean shiftForward, int scoreDelta) {
        int direction;
        int entryPosition;
        Alignments.AlignmentEntry.Builder builder = Alignments.AlignmentEntry.newBuilder(entry);
        builder.setScore(entry.getScore() + (float)scoreDelta);
        int indelLength = indel.positionSpan();
        int zeroWhenReadInsertion = 1;
        if (indel.isReadInsertion()) {
            zeroWhenReadInsertion = 0;
        }
        builder.setTargetAlignedLength(builder.getTargetAlignedLength() + indelLength * zeroWhenReadInsertion);
        int originalEntryPosition = entryPosition = entry.getPosition();
        if (!shiftForward && indel.isReferenceInsertion()) {
            entryPosition = entry.getPosition() - indelLength;
            builder.setPosition(entryPosition);
        }
        int indelOffsetInAlignment = indel.getStart() - entryPosition;
        int varCount = entry.getSequenceVariationsCount();
        int targetIndex = entry.getTargetIndex();
        int score = 0;
        int n = direction = shiftForward ? 1 : -1;
        if (this.genome == null) {
            this.genomeNull.warn(LOG, "Genome must not be null outside of Junit tests.", new Object[0]);
            return entry;
        }
        IntArraySet variantPositions = new IntArraySet();
        ObjectArrayList rewrittenVariations = new ObjectArrayList();
        for (int i = 0; i < varCount; ++i) {
            Alignments.SequenceVariation var = entry.getSequenceVariations(i);
            int newGenomicPosition = var.getPosition() + direction * indelLength * zeroWhenReadInsertion + originalEntryPosition - 1;
            for (int j = 0; j < var.getTo().length(); ++j) {
                boolean compatible;
                char toBase = var.getTo().charAt(j);
                int index = newGenomicPosition + j;
                if (index < 0 || index > this.genome.getLength(this.targetMapper.toGenome(targetIndex))) {
                    score -= 10;
                    continue;
                }
                boolean bl = compatible = this.genome.get(this.targetMapper.toGenome(targetIndex), newGenomicPosition + j) == toBase;
                if (!compatible) {
                    rewrittenVariations.add((Object)var);
                }
                variantPositions.add(var.getPosition() + entryPosition + j - 1);
            }
        }
        if (indel.isReadInsertion()) {
            zeroWhenReadInsertion = 0;
        }
        int startAlignment = shiftForward ? entryPosition + indelOffsetInAlignment : entryPosition;
        int endAlignment = shiftForward ? entry.getTargetAlignedLength() + entryPosition : indelOffsetInAlignment + entryPosition + direction * indelLength * zeroWhenReadInsertion;
        for (int pos = startAlignment; pos < endAlignment; ++pos) {
            int genomeTargetIndex;
            if (variantPositions.contains(pos)) continue;
            int realignedPos = pos + direction * indelLength * zeroWhenReadInsertion;
            if (realignedPos >= 0) {
                char toBase;
                boolean compatible;
                genomeTargetIndex = this.targetMapper.toGenome(targetIndex);
                char fromBase = this.genome.get(genomeTargetIndex, realignedPos);
                boolean bl = compatible = fromBase == (toBase = this.genome.get(genomeTargetIndex, pos));
                if (compatible) continue;
                Alignments.SequenceVariation.Builder varBuilder = Alignments.SequenceVariation.newBuilder();
                int varPosition = direction * (realignedPos - entryPosition) + 1;
                varBuilder.setPosition(varPosition);
                varBuilder.setFrom(Character.toString(fromBase));
                varBuilder.setTo(Character.toString(toBase));
                varBuilder.setToQuality(this.byteArray(127));
                int readIndex = entry.getMatchingReverseStrand() ? entry.getQueryLength() - indelOffsetInAlignment + (shiftForward ? 1 : indelLength) : varPosition;
                varBuilder.setReadIndex(readIndex);
                rewrittenVariations.add((Object)varBuilder.build());
                continue;
            }
            genomeTargetIndex = this.targetMapper.toGenome(targetIndex);
            LOG.warn(String.format("Realigned position cannot be negative. Ignoring this entry: %s%nError encountered at targetIndex=%d targetId=%s pos=%d %n", entry.toString(), targetIndex, this.genome.getReferenceName(genomeTargetIndex), pos));
            return entry;
        }
        Alignments.SequenceVariation.Builder varBuilder = Alignments.SequenceVariation.newBuilder();
        int varPosition = shiftForward ? indelOffsetInAlignment + 1 : indel.getStart() - entryPosition + 1;
        varBuilder.setPosition(varPosition);
        varBuilder.setFrom(indel.from);
        varBuilder.setTo(indel.to);
        int readIndex = entry.getMatchingReverseStrand() ? entry.getQueryLength() - indelOffsetInAlignment + (shiftForward ? 1 : indelLength) : varPosition;
        varBuilder.setReadIndex(readIndex);
        rewrittenVariations.add((Object)varBuilder.build());
        builder = builder.clearSequenceVariations();
        for (Alignments.SequenceVariation var : rewrittenVariations) {
            builder = builder.addSequenceVariations(var);
        }
        Alignments.AlignmentEntry alignmentEntry = builder.build();
        return alignmentEntry;
    }

    private ByteString byteArray(byte ... a) {
        return ByteString.copyFrom((byte[])a);
    }

    public final int score(Alignments.AlignmentEntry entry, ObservedIndel indel, boolean shiftForward, int currentBestScore, RandomAccessSequenceInterface genome) {
        int entryPosition = entry.getPosition();
        int indelOffsetInAlignment = indel.getStart() - entryPosition;
        int indelLength = indel.positionSpan();
        int varCount = entry.getSequenceVariationsCount();
        int targetIndex = entry.getTargetIndex();
        int score = 0;
        int direction = shiftForward ? 1 : -1;
        int genomeTargetIndex = this.targetMapper.toGenome(targetIndex);
        if (genomeTargetIndex == -1) {
            throw new RuntimeException(String.format("alignment target index  %d (chromosome %s) has no equivalent in the genome.", targetIndex, this.targetMapper.getAlignmentId(targetIndex)));
        }
        if (genome == null) {
            this.genomeNull.warn(LOG, "Genome must not be null outside of JUnit tests.", new Object[0]);
            return Integer.MIN_VALUE;
        }
        int zeroWhenReadInsertion = 1;
        boolean readInsertion = indel.isReadInsertion();
        if (readInsertion) {
            zeroWhenReadInsertion = 0;
        }
        int targetLength = genome.getLength(genomeTargetIndex);
        IntArraySet variantPositions = new IntArraySet();
        for (int i = 0; i < varCount; ++i) {
            Alignments.SequenceVariation var = entry.getSequenceVariations(i);
            int newGenomicPosition = var.getPosition() + direction * indelLength * zeroWhenReadInsertion + entryPosition - 1;
            for (int j = 0; j < var.getTo().length(); ++j) {
                if (var.getFrom().charAt(j) == '-') {
                    --score;
                    continue;
                }
                char toBase = var.getTo().charAt(j);
                int index = newGenomicPosition + j;
                if (index < 0 || index > genome.getLength(genomeTargetIndex)) {
                    score -= 20;
                    continue;
                }
                boolean compatible = genome.get(genomeTargetIndex, newGenomicPosition + j) == toBase;
                score += compatible ? 1 : -1;
                variantPositions.add(var.getPosition() + entryPosition + j - 1);
            }
        }
        if (score <= currentBestScore) {
            return score;
        }
        if (readInsertion) {
            zeroWhenReadInsertion = 0;
        }
        int startAlignment = shiftForward ? entryPosition + indelOffsetInAlignment : entryPosition;
        int endAlignment = shiftForward ? entry.getTargetAlignedLength() + entryPosition : indelOffsetInAlignment + entryPosition + direction * indelLength * zeroWhenReadInsertion;
        endAlignment = Math.min(endAlignment, genome.getLength(genomeTargetIndex) - 1);
        for (int currentPositionOnReference = startAlignment; currentPositionOnReference < endAlignment; ++currentPositionOnReference) {
            char newRefBase;
            char refBase;
            if (variantPositions.contains(currentPositionOnReference)) continue;
            int realignedPosOnReference = currentPositionOnReference + direction * indelLength;
            score = realignedPosOnReference < 0 || realignedPosOnReference >= targetLength ? (score -= 10) : (score += (refBase = genome.get(genomeTargetIndex, currentPositionOnReference)) == (newRefBase = genome.get(genomeTargetIndex, realignedPosOnReference)) ? 0 : -1);
            if (score > currentBestScore) continue;
            return score;
        }
        return score;
    }

    private String getGenomeSegment(RandomAccessSequenceInterface genome, int targetIndex, int startAlignment, int endAlignment) {
        MutableString sequence = new MutableString();
        for (int pos = startAlignment; pos < endAlignment; ++pos) {
            sequence.append(genome.get(this.targetMapper.toAlignment(targetIndex), pos));
        }
        return sequence.toString();
    }

    public void pushEntryToPool(InfoForTarget tinfo, int position, Alignments.AlignmentEntry entry) {
        int entryPosition = entry.getPosition();
        tinfo.windowStartPosition = Math.min(tinfo.windowStartPosition, entryPosition);
        tinfo.maxEntryPosition = Math.max(tinfo.maxEntryPosition, entryPosition);
        this.windowLength = Math.max(this.windowLength, entry.getQueryLength() * 2);
        for (int i = 0; i < entry.getSequenceVariationsCount(); ++i) {
            Alignments.SequenceVariation var = entry.getSequenceVariations(i);
            if (!this.isIndel(var)) continue;
            int startPosition = var.getPosition() + entryPosition - 1;
            int lastPosition = var.getPosition() + entryPosition + Math.max(var.getFrom().length(), var.getTo().length()) - 1;
            tinfo.addIndel(startPosition, lastPosition, var.getFrom(), var.getTo());
        }
        this.enqueuedCount += tinfo.add(entry) ? 1 : 0;
    }

    private boolean isIndel(Alignments.SequenceVariation var) {
        return var.getFrom().indexOf(45) >= 0 || var.getTo().indexOf(45) >= 0;
    }

    public void setGenome(RandomAccessSequenceInterface genome) {
        this.genome = genome;
        this.targetMapper = new DummyGenomeAlignmentTargetMapper(genome);
    }

    @Override
    public void setGenome(RandomAccessSequenceInterface genome, IndexedIdentifier targetIdentifiers) {
        this.genome = genome;
        assert (targetIdentifiers != null) : "Target identifiers must be initialized";
        this.targetMapper = new GenomeAlignmentTargetMapper(targetIdentifiers, genome);
    }
}

